/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementEmblem
extends Item
implements IElementItem,
IMageMiconEntryItem {
    private Element element;

    public ElementEmblem(Element element) {
        super(new Item.Properties().m_41487_(1));
        this.element = element;
    }

    @Override
    public Element getElement(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        String currentElement = tag.m_128461_("etheria$element");
        if (currentElement.isEmpty()) {
            return this.getElement();
        }
        return Element.valueOf(currentElement.toUpperCase());
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand p_41434_) {
        ItemStack itemstack = player.m_21120_(p_41434_);
        if (player.m_6144_()) {
            String currentElement;
            CompoundTag tag = itemstack.m_41784_();
            Element nextElement = switch (currentElement = tag.m_128461_("etheria$element")) {
                case "CRYO" -> Element.PYRO;
                case "PYRO" -> Element.ETHER;
                case "ETHER" -> Element.CRYO;
                default -> Element.CRYO;
            };
            tag.m_128359_("etheria$element", nextElement.name());
            itemstack.m_41751_(tag);
            player.m_5661_((Component)Component.m_237110_((String)"etheria.emblem.switched", (Object[])new Object[]{Component.m_237115_((String)("etheria.element." + nextElement.name().toLowerCase())).getString()}), true);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_6883_(ItemStack itemstack, Level level, @NotNull Entity player, int p_41407_, boolean p_41408_) {
        super.m_6883_(itemstack, level, player, p_41407_, p_41408_);
        Level level2 = player.m_9236_();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level2;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.m_21205_() == itemstack || serverPlayer.m_21206_() == itemstack) {
            Element dungeonElement;
            ResourceKey key;
            Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
            Optional<HolderSet> optional = structureRegistry.m_203636_(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("etheria", (dungeonElement = this.getElement(itemstack)).name().toLowerCase() + (dungeonElement.equals((Object)Element.ETHER) ? "_tree" : "")))).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0}));
            if (optional.isEmpty()) {
                return;
            }
            Pair nearestStructure = serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, optional.get(), player.m_20183_(), 100, false);
            if (nearestStructure == null || nearestStructure.getFirst() == null) {
                return;
            }
            BlockPos structurePos = (BlockPos)nearestStructure.getFirst();
            BlockPos topPos = new BlockPos(structurePos.m_123341_(), player.m_20183_().m_123342_(), structurePos.m_123343_());
            double distance = player.m_20183_().m_123331_((Vec3i)structurePos);
            double normalizedSize = Math.max(0.1, Math.min(0.2, 0.2 - distance / 10000.0));
            double posDistance = Math.sqrt(Math.pow((double)structurePos.m_123341_() - player.m_20185_(), 2.0) + Math.pow(0.0, 2.0) + Math.pow((double)structurePos.m_123343_() - player.m_20189_(), 2.0));
            if (posDistance < 3.0) {
                String translationKey = "";
                if (dungeonElement.equals((Object)Element.CRYO)) {
                    translationKey = "etheria.message.cryo";
                } else if (dungeonElement.equals((Object)Element.PYRO)) {
                    translationKey = "etheria.message.pyro";
                } else if (dungeonElement.equals((Object)Element.ETHER)) {
                    translationKey = "etheria.message.ether";
                }
                if (!translationKey.isEmpty()) {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)translationKey).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(dungeonElement).getRGB())), true);
                }
            }
            ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(this.getElement(itemstack)), (float)normalizedSize + 0.1f, 40, 0.025f), level, player.m_20318_(0.0f).m_82520_(0.0, 1.0, 0.0), topPos.m_252807_(), 4, 0.8f, 1.0f, 2.0f);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            tooltip.add((Component)Component.m_237115_((String)"etheria.shift").m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(this.getElement(stack)).getRGB())));
        } else {
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(this.getElement(stack)).getRGB())));
        }
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("items", "elemental_compass");
    }
}

