/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import com.google.common.collect.Lists;
import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherTabEntry;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.AddToastPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElementaryScrollItem
extends Item
implements IEtherTabEntry,
IElementItem,
IMageMiconEntryItem {
    private Element element;

    public ElementaryScrollItem(Element element) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
        this.element = element;
    }

    @Override
    public List<ItemStack> etherTab() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.m_7968_()});
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 40;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_36335_().m_41519_((Item)this) || worldIn.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (world.m_5776_() || !(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), 100);
        }
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_276532_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (Arrays.stream(Element.values()).toList().contains((Object)ElementsUtils.getElement(ElementaryScrollItem.getElementFromRegistryObjectId(stack.m_41720_()).toUpperCase()))) {
            ElementsUtils.setElement((Player)player, ElementaryScrollItem.getElementFromRegistryObjectId(stack.m_41720_()).toUpperCase());
        }
        stack.m_41774_(1);
        AchievementHandler.grantAdvancement(player, "scroll");
        EtheriaCapability cap = CapabilityRegistry.getCap((Player)player);
        if (!cap.getElements().contains((Object)this.element)) {
            cap.getElements().add(this.element);
            SyncCapabilityManager.sync((Player)player);
            Networking.sendToClient(player, new AddToastPacket(this.m_7968_(), Component.m_237115_((String)"etheria.new_element").getString() + ":\n\u00a7l" + Component.m_237115_((String)("etheria.element." + this.element.name().toLowerCase())).getString()));
        }
        return stack;
    }

    public static String getElementFromRegistryObjectId(Item item) {
        String id = item.m_5524_();
        String[] parts = id.split("_");
        return parts[parts.length - 1];
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        double extraY;
        double extraZ;
        double extraX;
        float verticalOffset;
        float angle;
        int i;
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Color color = ElementsUtils.getColorByElement(ElementsUtils.getElementFromItemId(stack));
        float radius = (float)count * 0.08f;
        float baseY = (float)(entity.m_20186_() + 1.5);
        int steps = 6;
        for (i = 0; i < steps; ++i) {
            angle = 0.02f * (float)(count * 2 + i * 90);
            verticalOffset = i % 2 == 0 ? 0.3f : -0.3f;
            extraX = (double)(radius * Mth.m_14031_((float)angle)) + entity.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + entity.m_20189_();
            extraY = baseY + verticalOffset;
            serverLevel.m_8767_((ParticleOptions)new GlowingParticleData(color, Math.max(0.2f, (float)(this.m_8105_(stack) - count) * 0.015f), 40, 0.02f), extraX, extraY - 0.25, extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < steps; ++i) {
            angle = 0.02f * (float)(-count * 2 + i * 90);
            verticalOffset = i % 2 == 0 ? -0.3f : 0.3f;
            extraX = (double)(radius * Mth.m_14031_((float)angle)) + entity.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + entity.m_20189_();
            extraY = baseY + verticalOffset;
            serverLevel.m_8767_((ParticleOptions)new GlowingParticleData(color, Math.max(0.2f, (float)(this.m_8105_(stack) + count) * 0.015f), 40, 0.02f), extraX, extraY - 0.25, extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("basics", "elements_fundamentals");
    }
}

