/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import com.google.common.collect.Lists;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherTabEntry;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EtherUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtherMirrorItem
extends Item
implements IEtherTabEntry,
IElementItem,
IMageMiconEntryItem {
    public EtherMirrorItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    @Override
    public List<ItemStack> etherTab() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.m_7968_()});
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 40;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (level.m_46472_().equals((Object)Level.f_46428_)) {
                stack.m_41784_().m_128405_("etheria$tp_x", player.m_20097_().m_123341_());
                stack.m_41784_().m_128405_("etheria$tp_y", player.m_20097_().m_123342_() + 1);
                stack.m_41784_().m_128405_("etheria$tp_z", player.m_20097_().m_123343_());
                player.m_5661_((Component)Component.m_237110_((String)"etheria.message.ether_mirror_coordinates", (Object[])new Object[]{player.m_20097_().m_123341_(), player.m_20097_().m_123342_() + 1, player.m_20097_().m_123343_()}), true);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)"etheria.message.ether_mirror_on_level"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int reqEther = 100;
        ItemStack etherItem = EtherUtils.findEtherVessel(player, reqEther);
        int etherCount = EtherUtils.getEther(etherItem);
        if (etherCount <= 0 || etherCount < reqEther) {
            player.m_5661_((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.rituals.warn.ether").getString() + ": " + reqEther + ".")), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_36335_().m_41519_((Item)this) || level.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, @NotNull LivingEntity entity) {
        if (world.m_5776_() || !(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int x = stack.m_41784_().m_128451_("etheria$tp_x");
        int y = stack.m_41784_().m_128451_("etheria$tp_y");
        int z = stack.m_41784_().m_128451_("etheria$tp_z");
        if (x == 0 && y == 0 && z == 0) {
            player.m_36335_().m_41524_(stack.m_41720_(), 60);
            world.m_5594_(null, player.m_20183_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return stack;
        }
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), 4000);
        }
        player.m_8999_((ServerLevel)world, (double)x + 0.5, (double)y, (double)z + 0.5, player.m_146908_(), player.m_146909_());
        int reqEther = 100;
        ItemStack etherItem = EtherUtils.findEtherVessel((Player)player, reqEther);
        int etherCount = EtherUtils.getEther(etherItem);
        EtherUtils.setEther(etherItem, etherCount - reqEther);
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_276532_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return stack;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        double extraY;
        double extraZ;
        double extraX;
        float verticalOffset;
        float angle;
        int i;
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Color color = ElementsUtils.getColorByElement(this.getElement());
        float radius = (float)count * 0.08f;
        float baseY = (float)(entity.m_20186_() + 1.5);
        int steps = 6;
        for (i = 0; i < steps; ++i) {
            angle = 0.02f * (float)(count * 2 + i * 90);
            verticalOffset = i % 2 == 0 ? 0.3f : -0.3f;
            extraX = (double)(radius * Mth.m_14031_((float)angle)) + entity.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + entity.m_20189_();
            extraY = baseY + verticalOffset;
            serverLevel.m_8767_((ParticleOptions)new GlowingParticleData(color, Math.max(0.2f, (float)(this.m_8105_(stack) - count) * 0.015f), 40, 0.02f), extraX, extraY, extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < steps; ++i) {
            angle = 0.02f * (float)(-count * 2 + i * 90);
            verticalOffset = i % 2 == 0 ? -0.3f : 0.3f;
            extraX = (double)(radius * Mth.m_14031_((float)angle)) + entity.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + entity.m_20189_();
            extraY = baseY + verticalOffset;
            serverLevel.m_8767_((ParticleOptions)new GlowingParticleData(color, Math.max(0.2f, (float)(this.m_8105_(stack) + count) * 0.015f), 40, 0.02f), extraX, extraY, extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        if (stack.m_41720_() == ItemRegistry.FIRE_SEAL.get()) {
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(this.getElement()).getRGB())));
        }
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("items", "ether_mirror");
    }
}

