/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.leveling.utils;

import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.leveling.SkillStorage;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.data.CategoryInfo;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.SkillData;
import it.mralxart.etheria.leveling.data.SkillInfo;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.RandomUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SkillsUtils {
    public static void setLvl(Player player, Branches branch, int lvl) {
        CapabilityRegistry.getCap(player).setSmLevel(branch, lvl);
        SyncCapabilityManager.sync(player);
        SkillsUtils.checkLvl(player, branch);
    }

    public static void addLvl(Player player, Branches branch, int lvl) {
        int xpold = SkillsUtils.getLvl(player, branch);
        SkillsUtils.setLvl(player, branch, xpold + lvl);
    }

    public static int getLvl(Player player, Branches branch) {
        return CapabilityRegistry.getCap(player).getSmLevel(branch);
    }

    public static void setXp(Player player, Branches branch, int xp) {
        CapabilityRegistry.getCap(player).setSmXp(branch, xp);
        SyncCapabilityManager.sync(player);
        SkillsUtils.checkLvl(player, branch);
    }

    public static void addXp(Player player, Branches branch, int addXp) {
        int xpOld = SkillsUtils.getXp(player, branch);
        SkillsUtils.setXp(player, branch, xpOld + addXp);
    }

    public static int getXp(Player player, Branches branch) {
        return CapabilityRegistry.getCap(player).getSmXp(branch);
    }

    public static void checkLvl(Player player, Branches branch) {
        int lvl;
        int requiredXpForNextLevel;
        int xp = SkillsUtils.getXp(player, branch);
        if (xp >= (requiredXpForNextLevel = (lvl = SkillsUtils.getLvl(player, branch)) * 100 + 150)) {
            CapabilityRegistry.getCap(player).setSkillPoints(CapabilityRegistry.getCap(player).getSkillPoints() + 1);
            SkillsUtils.setXp(player, branch, xp - requiredXpForNextLevel);
            SkillsUtils.addLvl(player, branch, 1);
            SyncCapabilityManager.sync(player);
        }
    }

    public static boolean getSkillUnlock(Player player, String id) {
        return SkillsUtils.getSkillById(player, id).map(SkillData::isPurchased).orElse(false);
    }

    public static boolean getSkillItemUnlock(Player player, String id) {
        for (CategoryInfo categoryInfo : SkillStorage.CATEGORYS.values()) {
            for (SkillInfo skillInfo : categoryInfo.getSkills().values()) {
                if (SkillsUtils.isModCondition(skillInfo, id)) {
                    return SkillsUtils.getSkillUnlock(player, skillInfo.getId());
                }
                if (!SkillsUtils.isItemCondition(skillInfo, id)) continue;
                return SkillsUtils.getSkillUnlock(player, skillInfo.getId());
            }
        }
        return true;
    }

    public static boolean isItemCondition(SkillInfo skillInfo, String id) {
        return skillInfo.getConditions().stream().anyMatch(condition -> (condition.getType().equals((Object)ConditionType.ITEM) || condition.getType().equals((Object)ConditionType.BLOCK)) && condition.getId().equals(id));
    }

    public static boolean isModCondition(SkillInfo skillInfo, String id) {
        String modId = id.split(":")[0];
        return skillInfo.getConditions().stream().anyMatch(condition -> condition.getType().equals((Object)ConditionType.MOD) && condition.getId().split(":")[0].equals(modId));
    }

    public static List<SkillData> getSkills(Player player) {
        return CapabilityRegistry.getCap(player).getSkills();
    }

    public static List<SkillData> getUnlockedSkills(Player player) {
        return SkillsUtils.getSkills(player).stream().filter(SkillData::isPurchased).collect(Collectors.toList());
    }

    public static boolean isSkillUnlockd(Player player, String skillId) {
        Optional<EtheriaCapability> capability = Optional.of(CapabilityRegistry.getCap(player));
        ArrayList<SkillData> skillData = new ArrayList<SkillData>(SkillsUtils.getSkills(player));
        return capability.map(skills -> skillData.stream().filter(skill -> skill != null && skill.getId().equals(skillId)).findFirst().map(SkillData::isPurchased).orElse(false)).orElse(false);
    }

    public static boolean isSkillActive(Player player, String skillId) {
        Optional<EtheriaCapability> capability = Optional.of(CapabilityRegistry.getCap(player));
        ArrayList<SkillData> skillData = new ArrayList<SkillData>(SkillsUtils.getSkills(player));
        return capability.map(skills -> skillData.stream().filter(skill -> skill != null && skill.getId().equals(skillId) && skill.isPurchased()).findFirst().map(skillData1 -> skillData1.isPurchased() && skillData1.isActive()).orElse(false)).orElse(false);
    }

    public static boolean isParentSkillUnlockd(Player player, String skillId) {
        SkillInfo skillInfo = SkillsUtils.getInfoSkillById(skillId);
        if (skillInfo == null) {
            return false;
        }
        for (String parentId : skillInfo.getParents()) {
            if (SkillsUtils.isSkillUnlockd(player, parentId)) continue;
            return false;
        }
        return true;
    }

    public static List<SkillInfo> getInfoSkills() {
        ArrayList<SkillInfo> dataList = new ArrayList<SkillInfo>();
        HashMap<String, CategoryInfo> map = new HashMap<String, CategoryInfo>(SkillStorage.CATEGORYS);
        for (CategoryInfo categoryInfo : map.values()) {
            dataList.addAll(new HashMap<String, SkillInfo>(categoryInfo.getSkills()).values().stream().toList());
        }
        return dataList;
    }

    public static List<SkillInfo> getStatUnlockedSkills(String stat, Player player) {
        Set unlockedIds = SkillsUtils.getUnlockedSkills(player).stream().map(SkillData::getId).collect(Collectors.toSet());
        ArrayList<SkillInfo> result = new ArrayList<SkillInfo>();
        block0: for (SkillInfo info : SkillsUtils.getInfoSkills()) {
            if (!unlockedIds.contains(info.getId())) continue;
            for (ConditionInfo cond : info.getConditions()) {
                String condId;
                if (cond.getType() != ConditionType.STAT || !new ResourceLocation(condId = cond.getId()).m_135827_().equals(stat) && !condId.equals(stat)) continue;
                result.add(info);
                continue block0;
            }
        }
        return result;
    }

    public static int getStatAmount(String stat, Player player) {
        int amount = 0;
        for (SkillInfo info : SkillsUtils.getStatUnlockedSkills(stat, player)) {
            for (ConditionInfo condtionInfo : info.getConditions()) {
                amount += condtionInfo.getAmount();
            }
        }
        return amount;
    }

    public static Optional<SkillData> getSkillById(Player player, String skillId) {
        List<SkillData> skills = SkillsUtils.getSkills(player);
        for (SkillData data : new ArrayList<SkillData>(skills)) {
            if (data == null || !data.getId().equals(skillId)) continue;
            return Optional.of(data);
        }
        return Optional.empty();
    }

    @Nullable
    public static SkillInfo getInfoSkillById(String skillId) {
        List<SkillInfo> skills = SkillsUtils.getInfoSkills();
        if (skills.isEmpty()) {
            return null;
        }
        return skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().orElse(null);
    }

    public static boolean mayPlayerPurchase(Player player, String skillId) {
        SkillInfo info = SkillsUtils.getInfoSkillById(skillId);
        if (info == null) {
            return false;
        }
        int infoMastery = info.getReqLvl();
        Branches branch = info.getCategory();
        boolean points = CapabilityRegistry.getCap(player).getSkillPoints() >= info.getReqPoints();
        return CapabilityRegistry.getCap(player).getSkillPoints() >= info.getReqPoints();
    }

    public static void unlockSkillById(Player player, String skillId, boolean active) {
        List<SkillData> skills = SkillsUtils.getSkills(player);
        Optional<SkillData> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setPurchased(active);
            SyncCapabilityManager.sync(player);
        });
    }

    public static void activeSkillById(Player player, String skillId, boolean active) {
        List<SkillData> skills = SkillsUtils.getSkills(player);
        Optional<SkillData> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setActive(active);
            SyncCapabilityManager.sync(player);
        });
    }

    public static float getAnInt(Player player, String skillId) {
        SkillInfo info = SkillsUtils.getInfoSkillById(skillId);
        Optional<SkillData> data = SkillsUtils.getSkillById(player, skillId);
        if (info != null && data.isPresent()) {
            return info.getInitialValue() * (float)data.get().getLvl();
        }
        return 0.0f;
    }

    public static boolean mayPlayerUpgrade(Player player, String skillId) {
        if (SkillsUtils.getSkillById(player, skillId).isEmpty()) {
            return false;
        }
        SkillInfo info = SkillsUtils.getInfoSkillById(skillId);
        if (info == null) {
            return false;
        }
        return CapabilityRegistry.getCap(player).getSkillPoints() >= info.getReqUpPoints() && SkillsUtils.getSkillById(player, skillId).get().getLvl() < info.getMaxLvl();
    }

    public static void mineInRadius(Player player, BlockPos pos, Level level, int width, int height) {
        block10: {
            block9: {
                if (!(player instanceof ServerPlayer)) break block9;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) break block10;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int facingX = player.m_6350_().m_122429_();
        float pitch = player.m_146909_();
        boolean isVertical = Math.abs(pitch) > 45.0f;
        boolean hasSilkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_()) > 0;
        Consumer<BlockPos> breakBlock = targetPos -> {
            BlockState state = level.m_8055_(targetPos);
            if (!state.m_60795_() && state.m_60800_((BlockGetter)level, targetPos) >= 0.0f && state.m_60734_() != Blocks.f_50752_) {
                if (!player.m_7500_()) {
                    if (hasSilkTouch && state.canHarvestBlock((BlockGetter)level, targetPos, player)) {
                        ItemStack drop = new ItemStack((ItemLike)state.m_60734_().m_5456_());
                        Block.m_49840_((Level)level, (BlockPos)targetPos, (ItemStack)drop);
                    } else {
                        Block.m_49881_((BlockState)state, (Level)serverLevel, (BlockPos)targetPos, (BlockEntity)level.m_7702_(targetPos), (Entity)player, (ItemStack)player.m_21205_());
                    }
                }
                state.m_60734_().onDestroyedByPlayer(state, (Level)serverLevel, targetPos, player, true, level.m_6425_(targetPos));
                level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
            }
        };
        if (isVertical) {
            int facingY = pitch > 0.0f ? -1 : 1;
            for (int x = -width / 2; x <= width / 2; ++x) {
                for (int z = -width / 2; z <= width / 2; ++z) {
                    BlockPos targetPos2 = pos.m_7918_(x, facingY > 0 ? -1 : 1, z);
                    breakBlock.accept(targetPos2.m_121945_(facingY > 0 ? Direction.UP : Direction.DOWN));
                }
            }
        } else {
            for (int x = -width / 2; x <= width / 2; ++x) {
                for (int y = -height / 2; y <= height / 2; ++y) {
                    BlockPos targetPos3 = facingX == 0 ? pos.m_7918_(x, y, 0) : pos.m_7918_(0, y, x);
                    breakBlock.accept(targetPos3);
                }
            }
        }
    }

    public static ItemStack getRandomTreasureItem(Level level) {
        LootParams.Builder builder;
        LootTable lootTable = ServerLifecycleHooks.getCurrentServer().m_278653_().m_278676_(BuiltInLootTables.f_78692_);
        ObjectArrayList loot = lootTable.m_287195_((builder = new LootParams.Builder((ServerLevel)level)).m_287235_(LootContextParamSets.f_81411_));
        return loot.isEmpty() ? ItemStack.f_41583_ : (ItemStack)loot.get(RandomUtils.random().nextInt(loot.size()));
    }
}

