/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magemicon;

import it.mralxart.etheria.client.gui.widgets.StarType;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import it.mralxart.etheria.magemicon.data.MageMiconData;
import it.mralxart.etheria.magemicon.data.StarInfo;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MageMiconStorage {
    public static MageMiconData DATA = MageMiconData.builder().build();

    public static void build() {
        DATA = MageMiconData.builder().constellation(ConstellationInfo.builder().id("basics_path").image(ImageType.ITEM, "etheria:magemicon").star(StarInfo.builder().id("welcome_to_etheria").x(50).y(128).image(ImageType.ITEM, "etheria:magemicon").chapter(MageMiconUtils.getChapter("basics", "ether")).hint(true).condition(ConditionType.ITEM, "etheria:magemicon").build()).star(StarInfo.builder().id("ether").x(100).y(128).parents("welcome_to_etheria").image(ImageType.ITEM, "etheria:ether_shard").chapter(MageMiconUtils.getChapter("basics", "ether")).hint(true).condition(ConditionType.ITEM, "etheria:ether_shard").build()).star(StarInfo.builder().id("ether_vessels").x(150).y(128).parents("ether").image(ImageType.ITEM, "etheria:ether_orb").chapter(MageMiconUtils.getChapter("items", "ether_vessels")).hint(true).condition(ConditionType.ITEM, "etheria:ether_ingot").build()).star(StarInfo.builder().id("ether_source").x(200).y(128).parents("ether_vessels").image(ImageType.ITEM, "etheria:ether_source").chapter(MageMiconUtils.getChapter("ether_constructs", "ether_source")).hint(true).condition(ConditionType.ITEM, "etheria:ether_crystal").build()).star(StarInfo.builder().id("ritual_fundamentals").x(250).y(128).parents("ether_source").image(ImageType.ITEM, "etheria:ether_altar").chapter(MageMiconUtils.getChapter("basics", "ritual_fundamentals")).hint(true).condition(ConditionType.ITEM, "etheria:ether_pedestal").build()).star(StarInfo.builder().id("elemental_compass").x(150).y(168).parents("ether").image(ImageType.ITEM, "etheria:elemental_emblem").chapter(MageMiconUtils.getChapter("basics", "elemental_compass")).hint(true).condition(ConditionType.ETHER_SETTING, "fire_rain").build()).star(StarInfo.builder().id("spells_fundamentals").x(200).y(88).parents("ether_vessels").image(ImageType.ITEM, "etheria:magic_stick").chapter(MageMiconUtils.getChapter("basics", "spells_fundamentals")).hint(true).condition(ConditionType.ETHER_SETTING, "test_1").build()).build()).constellation(ConstellationInfo.builder().id("spells").image(ImageType.ITEM, "etheria:magic_stick").star(StarInfo.builder().id("spells_fundamentals").x(128).y(128).image(ImageType.ITEM, "etheria:magic_stick").chapter(MageMiconUtils.getChapter("basics", "spells_fundamentals")).condition(ConditionType.STAR_UNLOCKED, "spells_fundamentals").build()).star(StarInfo.builder().id("elements_fundamentals").x(128).y(78).parents("spells_fundamentals").image(ImageType.ITEM, "etheria:scroll").chapter(MageMiconUtils.getChapter("basics", "elements_fundamentals")).condition(ConditionType.ITEM, "etheria:magic_stick").build()).star(StarInfo.builder().id("element_reaction").x(128).y(28).parents("elements_fundamentals").image(ImageType.ITEM, "etheria:elemental_emblem").chapter(MageMiconUtils.getChapter("basics", "element_reaction")).condition(ConditionType.ITEM, "etheria:scroll").build()).stars(MageMiconStorage.createSpellStarInfos(SpellsUtils.getDataSpellsMap())).build()).constellation(ConstellationInfo.builder().id("rituals").image(ImageType.ITEM, "etheria:ether_altar").star(StarInfo.builder().id("ritual_fundamentals").x(128).y(150).image(ImageType.ITEM, "etheria:ether_altar").chapter(MageMiconUtils.getChapter("basics", "ritual_fundamentals")).condition(ConditionType.STAR_UNLOCKED, "ritual_fundamentals").build()).star(StarInfo.builder().id("essence").x(128).y(200).parents("ritual_fundamentals").image(ImageType.ITEM, "etheria:essence_ether").chapter(MageMiconUtils.getChapter("items", "essence")).condition(ConditionType.STAR_UNLOCKED, "ritual_fundamentals").build()).star(StarInfo.builder().id("basic_runes").x(178).y(160).parents("ritual_fundamentals").image(ImageType.ITEM, "etheria:rune_knowledge").chapter(MageMiconUtils.getChapter("basics", "basic_runes")).condition(ConditionType.ITEM, "etheria:runic_pedestal").build()).star(StarInfo.builder().id("ether_collector").x(78).y(160).parents("ritual_fundamentals").image(ImageType.ITEM, "etheria:ether_collector").chapter(MageMiconUtils.getChapter("ether_constructs", "ether_collector")).condition(ConditionType.ITEM, "etheria:ether_distributor").build()).stars(MageMiconStorage.createRitualStarInfos(RitualRegistry.getAllRituals())).build()).constellation(ConstellationInfo.builder().id("dungeons").image(ImageType.ITEM, "etheria:elemental_emblem").star(StarInfo.builder().id("elemental_compass").x(128).y(100).image(ImageType.ITEM, "etheria:elemental_emblem").chapter(MageMiconUtils.getChapter("basics", "elemental_compass")).condition(ConditionType.STAR_UNLOCKED, "elemental_compass").build()).star(StarInfo.builder().id("ice_source").x(83).y(130).parents("elemental_compass").image(ImageType.ITEM, "etheria:ice_source").chapter(MageMiconUtils.getChapter("ether_constructs", "ice_source")).condition(ConditionType.ETHER_SETTING, "frost_shackles").build()).star(StarInfo.builder().id("trials").x(33).y(130).parents("ice_source").image(ImageType.ITEM, "etheria:trial").chapter(MageMiconUtils.getChapter("ether_constructs", "trials")).condition(ConditionType.ETHER_SETTING, "frozen_orbit").build()).star(StarInfo.builder().id("seal_pedestal").x(83).y(180).parents("ice_source").image(ImageType.ITEM, "etheria:cryo_seal_pedestal").chapter(MageMiconUtils.getChapter("ether_constructs", "seal_pedestal")).condition(ConditionType.ETHER_SETTING, "test_2").build()).star(StarInfo.builder().id("ether_anvil").x(173).y(130).parents("elemental_compass").image(ImageType.ITEM, "etheria:ether_anvil").chapter(MageMiconUtils.getChapter("ether_constructs", "ether_anvil")).condition(ConditionType.ITEM, "minecraft:anvil").build()).star(StarInfo.builder().id("artifacts").x(223).y(130).parents("ether_anvil").image(ImageType.ITEM, "etheria:snow_rose_of_death").chapter(MageMiconUtils.getChapter("items", "artifacts")).hint(true).condition(ConditionType.TRIGGER, "artifacts").build()).star(StarInfo.builder().id("resource_items").x(108).y(148).parents("elemental_compass").image(ImageType.ITEM, "etheria:frost_heart").chapter(MageMiconUtils.getChapter("items", "resource_items")).condition(ConditionType.STAR_UNLOCKED, "elemental_compass").build()).star(StarInfo.builder().id("kor_lunar").x(148).y(148).parents("elemental_compass").image(ImageType.ITEM, "etheria:kor_lunar").chapter(MageMiconUtils.getChapter("basics", "kor_lunar")).condition(ConditionType.ETHER_SETTING, "blazing_ring").build()).star(StarInfo.builder().id("ether_mirror").x(128).y(198).parents("kor_lunar").image(ImageType.ITEM, "etheria:ether_mirror").chapter(MageMiconUtils.getChapter("items", "ether_mirror")).condition(ConditionType.ETHER_SETTING, "test_1").build()).star(StarInfo.builder().id("enigma_secret").x(188).y(188).parents("kor_lunar").image(ImageType.ITEM, "etheria:enigma_orb").chapter(MageMiconUtils.getChapter("basics", "enigma_secret")).condition(ConditionType.ETHER_SETTING, "icy_barrage").build()).build()).build();
    }

    public static List<StarInfo> createSpellStarInfos(Map<String, SpellData> allSpellData) {
        ArrayList<StarInfo> resultList = new ArrayList<StarInfo>();
        HashMap<String, Map> spellsByElement = new HashMap<String, Map>();
        for (SpellData spellData : allSpellData.values()) {
            spellsByElement.computeIfAbsent(spellData.getElement(), k -> new HashMap()).computeIfAbsent(spellData.getRare().toLowerCase(), k -> new ArrayList()).add(spellData);
        }
        for (Map.Entry entry : spellsByElement.entrySet()) {
            Map spellsInElement = (Map)entry.getValue();
            List commonSpells = spellsInElement.getOrDefault("common", Collections.emptyList());
            List epicSpells = spellsInElement.getOrDefault("epic", Collections.emptyList());
            List legendarySpells = spellsInElement.getOrDefault("legendary", Collections.emptyList());
            String[] commonIdsInElement = (String[])commonSpells.stream().map(SpellData::getId).toArray(String[]::new);
            for (SpellData spell : commonSpells) {
                resultList.add(StarInfo.builder().id(spell.getId()).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").x(0).y(0).parents(new String[0]).build());
            }
            for (SpellData spell : epicSpells) {
                resultList.add(StarInfo.builder().id(spell.getId()).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").x(0).y(0).parents(commonIdsInElement).condition(ConditionType.ETHER_SETTING, spell.getId()).build());
            }
            for (SpellData spell : legendarySpells) {
                resultList.add(StarInfo.builder().id(spell.getId()).image(ImageType.ITEM, "etheria:spell_scroll").x(0).y(0).type(StarType.SPELL).hint(true).parents(new String[0]).condition(ConditionType.TRIGGER, spell.getId()).build());
            }
        }
        return resultList;
    }

    public static List<StarInfo> createRitualStarInfos(Map<String, RitualData> allRitualData) {
        ArrayList<StarInfo> resultList = new ArrayList<StarInfo>();
        for (RitualData ritual : allRitualData.values()) {
            resultList.add(StarInfo.builder().id(ritual.getId()).image(ImageType.ITEM, "etheria:spell_scroll").x(0).y(0).type(StarType.RITUAL).build());
        }
        return resultList;
    }
}

