/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magemicon.data;

import it.mralxart.etheria.leveling.data.ImageInfo;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.magemicon.data.StarInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstellationInfo {
    private String id;
    private ImageInfo image;
    private Map<String, StarInfo> stars;

    ConstellationInfo(String id, ImageInfo image, Map<String, StarInfo> stars) {
        this.id = id;
        this.image = image;
        this.stars = stars;
    }

    public static ConstellationInfoBuilder builder() {
        return new ConstellationInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public Map<String, StarInfo> getStars() {
        return this.stars;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImage(ImageInfo image) {
        this.image = image;
    }

    public void setStars(Map<String, StarInfo> stars) {
        this.stars = stars;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstellationInfo)) {
            return false;
        }
        ConstellationInfo other = (ConstellationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ImageInfo this$image = this.getImage();
        ImageInfo other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Map<String, StarInfo> this$stars = this.getStars();
        Map<String, StarInfo> other$stars = other.getStars();
        return !(this$stars == null ? other$stars != null : !((Object)this$stars).equals(other$stars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstellationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ImageInfo $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Map<String, StarInfo> $stars = this.getStars();
        result = result * 59 + ($stars == null ? 43 : ((Object)$stars).hashCode());
        return result;
    }

    public String toString() {
        return "ConstellationInfo(id=" + this.getId() + ", image=" + this.getImage() + ", stars=" + this.getStars() + ")";
    }

    public static class ConstellationInfoBuilder {
        private String id;
        private Map<String, StarInfo> stars = new HashMap<String, StarInfo>();
        private ImageInfo image = new ImageInfo("minecraft:air", ImageType.ITEM);

        public ConstellationInfoBuilder image(ImageType type, String data) {
            this.image = new ImageInfo(data, type);
            return this;
        }

        public ConstellationInfoBuilder star(StarInfo data) {
            this.stars.put(data.getId(), data);
            return this;
        }

        public ConstellationInfoBuilder stars(List<StarInfo> starInfos) {
            HashMap<String, StarInfo> starInfoMap = new HashMap<String, StarInfo>();
            for (StarInfo data : starInfos) {
                starInfoMap.put(data.getId(), data);
            }
            this.stars.putAll(starInfoMap);
            return this;
        }

        public ConstellationInfoBuilder stars(Map<String, StarInfo> skills) {
            this.stars.putAll(skills);
            return this;
        }

        ConstellationInfoBuilder() {
        }

        public ConstellationInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ConstellationInfo build() {
            return new ConstellationInfo(this.id, this.image, this.stars);
        }

        public String toString() {
            return "ConstellationInfo.ConstellationInfoBuilder(id=" + this.id + ", image=" + this.image + ", stars=" + this.stars + ")";
        }
    }
}

