/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magemicon.data;

import com.google.common.collect.Lists;
import it.mralxart.etheria.client.gui.widgets.StarType;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.ImageInfo;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.magic.magemicon.Chapter;
import java.util.ArrayList;
import java.util.List;

public class StarInfo {
    private Boolean active;
    private String id;
    private List<String> parents;
    private int reqLvl;
    private List<ConditionInfo> conditions;
    private boolean hint;
    private int x;
    private int y;
    private ImageInfo info;
    private Chapter chapter;
    private StarType type;

    private static Boolean $default$active() {
        return true;
    }

    private static String $default$id() {
        return "";
    }

    private static int $default$reqLvl() {
        return 0;
    }

    private static boolean $default$hint() {
        return false;
    }

    private static int $default$x() {
        return 0;
    }

    private static int $default$y() {
        return 0;
    }

    private static StarType $default$type() {
        return StarType.BASIC;
    }

    StarInfo(Boolean active, String id, List<String> parents, int reqLvl, List<ConditionInfo> conditions, boolean hint, int x, int y, ImageInfo info, Chapter chapter, StarType type) {
        this.active = active;
        this.id = id;
        this.parents = parents;
        this.reqLvl = reqLvl;
        this.conditions = conditions;
        this.hint = hint;
        this.x = x;
        this.y = y;
        this.info = info;
        this.chapter = chapter;
        this.type = type;
    }

    public static StarInfoBuilder builder() {
        return new StarInfoBuilder();
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public int getReqLvl() {
        return this.reqLvl;
    }

    public List<ConditionInfo> getConditions() {
        return this.conditions;
    }

    public boolean isHint() {
        return this.hint;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ImageInfo getInfo() {
        return this.info;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public StarType getType() {
        return this.type;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public void setReqLvl(int reqLvl) {
        this.reqLvl = reqLvl;
    }

    public void setConditions(List<ConditionInfo> conditions) {
        this.conditions = conditions;
    }

    public void setHint(boolean hint) {
        this.hint = hint;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setInfo(ImageInfo info) {
        this.info = info;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public void setType(StarType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarInfo)) {
            return false;
        }
        StarInfo other = (StarInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReqLvl() != other.getReqLvl()) {
            return false;
        }
        if (this.isHint() != other.isHint()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$parents = this.getParents();
        List<String> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        List<ConditionInfo> this$conditions = this.getConditions();
        List<ConditionInfo> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        ImageInfo this$info = this.getInfo();
        ImageInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Chapter this$chapter = this.getChapter();
        Chapter other$chapter = other.getChapter();
        if (this$chapter == null ? other$chapter != null : !((Object)this$chapter).equals(other$chapter)) {
            return false;
        }
        StarType this$type = this.getType();
        StarType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StarInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReqLvl();
        result = result * 59 + (this.isHint() ? 79 : 97);
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        List<ConditionInfo> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        ImageInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Chapter $chapter = this.getChapter();
        result = result * 59 + ($chapter == null ? 43 : ((Object)$chapter).hashCode());
        StarType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "StarInfo(active=" + this.getActive() + ", id=" + this.getId() + ", parents=" + this.getParents() + ", reqLvl=" + this.getReqLvl() + ", conditions=" + this.getConditions() + ", hint=" + this.isHint() + ", x=" + this.getX() + ", y=" + this.getY() + ", info=" + this.getInfo() + ", chapter=" + this.getChapter() + ", type=" + this.getType() + ")";
    }

    public static class StarInfoBuilder {
        private boolean active$set;
        private Boolean active$value;
        private boolean id$set;
        private String id$value;
        private boolean reqLvl$set;
        private int reqLvl$value;
        private boolean hint$set;
        private boolean hint$value;
        private boolean x$set;
        private int x$value;
        private boolean y$set;
        private int y$value;
        private Chapter chapter;
        private boolean type$set;
        private StarType type$value;
        private List<String> parents = new ArrayList<String>();
        private List<ConditionInfo> conditions = new ArrayList<ConditionInfo>();
        private ImageInfo info = new ImageInfo("minecraft:air", ImageType.ITEM);

        public StarInfoBuilder parents(String ... parents) {
            this.parents.addAll(Lists.newArrayList((Object[])parents));
            return this;
        }

        public StarInfoBuilder condition(ConditionType condition, String data) {
            this.conditions.add(new ConditionInfo(data, 1, condition));
            return this;
        }

        public StarInfoBuilder condition(ConditionType condition, String data, int amount) {
            this.conditions.add(new ConditionInfo(data, amount, condition));
            return this;
        }

        public StarInfoBuilder image(ImageType type, String data) {
            this.info = new ImageInfo(data, type);
            return this;
        }

        StarInfoBuilder() {
        }

        public StarInfoBuilder active(Boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public StarInfoBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public StarInfoBuilder reqLvl(int reqLvl) {
            this.reqLvl$value = reqLvl;
            this.reqLvl$set = true;
            return this;
        }

        public StarInfoBuilder conditions(List<ConditionInfo> conditions) {
            this.conditions = conditions;
            return this;
        }

        public StarInfoBuilder hint(boolean hint) {
            this.hint$value = hint;
            this.hint$set = true;
            return this;
        }

        public StarInfoBuilder x(int x) {
            this.x$value = x;
            this.x$set = true;
            return this;
        }

        public StarInfoBuilder y(int y) {
            this.y$value = y;
            this.y$set = true;
            return this;
        }

        public StarInfoBuilder info(ImageInfo info) {
            this.info = info;
            return this;
        }

        public StarInfoBuilder chapter(Chapter chapter) {
            this.chapter = chapter;
            return this;
        }

        public StarInfoBuilder type(StarType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public StarInfo build() {
            Boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = StarInfo.$default$active();
            }
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = StarInfo.$default$id();
            }
            int reqLvl$value = this.reqLvl$value;
            if (!this.reqLvl$set) {
                reqLvl$value = StarInfo.$default$reqLvl();
            }
            boolean hint$value = this.hint$value;
            if (!this.hint$set) {
                hint$value = StarInfo.$default$hint();
            }
            int x$value = this.x$value;
            if (!this.x$set) {
                x$value = StarInfo.$default$x();
            }
            int y$value = this.y$value;
            if (!this.y$set) {
                y$value = StarInfo.$default$y();
            }
            StarType type$value = this.type$value;
            if (!this.type$set) {
                type$value = StarInfo.$default$type();
            }
            return new StarInfo(active$value, id$value, this.parents, reqLvl$value, this.conditions, hint$value, x$value, y$value, this.info, this.chapter, type$value);
        }

        public String toString() {
            return "StarInfo.StarInfoBuilder(active$value=" + this.active$value + ", id$value=" + this.id$value + ", parents=" + this.parents + ", reqLvl$value=" + this.reqLvl$value + ", conditions=" + this.conditions + ", hint$value=" + this.hint$value + ", x$value=" + this.x$value + ", y$value=" + this.y$value + ", info=" + this.info + ", chapter=" + this.chapter + ", type$value=" + this.type$value + ")";
        }
    }
}

