/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.elements;

import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ColorUtils;
import it.mralxart.etheria.utils.ItemUtils;
import java.awt.Color;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ElementsUtils {
    public static Element getElementFromItemId(ItemStack item) {
        return ElementsUtils.getElement(ElementsUtils.getElementIdNameFromItemId(ItemUtils.getItemIdFromStack(item)));
    }

    public static String getElementIdNameFromItemId(String itemId) {
        String[] parts = itemId.split(":");
        if (parts.length > 1) {
            String[] subParts = parts[1].split("_");
            if (subParts.length > 2) {
                return subParts[2].toUpperCase();
            }
            if (subParts.length > 1) {
                return subParts[1].toUpperCase();
            }
        }
        return "CRYO";
    }

    public static Element getElement(Player player) {
        return CapabilityRegistry.getCap(player).getElement();
    }

    public static Element getElement(ItemStack itemStack) {
        return ElementsUtils.getElement(itemStack.m_41720_());
    }

    public static Element getElement(Item item) {
        if (item instanceof IElementItem) {
            IElementItem iElementItem = (IElementItem)item;
            return iElementItem.getElement();
        }
        return Element.ETHER;
    }

    public static String getStringElement(Player player) {
        return ElementsUtils.getElement(player).name().toUpperCase();
    }

    public static Element getElement(String string) {
        return Element.valueOf(string.toUpperCase());
    }

    public static void setElement(Player player, String element) {
        CapabilityRegistry.getCap(player).setElement(Element.valueOf(element.toUpperCase()));
        SyncCapabilityManager.sync(player);
    }

    public static int getElementIndex(String element) {
        switch (element.toLowerCase()) {
            case "pyro": {
                return 0;
            }
            case "terra": {
                return 1;
            }
            case "aqua": {
                return 2;
            }
            case "aero": {
                return 3;
            }
            case "ether": {
                return 4;
            }
            case "cryo": {
                return 5;
            }
        }
        return 0;
    }

    public static Color getRandomColorByElement(Element element) {
        return switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case Element.NONE -> Color.WHITE;
            case Element.ELECTRO -> ColorUtils.getRandomColor(new Color(14596863), new Color(13534463));
            case Element.PYRO -> ColorUtils.getRandomColor(new Color(14630452), new Color(16739840), new Color(6160906), new Color(11738390));
            case Element.TERRA -> new Color(13364373);
            case Element.AQUA -> new Color(122, 192, 213);
            case Element.AERO -> ColorUtils.getRandomColor(new Color(119, 127, 131), new Color(143, 145, 147), new Color(204, 208, 211), new Color(207, 221, 232));
            case Element.ETHER -> ColorUtils.getRandomColor(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249));
            case Element.CRYO -> ColorUtils.getRandomColor(new Color(14023679), new Color(9426939), new Color(10873087), new Color(5480151));
        };
    }

    public static Color getColorByElement(Element element) {
        switch (element) {
            case PYRO: {
                return new Color(14630452);
            }
            case TERRA: {
                return new Color(13364373);
            }
            case AQUA: {
                return new Color(122, 190, 210);
            }
            case AERO: {
                return new Color(207, 221, 232);
            }
            case ETHER: {
                return new Color(13603561);
            }
            case CRYO: {
                return new Color(10871548);
            }
        }
        return new Color(141, 210, 122);
    }

    public static Element getElementByColor(Color element) {
        if (element.equals(new Color(210, 133, 122))) {
            return Element.PYRO;
        }
        if (element.equals(new Color(141, 210, 122))) {
            return Element.TERRA;
        }
        if (element.equals(new Color(122, 190, 210))) {
            return Element.AQUA;
        }
        if (element.equals(new Color(207, 221, 232))) {
            return Element.AERO;
        }
        if (element.equals(new Color(183, 122, 226))) {
            return Element.ETHER;
        }
        if (element.equals(new Color(122, 145, 210))) {
            return Element.CRYO;
        }
        return Element.TERRA;
    }

    public static Color getEndColorByElement(Element element) {
        switch (element) {
            case PYRO: {
                return new Color(8661516);
            }
            case TERRA: {
                return new Color(93, 152, 77);
            }
            case AQUA: {
                return new Color(72, 134, 152);
            }
            case AERO: {
                return new Color(154, 177, 196);
            }
            case ETHER: {
                return new Color(6764434);
            }
            case CRYO: {
                return new Color(4097995);
            }
        }
        return new Color(104, 168, 87);
    }
}

