/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.elements.handlers;

import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ElementHandler {
    public static void drawElementEffects(LivingEntity livingEntity, Element element) {
        if (element.equals((Object)Element.PYRO)) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        } else if (element.equals((Object)Element.CRYO)) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), (ParticleOptions)ParticleTypes.f_175821_, livingEntity.m_20191_(), 1, 5.0E-4f);
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        } else if (element.equals((Object)Element.AERO) && livingEntity.f_19797_ % 3 == 0) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        }
    }

    public static boolean addElement(LivingEntity entity, Element element, float damage, int duration, boolean trigger) {
        return entity.getCapability(CapabilityRegistry.ENTITY).map(data -> {
            if (data.hasElementDuration(element, duration)) {
                return false;
            }
            data.addElement(element, duration);
            if (trigger) {
                ElementHandler.triggerReactions(entity, damage);
            }
            SyncCapabilityManager.syncEntity(entity, data.serializeNBT());
            return true;
        }).orElse(false);
    }

    public static boolean addElement(LivingEntity entity, Element element, float damage, int duration) {
        return ElementHandler.addElement(entity, element, damage, duration, false);
    }

    public static void triggerReactions(LivingEntity entity, float damage) {
        entity.getCapability(CapabilityRegistry.ENTITY).ifPresent(data -> {
            ArrayList<Element> elements = new ArrayList<Element>(data.getElements().keySet());
            if (elements.size() <= 1) {
                return;
            }
            for (int i = 0; i < elements.size(); ++i) {
                for (int j = i + 1; j < elements.size(); ++j) {
                    Element element1 = (Element)((Object)((Object)elements.get(i)));
                    Element element2 = (Element)((Object)((Object)elements.get(j)));
                    ElementHandler.triggerReaction(entity, element1, element2, damage);
                }
            }
            data.getElements().clear();
            SyncCapabilityManager.syncEntity(entity, data.serializeNBT());
        });
    }

    public static void triggerReaction(LivingEntity entity, Element element1, Element element2, float damage) {
        if (element1.equals((Object)element2)) {
            return;
        }
        if (element1 == Element.AERO || element2 == Element.AERO) {
            Element aeroElement;
            Element element = aeroElement = element1 != Element.AERO ? element1 : element2;
            if (aeroElement == Element.PYRO || aeroElement == Element.CRYO || aeroElement == Element.AQUA || aeroElement == Element.ELECTRO) {
                float swirlDamage = damage * 0.6f;
                entity.m_6469_(entity.m_9236_().m_269111_().m_269425_(), swirlDamage);
                ParticleUtils.createParticle(entity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(aeroElement).getRGB(), 0.5f, 160, 0.025f, 1.0f, 0.93f, true, false, false), entity.m_20182_().m_82520_(0.0, 1.0, 0.0), 80, 0.5, 0.5, 0.5, 0.5);
                float spreadRadius = 4.0f;
                entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)spreadRadius), nearbyEntity -> !nearbyEntity.m_20148_().equals(entity.m_20148_())).forEach(targetToSpread -> ElementHandler.addElement(targetToSpread, aeroElement, 1.0f, 200, false));
                return;
            }
        }
        if (element1 == Element.PYRO && element2 == Element.CRYO || element1 == Element.CRYO && element2 == Element.PYRO) {
            float damageMultiplier;
            if (element1 == Element.PYRO) {
                damageMultiplier = 2.0f;
                ParticleUtils.createAABB(entity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element1), 0.2f, 60, 0.25f), entity.m_20191_(), 40, 0.05f);
                ParticleUtils.createAABB(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123756_, entity.m_20191_(), 20, 0.05f);
            } else {
                damageMultiplier = 1.5f;
                ParticleUtils.createAABB(entity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element1), 0.2f, 60, 0.25f), entity.m_20191_(), 40, 0.05f);
                ParticleUtils.createAABB(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_175821_, entity.m_20191_(), 40, 0.05f);
            }
            entity.m_7311_(0);
            entity.m_6469_(entity.m_9236_().m_269111_().m_269425_(), damage * damageMultiplier);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="etheria")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Object object;
            if (event.phase == TickEvent.Phase.END && (object = event.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                for (Entity entity : level.m_142646_().m_142273_()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    entity.getCapability(CapabilityRegistry.ENTITY).ifPresent(data -> {
                        data.tick();
                        if (level.m_46467_() % 20L == 0L) {
                            data.tickElements();
                            SyncCapabilityManager.syncEntity(livingEntity, data.serializeNBT());
                        }
                        if (data.getTimerTick() <= 0 && data.isFrozen()) {
                            data.setFrozen(false);
                            SyncCapabilityManager.syncEntity(livingEntity, data.serializeNBT());
                        }
                        if (entity.m_20094_() > 0) {
                            ElementHandler.addElement(livingEntity, Element.PYRO, 1.0f, entity.m_20094_());
                        }
                        if (entity.m_146888_() > 0) {
                            ElementHandler.addElement(livingEntity, Element.CRYO, 1.0f, entity.m_146888_());
                        }
                        if (livingEntity.m_21023_(MobEffects.f_19591_) && livingEntity.m_21124_(MobEffects.f_19591_) != null) {
                            ElementHandler.addElement(livingEntity, Element.AERO, 0.1f, livingEntity.m_21124_(MobEffects.f_19591_).m_19557_());
                        }
                        if (livingEntity.m_21023_(MobEffects.f_19620_) && livingEntity.m_21124_(MobEffects.f_19620_) != null) {
                            ElementHandler.addElement(livingEntity, Element.AERO, 0.25f, livingEntity.m_21124_(MobEffects.f_19620_).m_19557_());
                        }
                    });
                }
            }
        }
    }
}

