/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.enigma;

import it.mralxart.etheria.blocks.base.IEnigmaBlock;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.EffectRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.tiles.data.IEnigmaTile;
import it.mralxart.etheria.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EnigmaHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Object object;
        if (event.phase == TickEvent.Phase.END && (object = event.level) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)object;
            for (LivingEntity livingEntity : level.m_45976_(LivingEntity.class, level.m_6857_().m_61946_().m_83215_())) {
                livingEntity.getCapability(CapabilityRegistry.ENTITY).ifPresent(data -> {
                    if (livingEntity.f_19797_ % 20 != 0) {
                        return;
                    }
                    if (data.getEnigma() < 40) {
                        boolean nearCrystal = !level.m_142425_((EntityTypeTest)EntityRegistry.SHADOW_NIHILIS.get(), livingEntity.m_20191_().m_82400_(7.0), e -> true).isEmpty();
                        boolean nearBlock = false;
                        if (!nearCrystal) {
                            BlockPos entityPos = livingEntity.m_20183_();
                            for (BlockPos pos : BlockPos.m_121940_((BlockPos)entityPos.m_7918_(-3, -3, -3), (BlockPos)entityPos.m_7918_(3, 3, 3))) {
                                IEnigmaTile enigmaTile;
                                BlockEntity tile;
                                BlockState state = level.m_8055_(pos);
                                if (!(state.m_60734_() instanceof IEnigmaBlock) || !((tile = level.m_7702_(pos)) instanceof IEnigmaTile) || !(enigmaTile = (IEnigmaTile)tile).isEnigma()) continue;
                                nearBlock = true;
                                break;
                            }
                        }
                        if (nearCrystal) {
                            data.setEnigma(data.getEnigma() + 2);
                        } else if (nearBlock) {
                            data.setEnigma(data.getEnigma() + 1);
                        } else {
                            data.setEnigma(Math.max(0, data.getEnigma() - 4));
                        }
                    } else {
                        data.setEnigma(Math.max(0, data.getEnigma() - 4));
                    }
                    if (data.getEnigma() > 0) {
                        EnigmaHandler.applyAttributes(livingEntity, data.getEnigma());
                    }
                    SyncCapabilityManager.syncEntity(livingEntity, data.serializeNBT());
                });
            }
        }
    }

    private static void applyAttributes(LivingEntity entity, int enigmaLevel) {
        if (enigmaLevel > 0) {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ENIGMA.get(), 100, 0, true, false, true));
        } else {
            entity.m_21195_((MobEffect)EffectRegistry.ENIGMA.get());
        }
        EntityUtils.resetAttribute(entity, Attributes.f_22281_, "etheria$enigma_attack", enigmaLevel >= 15 ? -2.0 : 0.0, AttributeModifier.Operation.ADDITION);
        EntityUtils.resetAttribute(entity, Attributes.f_22279_, "etheria$enigma_speed", enigmaLevel >= 30 ? -0.25 : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute(entity, Attributes.f_22276_, "etheria$enigma_health", enigmaLevel >= 40 ? -4.0 : 0.0, AttributeModifier.Operation.ADDITION);
    }
}

