/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.enigma;

import it.mralxart.etheria.blocks.base.IEnigmaBlock;
import it.mralxart.etheria.items.base.IEnigmaItem;
import it.mralxart.etheria.tiles.data.IEnigmaTile;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnigmaUtils {
    public static Color startColor = new Color(12344296);
    public static Color endColor = new Color(6628994);

    public static Color getEnigmaStartColor(int tickCount) {
        int animationDuration = 40;
        float progress = (float)(0.5 * (1.0 + Math.sin((double)((float)(tickCount % animationDuration) / (float)animationDuration) * Math.PI * 2.0)));
        float red = Mth.m_14179_((float)progress, (float)((float)startColor.getRed() / 255.0f), (float)((float)endColor.getRed() / 255.0f));
        float green = Mth.m_14179_((float)progress, (float)((float)startColor.getGreen() / 255.0f), (float)((float)endColor.getGreen() / 255.0f));
        float blue = Mth.m_14179_((float)progress, (float)((float)startColor.getBlue() / 255.0f), (float)((float)endColor.getBlue() / 255.0f));
        return new Color(red, green, blue);
    }

    public static Color getEnigmaEndColor(int tickCount) {
        int animationDuration = 40;
        float progress = (float)(0.5 * (1.0 + Math.sin((double)((float)(tickCount % animationDuration) / (float)animationDuration) * Math.PI * 2.0 + Math.PI)));
        float red = Mth.m_14179_((float)progress, (float)((float)startColor.getRed() / 255.0f), (float)((float)endColor.getRed() / 255.0f));
        float green = Mth.m_14179_((float)progress, (float)((float)startColor.getGreen() / 255.0f), (float)((float)endColor.getGreen() / 255.0f));
        float blue = Mth.m_14179_((float)progress, (float)((float)startColor.getBlue() / 255.0f), (float)((float)endColor.getBlue() / 255.0f));
        return new Color(red, green, blue);
    }

    public static boolean isEnigma(Object o) {
        ItemStack stack;
        if (o instanceof ItemStack && (stack = (ItemStack)o).m_41720_() instanceof IEnigmaItem) {
            return true;
        }
        if (o instanceof BlockState) {
            BlockState block = (BlockState)o;
            Block block2 = block.m_60734_();
            if (block2 instanceof IEnigmaBlock) {
                IEnigmaBlock iEnigmaBlock = (IEnigmaBlock)block2;
                return iEnigmaBlock.hasEnigma(block);
            }
        } else {
            BlockEntity entity;
            if (o instanceof BlockEntity && (entity = (BlockEntity)o) instanceof IEnigmaTile) {
                IEnigmaTile tile = (IEnigmaTile)entity;
                return tile.isEnigma();
            }
            if (o instanceof ItemStack) {
                CompoundTag blockTag;
                ItemStack itemStack = (ItemStack)o;
                CompoundTag tag = itemStack.m_41783_();
                if (tag != null && tag.m_128441_("BlockEntityTag") && (blockTag = tag.m_128469_("BlockEntityTag")).m_128441_("isEnigma")) {
                    return blockTag.m_128471_("isEnigma");
                }
                if (tag != null && tag.m_128441_("isEnigma")) {
                    return tag.m_128471_("isEnigma");
                }
            }
        }
        return false;
    }

    public static void setEnigma(Object o, boolean is) {
        BlockEntity entity;
        if (o instanceof BlockState) {
            BlockState block = (BlockState)o;
            if (block.m_60734_() instanceof IEnigmaBlock) {
                block.m_61124_((Property)IEnigmaBlock.ENIGMA, (Comparable)Boolean.valueOf(is));
            }
        } else if (o instanceof BlockEntity && (entity = (BlockEntity)o) instanceof IEnigmaTile) {
            IEnigmaTile tile = (IEnigmaTile)entity;
            tile.setEnigma(is);
        } else if (o instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)o;
            CompoundTag tag = itemStack.m_41784_();
            if (itemStack.m_41720_() instanceof BlockItem) {
                CompoundTag blockTag = tag.m_128469_("BlockEntityTag");
                blockTag.m_128379_("isEnigma", is);
                tag.m_128365_("BlockEntityTag", (Tag)blockTag);
            } else {
                tag.m_128379_("isEnigma", is);
            }
        }
    }
}

