/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.korlunar.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class KorLunarLevel {
    private final int level;
    private final String ritual;
    private final List<ItemStack> ingredients;

    public static KorLunarLevelBuilder builder() {
        return new KorLunarLevelBuilder();
    }

    KorLunarLevel(int level, String ritual, List<ItemStack> ingredients) {
        this.level = level;
        this.ritual = ritual;
        this.ingredients = ingredients;
    }

    public int getLevel() {
        return this.level;
    }

    public String getRitual() {
        return this.ritual;
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KorLunarLevel)) {
            return false;
        }
        KorLunarLevel other = (KorLunarLevel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        String this$ritual = this.getRitual();
        String other$ritual = other.getRitual();
        if (this$ritual == null ? other$ritual != null : !this$ritual.equals(other$ritual)) {
            return false;
        }
        List<ItemStack> this$ingredients = this.getIngredients();
        List<ItemStack> other$ingredients = other.getIngredients();
        return !(this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KorLunarLevel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        String $ritual = this.getRitual();
        result = result * 59 + ($ritual == null ? 43 : $ritual.hashCode());
        List<ItemStack> $ingredients = this.getIngredients();
        result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
        return result;
    }

    public String toString() {
        return "KorLunarLevel(level=" + this.getLevel() + ", ritual=" + this.getRitual() + ", ingredients=" + this.getIngredients() + ")";
    }

    public static class KorLunarLevelBuilder {
        private int level;
        private String ritual;
        private List<ItemStack> ingredients = new ArrayList<ItemStack>();

        public KorLunarLevelBuilder ingredient(Item item, int count) {
            this.ingredients.add(new ItemStack((ItemLike)item, count));
            return this;
        }

        KorLunarLevelBuilder() {
        }

        public KorLunarLevelBuilder level(int level) {
            this.level = level;
            return this;
        }

        public KorLunarLevelBuilder ritual(String ritual) {
            this.ritual = ritual;
            return this;
        }

        public KorLunarLevelBuilder ingredients(List<ItemStack> ingredients) {
            this.ingredients = ingredients;
            return this;
        }

        public KorLunarLevel build() {
            return new KorLunarLevel(this.level, this.ritual, this.ingredients);
        }

        public String toString() {
            return "KorLunarLevel.KorLunarLevelBuilder(level=" + this.level + ", ritual=" + this.ritual + ", ingredients=" + this.ingredients + ")";
        }
    }
}

