/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon;

import it.mralxart.etheria.magic.magemicon.Page;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class Chapter
implements INBTSerializable<CompoundTag> {
    @AutoSerialize
    public String index;
    public List<Page> pages;
    public String text;

    public Chapter(String index) {
        this.index = index;
    }

    public int getSize() {
        return this.pages.size();
    }

    public void setPage(int i, Page page) {
        this.pages.set(i, page);
    }

    public void addPage(int i, Page page) {
        this.pages.add(i, page);
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public void removePage(Page page) {
        this.pages.remove(page);
    }

    public void removePage(int i) {
        this.pages.remove(i);
    }

    public CompoundTag serializeNBT() {
        return NbtUtils.serialize(this);
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        NbtUtils.deserialize(this, compoundTag);
    }

    public String getIndex() {
        return this.index;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public String getText() {
        return this.text;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chapter)) {
            return false;
        }
        Chapter other = (Chapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        List<Page> this$pages = this.getPages();
        List<Page> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        List<Page> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "Chapter(index=" + this.getIndex() + ", pages=" + this.getPages() + ", text=" + this.getText() + ")";
    }

    public Chapter(String index, List<Page> pages, String text) {
        this.index = index;
        this.pages = pages;
        this.text = text;
    }

    public Chapter() {
    }
}

