/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.blocks.EtherAltar;
import it.mralxart.etheria.blocks.EtherDistributor;
import it.mralxart.etheria.blocks.EtherPedestal;
import it.mralxart.etheria.blocks.RunicPedestal;
import it.mralxart.etheria.client.gui.magemicon.widgets.ElementSlotWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.KorLunarSlotWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.KorLunarUpWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.SlotOutWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.SlotWidget;
import it.mralxart.etheria.client.particles.KorLunarParticle;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.handlers.TranslationHandler;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.items.EssenceItem;
import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.magic.korlunar.KorLunarLevels;
import it.mralxart.etheria.magic.korlunar.data.KorLunarLevel;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.spells.data.SpellModifier;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ItemUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Page {
    private String index;
    private String text;
    private Type type = Type.TITLE;
    public int sortIndex;
    @Nullable
    private EntityType entity;
    @Nullable
    private Item item;
    @Nullable
    private Item upItem;
    private List<ItemStack> items = new ArrayList<ItemStack>();
    public int pageOffSet = 0;
    @Nullable
    private Entity createdEntity = null;
    private String tag;
    private int color1 = 14003075;
    private int color2 = 9858892;

    public Page(String index) {
        this.index = index;
    }

    public Page() {
        this.index = "";
        this.type = Type.TITLE;
    }

    public Page(String index, Type type) {
        this.index = index;
        this.type = type;
    }

    public Page(String index, Type type, String text) {
        this.index = index;
        this.type = type;
        this.text = text;
    }

    public Page(String index, Type type, String text, @Nullable EntityType entity, @Nullable Item item) {
        this.index = index;
        this.type = type;
        this.entity = entity;
        this.text = text;
        this.item = item;
        if (Minecraft.m_91087_().f_91073_ != null && entity != null) {
            this.createdEntity = entity.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    public void init(MageMicon micon, int x, int y, int pageIndex) {
        SlotWidget secondSlot;
        int centerX = micon.f_96543_ / 2;
        int centerY = micon.f_96544_ / 2;
        if (this.type.equals((Object)Type.ANVIL)) {
            if (micon.chapter.index.equals("anvil_artifacts")) {
                firstSlot = new SlotWidget(centerX - 125 + 152, centerY - 8 + 40, micon, 1, stack -> stack.m_41720_() instanceof ArtifactItem);
                micon.m_142416_(firstSlot);
                secondSlot = new SlotWidget(centerX - 85 + 152, centerY - 8 + 40, micon, 2, stack -> true);
                micon.m_142416_(secondSlot);
            } else if (micon.chapter.index.equals("anvil_spells")) {
                firstSlot = new SlotWidget(centerX - 125 + 152, centerY - 8 + 40, micon, 1, stack -> false);
                micon.m_142416_(firstSlot);
                secondSlot = new SlotWidget(centerX - 85 + 152, centerY - 8 + 40, micon, 2, stack -> stack.m_41720_() instanceof ArtifactItem);
                micon.m_142416_(secondSlot);
            } else if (micon.chapter.index.equals("anvil_weapon")) {
                firstSlot = new SlotWidget(centerX - 125 + 152, centerY - 8 + 40, micon, 1, stack -> stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem || stack.m_41720_() instanceof TridentItem);
                micon.m_142416_(firstSlot);
                secondSlot = new SlotWidget(centerX - 85 + 152, centerY - 8 + 40, micon, 2, stack -> stack.m_41720_() instanceof ArtifactItem);
                micon.m_142416_(secondSlot);
            }
            SlotOutWidget slotOut = new SlotOutWidget(centerX - 40 + 152, centerY - 8 + 40, micon);
            micon.m_142416_(slotOut);
        }
        if (this.type.equals((Object)Type.KORLUNAR)) {
            if (micon.chapter.index.equals("kor_lunar_artifacts")) {
                micon.m_142416_(new SlotWidget(x + 22, y + 42, micon, 30, stack -> stack.m_41720_() instanceof ArtifactItem));
                micon.m_142416_(new SlotWidget(x + 118, y + 42, micon, 31, stack -> stack.m_41720_() instanceof ArtifactItem));
                micon.m_142416_(new SlotWidget(x + 22, y + 106, micon, 32, stack -> stack.m_41720_() instanceof ArtifactItem));
                micon.m_142416_(new SlotWidget(x + 118, y + 106, micon, 33, stack -> stack.m_41720_() instanceof ArtifactItem));
            }
            if (micon.chapter.index.equals("kor_lunar_elements")) {
                micon.m_142416_(new ElementSlotWidget(x + 54, y + 44, micon, null));
                micon.m_142416_(new ElementSlotWidget(x + 86, y + 44, micon, null));
                micon.m_142416_(new ElementSlotWidget(x + 22, y + 76, micon, Element.CRYO));
                micon.m_142416_(new ElementSlotWidget(x + 118, y + 76, micon, Element.PYRO));
                micon.m_142416_(new ElementSlotWidget(x + 22, y + 108, micon, null));
                micon.m_142416_(new ElementSlotWidget(x + 118, y + 108, micon, null));
                micon.m_142416_(new ElementSlotWidget(x + 54, y + 140, micon, null));
                micon.m_142416_(new ElementSlotWidget(x + 86, y + 140, micon, null));
            }
            if (micon.chapter.index.equals("kor_lunar_upgrade")) {
                int level = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getKorLunar();
                KorLunarLevel lunarLevel = KorLunarLevels.getLevel(level);
                micon.m_142416_(new KorLunarUpWidget(x + 57, y + 39, micon));
                if (lunarLevel == null) {
                    return;
                }
                if (lunarLevel.getRitual().isEmpty()) {
                    int totalItems = lunarLevel.getIngredients().size();
                    int rows = totalItems > 4 ? 2 : 1;
                    int columns = Math.min(totalItems, 4);
                    int num = 0;
                    int baseX = x + 36 + (4 - columns) * 12;
                    int baseY = y + 130 + (2 - rows) * 15;
                    for (ItemStack item : lunarLevel.getIngredients()) {
                        int row = num / 4;
                        int col = num % 4;
                        int offset = 0;
                        if (totalItems == 5 && row == 1) {
                            offset = 34;
                        } else if (totalItems == 6 && row == 1) {
                            offset = 23;
                        } else if (totalItems == 7 && row == 1) {
                            offset = 11;
                        } else if (totalItems == 8 && row == 1) {
                            offset = 0;
                        }
                        int offX = baseX + col * 23 + offset;
                        int offY = baseY + row * 30;
                        micon.m_142416_(new KorLunarSlotWidget(offX, offY, micon, 0, stack -> stack.m_150930_(item.m_41720_())));
                        ++num;
                    }
                }
            }
            if (micon.chapter.index.equals("reroll_artifacts")) {
                SlotWidget firstSlot = new SlotWidget(centerX - 125 + 152, centerY + 7, micon, 1, stack -> stack.m_41720_() instanceof ArtifactItem);
                micon.m_142416_(firstSlot);
                secondSlot = new SlotWidget(centerX - 85 + 152, centerY + 7, micon, 2, stack -> stack.m_41720_() instanceof EssenceItem);
                micon.m_142416_(secondSlot);
                SlotOutWidget slotOut = new SlotOutWidget(centerX - 40 + 152, centerY + 7, micon);
                micon.m_142416_(slotOut);
            }
            if (micon.chapter.index.equals("spell_upgrade")) {
                SlotWidget firstSlot = new SlotWidget(centerX - 125 + 152, centerY - 8 + 40, micon, 1, stack -> stack.m_41720_() instanceof ArtifactItem);
                micon.m_142416_(firstSlot);
                secondSlot = new SlotWidget(centerX - 85 + 152, centerY - 8 + 40, micon, 2, stack -> stack.m_41720_() instanceof EssenceItem);
                micon.m_142416_(secondSlot);
                SlotOutWidget slotOut = new SlotOutWidget(centerX - 40 + 152, centerY - 8 + 40, micon);
                micon.m_142416_(slotOut);
            }
        }
    }

    public void render(MageMicon micon, GuiGraphics guiGraphics, int x, int y, float pMouseX, float pMouseY, int pageIndex) {
        PoseStack poseStack = guiGraphics.m_280168_();
        if (this.type.equals((Object)Type.TITLE)) {
            this.renderTitle(guiGraphics, micon, x, y);
        }
        if (this.type.equals((Object)Type.ITEMS)) {
            this.renderTitle(guiGraphics, micon, x, y);
            if (this.text != null && !this.text.isEmpty()) {
                List lines = TranslationHandler.build().contains(this.text) ? Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)TranslationHandler.translate(this.text)), 136) : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)this.text, (String)this.text), 136);
                int yOff = 0;
                for (FormattedCharSequence line2 : lines) {
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line2, x + 15, y + 40 + yOff, this.color1, false);
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line2, x + 14, y + 39 + yOff, this.color2, false);
                    yOff += 9;
                }
            }
            if (!this.items.isEmpty()) {
                int totalItems = this.items.size();
                int rows = totalItems > 4 ? 2 : 1;
                int columns = Math.min(totalItems, 4);
                int num = 0;
                int baseX = x + 36 + (4 - columns) * 12;
                int baseY = y + 116 + (2 - rows) * 15;
                int offX = 0;
                int offY = 0;
                for (ItemStack item : this.items) {
                    int row = num / 4;
                    int col = num % 4;
                    int offset = 0;
                    if (totalItems == 5 && row == 1) {
                        offset = 34;
                    } else if (totalItems == 6 && row == 1) {
                        offset = 23;
                    } else if (totalItems == 7 && row == 1) {
                        offset = 11;
                    } else if (totalItems == 8 && row == 1) {
                        offset = 0;
                    }
                    offX = baseX + col * 23 + offset;
                    offY = baseY + row * 30;
                    GuiUtils.renderItemWithTooltip(guiGraphics, ((EtherPedestal)BlockRegistry.ETHER_PEDESTAL.get()).m_5456_().m_7968_(), offX, offY + 12, 1.0f, pMouseX, pMouseY, true, false);
                    GuiUtils.renderItemWithTooltip(guiGraphics, item, offX, offY, 1.0f, pMouseX, pMouseY, false, false);
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), offX, offY + 13, 0.0f, 0.0f, 16, 16, 16, 16);
                    Item item2 = item.m_41720_();
                    if (item2 instanceof IElementItem) {
                        IElementItem elementItem = (IElementItem)item2;
                        if (micon.tickCount % 10 == 0) {
                            micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)offX + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, offY - 3, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, ElementsUtils.getColorByElement(elementItem.getElement())));
                        }
                    }
                    ++num;
                }
            }
        }
        if (this.type.equals((Object)Type.CRAFTING)) {
            Object dynamicItem;
            this.renderTitle(guiGraphics, micon, x, y);
            if (this.item != null) {
                Optional<CraftingRecipe> recipe = Page.getRecipeForItem(this.item.m_7968_());
                int finalY = y;
                recipe.ifPresent(craftingRecipe -> {
                    int recipeOffsetY = this.upItem != null ? -26 : 0;
                    Page.renderRecipe(guiGraphics, craftingRecipe, x + 30, finalY + 64 + recipeOffsetY, pMouseX, pMouseY);
                    if (this.upItem != null) {
                        Optional<CraftingRecipe> upRecipe = Page.getRecipeForItem(this.upItem.m_7968_());
                        upRecipe.ifPresent(upCraftingRecipe -> Page.renderRecipe(guiGraphics, upCraftingRecipe, x + 30, finalY + 102, pMouseX, pMouseY));
                    }
                });
            } else if (this.tag != null && !this.tag.isEmpty()) {
                Object dynamicItem2;
                @NotNull ITag itemsFromTag = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ItemTags.create((ResourceLocation)new ResourceLocation(this.tag)));
                if (!itemsFromTag.isEmpty() && (dynamicItem2 = Page.byTime(itemsFromTag.stream().toArray())) instanceof Item) {
                    Item dynamicStack = (Item)dynamicItem2;
                    Optional<CraftingRecipe> dynamicRecipe = Page.getRecipeForItem(dynamicStack.m_7968_());
                    int finalY1 = y;
                    dynamicRecipe.ifPresent(craftingRecipe -> Page.renderRecipe(guiGraphics, craftingRecipe, x + 30, finalY1 + 64, pMouseX, pMouseY));
                }
            } else if (!this.items.isEmpty() && (dynamicItem = Page.byTime(this.items.toArray())) instanceof ItemStack) {
                ItemStack dynamicStack = (ItemStack)dynamicItem;
                Optional<CraftingRecipe> dynamicRecipe = Page.getRecipeForItem(dynamicStack);
                int finalY2 = y;
                dynamicRecipe.ifPresent(craftingRecipe -> Page.renderRecipe(guiGraphics, craftingRecipe, x + 30, finalY2 + 64, pMouseX, pMouseY));
            }
        }
        if (this.type.equals((Object)Type.SPELL)) {
            String spell = micon.page1 != null ? micon.page1.index : "";
            Component text = GuiUtils.translate("mage_micon.spell." + spell);
            this.renderTitle(guiGraphics, micon, text.getString(), x, y);
            GuiUtils.drawString(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"\u00bb ").m_7220_(text).m_130946_(" \u00ab"), x + 16 + 67, y + 23, 14003075, false);
            GuiUtils.drawString(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"\u00bb ").m_7220_(text).m_130946_(" \u00ab"), x + 15 + 67, y + 22, 9858892, false);
            poseStack.m_85836_();
            poseStack.m_85841_(1.3f, 1.3f, 1.3f);
            poseStack.m_252880_(((float)(x + 72) + 10.0f) / 1.3f, ((float)(y + 40) + 14.5f) / 1.3f, 0.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/spell_paper.png"), -15, -12, 0.0f, 0.0f, 31, 40, 31, 40);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/magic/spells/" + spell + ".png"), -9, -5, 0.0f, 0.0f, 18, 27, 18, 27);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/line_" + SpellsUtils.getElement(spell).name().toLowerCase() + ".png"), -15, -12, 0.0f, 0.0f, 31, 40, 31, 40);
            poseStack.m_85849_();
            int yOff = -26;
            GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"etheria.curve").getString() + ":", x + 16, y + 120 + yOff, this.color1, this.color2);
            List<SpellModifier> modifiers = SpellsUtils.getModifiers(spell);
            for (SpellModifier modifier : modifiers) {
                String id = modifier.getId();
                String name = Component.m_237115_((String)("mage_micon.modifier." + id)).getString();
                float baseValue = SpellsUtils.getUpgradeValue((Player)Minecraft.m_91087_().f_91074_, spell, id);
                String formattedBaseValue = String.format(Locale.getDefault(), "%.1f", Float.valueOf(baseValue)).replace('.', ',');
                String artifactString = "";
                try {
                    if (Arrays.stream(StatType.values()).anyMatch(stat -> stat.name().equalsIgnoreCase(id))) {
                        StatType statType = StatType.valueOf(id.toUpperCase());
                        float artifactValue = ArtifactStatCalculator.getStatValue(ArtifactStatsManager.getAllStats(SpellsUtils.getSpell((Player)Minecraft.m_91087_().f_91074_, spell).serializeNBT()), statType);
                        if (artifactValue != 0.0f) {
                            String formattedArtifactValue = String.format(Locale.getDefault(), "%.1f%%", Float.valueOf(artifactValue)).replace('.', ',');
                            artifactString = String.format(" (%s%s)", artifactValue >= 0.0f ? "+" : "", formattedArtifactValue);
                        }
                    }
                }
                catch (IllegalArgumentException statType) {
                    // empty catch block
                }
                String result = String.format("\u00b7 %s: %s%s", name, formattedBaseValue, artifactString);
                GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, result, x + 16, y + 129 + yOff, this.color1, this.color2);
                yOff += 9;
            }
        }
        if (this.type.equals((Object)Type.KORLUNAR)) {
            this.renderTitle(guiGraphics, micon, x, y);
            if (micon.chapter.index.equals("kor_lunar_artifacts")) {
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/kor_lunar.png"), x + 57, y + 56, 0.0f, 0.0f, 46, 46, 46, 46);
                if (micon.tickCount % 5 == 0) {
                    float startX = (float)micon.f_96543_ / 2.0f - (float)micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
                    float startY = (float)micon.f_96544_ / 2.0f - (float)micon.backgroundWidth / 2.0f + 42.0f + 34.0f;
                    float directionX = pMouseX - startX;
                    float directionY = pMouseY - startY;
                    float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
                    float unitX = directionX / magnitude;
                    float unitY = directionY / magnitude;
                    float velocityX = unitX * 0.5f;
                    float velocityY = unitY * 0.5f;
                    micon.getParticleContainer().addParticle(new KorLunarParticle(startX + (float)new Random().nextInt(-20, 20), startY, velocityX, velocityY, 0.3f, 80, 2.0f, Color.WHITE));
                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + (float)new Random().nextInt(-20, 20), startY, 0.0f, 0.5f, 0.4f, 60, 2.0f, ElementsUtils.getColorByElement(Element.ETHER)));
                }
                List<ItemStack> itemStacks = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getArtifacts().values().stream().toList();
                StatType[] statTypes = new StatType[]{StatType.ATTACK_SPEED, StatType.DAMAGE, StatType.MOVEMENT_SPEED, StatType.ELEMENTAL_AMPLIFICATION};
                int yOff = 8;
                GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"etheria.curve").getString() + ":", x + 16, y + 120 + yOff, this.color1, this.color2);
                poseStack.m_85836_();
                poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                for (StatType stat2 : statTypes) {
                    float value = ArtifactStatCalculator.getStatValue(itemStacks, stat2);
                    String translateName = Component.m_237115_((String)("etheria.stat." + stat2.getName())).getString();
                    String formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                    GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00b7 \u00a7r" + translateName + ": \u00a7r" + formattedValue, (int)((double)(x + 16) * 1.25), (int)((double)(y + 129 + yOff) * 1.25), this.color1, this.color2);
                    yOff += 7;
                }
                poseStack.m_85849_();
            } else if (micon.chapter.index.equals("kor_lunar_elements")) {
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/kor_lunar.png"), x + 57, y + 74, 0.0f, 0.0f, 46, 46, 46, 46);
                if (micon.tickCount % 5 == 0) {
                    float startX = (float)micon.f_96543_ / 2.0f - (float)micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
                    float startY = (float)micon.f_96544_ / 2.0f - (float)micon.backgroundWidth / 2.0f + 60.0f + 34.0f;
                    float directionX = pMouseX - startX;
                    float directionY = pMouseY - startY;
                    float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
                    float unitX = directionX / magnitude;
                    float unitY = directionY / magnitude;
                    float velocityX = unitX * 0.5f;
                    float velocityY = unitY * 0.5f;
                    micon.getParticleContainer().addParticle(new KorLunarParticle(startX + (float)new Random().nextInt(-20, 20), startY, velocityX, velocityY, 0.3f, 80, 2.0f, Color.WHITE));
                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + (float)new Random().nextInt(-20, 20), startY, 0.0f, 0.5f, 0.4f, 60, 2.0f, ElementsUtils.getColorByElement(Element.ETHER)));
                }
            }
            if (micon.chapter.index.equals("kor_lunar_upgrade")) {
                int korLevel = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getKorLunar();
                String level = korLevel + 1 + " " + Component.m_237115_((String)"etheria.lvl").getString();
                GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, level, x + 83, y + 88, this.color1, this.color2);
                KorLunarLevel lunarLevel = KorLunarLevels.getLevel(korLevel);
                if (lunarLevel == null) {
                    return;
                }
                if (!lunarLevel.getRitual().isEmpty()) {
                    GuiUtils.renderItemWithTooltip(guiGraphics, ((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_(), x + 74, y + 102, 1.0f, pMouseX, pMouseY);
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), x + 74 - 1, y + 102 - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                    String ritual = Component.m_237115_((String)("mage_micon.rituals." + lunarLevel.getRitual())).getString();
                    String request = Component.m_237115_((String)"mage_micon.ritual_request").getString();
                    String finalString = request + ": " + ritual;
                    List lines = Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)finalString), 136, Style.f_131099_);
                    int yOff = 0;
                    for (FormattedText line3 : lines) {
                        GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, line3.getString(), x + 83, y + 124 + yOff, this.color1, this.color2);
                        yOff += 9;
                    }
                } else {
                    int totalItems = lunarLevel.getIngredients().size();
                    int rows = totalItems > 4 ? 2 : 1;
                    int columns = Math.min(totalItems, 4);
                    int num = 0;
                    int baseX = x + 37 + (4 - columns) * 12;
                    int baseY = y + 90 + (2 - rows) * 15;
                    for (ItemStack item : lunarLevel.getIngredients()) {
                        int row = num / 4;
                        int col = num % 4;
                        int offset = 0;
                        if (totalItems == 5 && row == 1) {
                            offset = 34;
                        } else if (totalItems == 6 && row == 1) {
                            offset = 23;
                        } else if (totalItems == 7 && row == 1) {
                            offset = 11;
                        } else if (totalItems == 8 && row == 1) {
                            offset = 0;
                        }
                        int offX = baseX + col * 23 + offset;
                        int offY = baseY + row * 30;
                        GuiUtils.renderItemWithTooltip(guiGraphics, item.m_41720_(), offX, offY, 1.0f, pMouseX, pMouseY);
                        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), offX - 1, offY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                        if (item.m_41613_() > 1) {
                            String countText = String.valueOf(item.m_41613_());
                            int xOffset = offX + 20 - Minecraft.m_91087_().f_91062_.m_92895_(countText) / 2;
                            int yOffset = offY + 16 - 4;
                            poseStack.m_252880_(0.0f, 0.0f, 200.0f);
                            GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, countText, xOffset, yOffset, 14003075, 9858892);
                            poseStack.m_252880_(0.0f, 0.0f, -200.0f);
                        }
                        ++num;
                    }
                }
            } else if (micon.chapter.index.equals("reroll_artifacts")) {
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/plus.png"), x + 55, y + 90 + 15, 0.0f, 0.0f, 12, 12, 12, 12);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/next_page.png"), x + 96, y + 90 + 15, 19.0f, 0.0f, 19, 11, 38, 11);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/kor_lunar.png"), x + 57, y + 39, 0.0f, 0.0f, 46, 46, 46, 46);
                if (micon.tickCount % 5 == 0) {
                    float startX = (float)micon.f_96543_ / 2.0f - (float)micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
                    float startY = (float)micon.f_96544_ / 2.0f - (float)micon.backgroundWidth / 2.0f + 60.0f;
                    float directionX = pMouseX - startX;
                    float directionY = pMouseY - startY;
                    float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
                    float unitX = directionX / magnitude;
                    float unitY = directionY / magnitude;
                    float velocityX = unitX * 0.5f;
                    float velocityY = unitY * 0.5f;
                    micon.getParticleContainer().addParticle(new KorLunarParticle(startX + (float)new Random().nextInt(-20, 20), startY, velocityX, velocityY, 0.3f, 80, 2.0f, Color.WHITE));
                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + (float)new Random().nextInt(-20, 20), startY, 0.0f, 0.5f, 0.4f, 60, 2.0f, ElementsUtils.getColorByElement(Element.ETHER)));
                }
                List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)this.text, (String)this.text), 136);
                int yOff = 0;
                for (FormattedCharSequence line4 : lines) {
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line4, x + 15, y + 40 + yOff, this.color1, false);
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line4, x + 14, y + 39 + yOff, this.color2, false);
                    yOff += 9;
                }
                SlotWidget widget = SlotWidget.getFirstSlot(micon);
                ItemStack itemStack = widget.selectedItem;
                if (itemStack.m_41720_() instanceof ArtifactItem) {
                    Map<StatType, Float> mainStats = ArtifactStatsManager.getMainStats(itemStack);
                    Map<StatType, Float> stats = ArtifactStatsManager.getSecondaryStats(itemStack);
                    yOff = 4;
                    if (!mainStats.isEmpty() && !stats.isEmpty()) {
                        StatType stat3;
                        GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"etheria.curve").getString() + ":", x + 16, y + 120 + yOff, this.color1, this.color2);
                        poseStack.m_85836_();
                        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                        for (Map.Entry<StatType, Float> entry : mainStats.entrySet()) {
                            stat3 = entry.getKey();
                            if (stat3.equals((Object)StatType.NONE)) continue;
                            float value = entry.getValue().floatValue();
                            String translateName = Component.m_237115_((String)("etheria.stat." + stat3.getName())).getString();
                            String formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                            GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00b7 \u00a7r" + translateName + ": \u00a7r" + formattedValue, (int)((double)(x + 16) * 1.25), (int)((double)(y + 129 + yOff) * 1.25), this.color1, this.color2);
                            yOff += 7;
                        }
                        for (Map.Entry<StatType, Float> entry : stats.entrySet()) {
                            stat3 = entry.getKey();
                            if (stat3.equals((Object)StatType.NONE)) continue;
                            float value = entry.getValue().floatValue();
                            String translateName = Component.m_237115_((String)("etheria.stat." + stat3.getName())).getString();
                            String formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                            GuiUtils.drawStringShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00a7o\u00b7 " + translateName + ": " + formattedValue, (int)((double)(x + 16) * 1.25), (int)((double)(y + 129 + yOff) * 1.25), this.color1, this.color2);
                            yOff += 7;
                        }
                        poseStack.m_85849_();
                    }
                }
            } else if (micon.chapter.index.equals("spell_upgrade")) {
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/plus.png"), x + 55, y + 90 + 40, 0.0f, 0.0f, 12, 12, 12, 12);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/next_page.png"), x + 96, y + 90 + 40, 19.0f, 0.0f, 19, 11, 38, 11);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/kor_lunar.png"), x + 57, y + 39, 0.0f, 0.0f, 46, 46, 46, 46);
                if (micon.tickCount % 5 == 0) {
                    float startX = (float)micon.f_96543_ / 2.0f - (float)micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
                    float startY = (float)micon.f_96544_ / 2.0f - (float)micon.backgroundWidth / 2.0f + 60.0f;
                    float directionX = pMouseX - startX;
                    float directionY = pMouseY - startY;
                    float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
                    float unitX = directionX / magnitude;
                    float unitY = directionY / magnitude;
                    float velocityX = unitX * 0.5f;
                    float velocityY = unitY * 0.5f;
                    micon.getParticleContainer().addParticle(new KorLunarParticle(startX + (float)new Random().nextInt(-20, 20), startY, velocityX, velocityY, 0.3f, 80, 2.0f, Color.WHITE));
                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + (float)new Random().nextInt(-20, 20), startY, 0.0f, 0.5f, 0.4f, 60, 2.0f, ElementsUtils.getColorByElement(Element.ETHER)));
                }
                List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)this.text, (String)this.text), 136);
                int yOff = 0;
                for (FormattedCharSequence line5 : lines) {
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line5, x + 15, y + 40 + yOff, this.color1, false);
                    guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line5, x + 14, y + 39 + yOff, this.color2, false);
                    yOff += 9;
                }
            }
        }
        if (this.type.equals((Object)Type.ANVIL)) {
            this.renderTitle(guiGraphics, micon, x, y);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/plus.png"), x + 55, y + 90 + 40, 0.0f, 0.0f, 12, 12, 12, 12);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/next_page.png"), x + 96, y + 90 + 40, 19.0f, 0.0f, 19, 11, 38, 11);
            List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)this.text, (String)this.text), 136);
            int yOff = 0;
            for (FormattedCharSequence line6 : lines) {
                guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line6, x + 15, y + 40 + yOff, this.color1, false);
                guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line6, x + 14, y + 39 + yOff, this.color2, false);
                yOff += 9;
            }
        }
        if (this.type.equals((Object)Type.TEXT)) {
            this.renderTitle(guiGraphics, micon, x, y);
            List lines = TranslationHandler.build().contains(this.text) ? Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)TranslationHandler.translate(this.text)), 136) : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)this.text, (String)this.text), 136);
            int yOff = 0;
            for (FormattedCharSequence line7 : lines) {
                guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line7, x + 15, y + 40 + yOff, this.color1, false);
                guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line7, x + 14, y + 39 + yOff, this.color2, false);
                yOff += 9;
            }
        }
        if (this.type.equals((Object)Type.RITUAL)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/title.png"), x + 16, y + 30, 0.0f, 0.0f, 134, 7, 134, 7);
            String itemId = ItemUtils.convertItemString(micon.item.m_41720_().m_5524_());
            Map<String, RitualData> ritualMap = RitualRegistry.getAllRituals();
            RitualData ritual = ritualMap.get(itemId);
            ItemStack itemStack = micon.item;
            if (ritual == null) {
                ritual = ritualMap.get(micon.id);
                String ritualName = Component.m_237115_((String)("mage_micon.rituals." + micon.id)).getString();
                if (ritual == null) {
                    ritual = ritualMap.get(this.index);
                    ritualName = Component.m_237115_((String)("mage_micon.rituals." + this.index)).getString();
                }
                if (itemStack.m_41619_() && ritual != null) {
                    itemStack = ritual.getResult().getResultItem();
                }
                GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00bb " + ritualName + " \u00ab", x + 16 + 67, y + 23, this.color1, this.color2);
            } else {
                String displayName = itemStack.m_41611_().getString();
                GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00bb " + displayName + " \u00ab", x + 16 + 67, y + 23, this.color1, this.color2);
            }
            if (ritual == null) {
                return;
            }
            if (!ritual.getDescription().isEmpty()) {
                if (pageIndex == 0) {
                    List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_264568_((String)ritual.getDescription(), (String)ritual.getDescription()), 136);
                    int yOff = 0;
                    for (FormattedCharSequence line8 : lines) {
                        guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line8, x + 15, y + 40 + yOff, this.color1, false);
                        guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, line8, x + 14, y + 39 + yOff, this.color2, false);
                        yOff += 9;
                    }
                }
                if (this.pageOffSet == 0) {
                    this.pageOffSet = 1;
                }
            }
            if (pageIndex == this.pageOffSet) {
                if (itemStack.m_41720_().equals(((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_())) {
                    itemStack = Items.f_41852_.m_7968_();
                }
                GuiUtils.renderItemWithTooltip(guiGraphics, itemStack, (int)((double)x + 64.5), y + 40, 2.0f, pMouseX, pMouseY, true, false);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), (int)((double)x + 64.5) - 2, y + 40 - 2, 0.0f, 0.0f, 36, 36, 36, 36);
                if (ritual != null && ritual.getCrashChance() != 0.0f) {
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/warn.png"), x + 140, y + 40, 0.0f, 0.0f, 5, 14, 5, 14);
                    if (GuiUtils.isHovered(x + 140, y + 40, 5, 14, (int)pMouseX, (int)pMouseY)) {
                        MutableComponent rawComponent = Component.m_237110_((String)"mage_micon.warn.ritual_crash", (Object[])new Object[]{Float.valueOf(ritual.getCrashChance())});
                        Style style = Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(Element.PYRO).getRGB());
                        String[] splitLines = rawComponent.getString().split("\n");
                        List lines = Arrays.stream(splitLines).map(line -> Component.m_237113_((String)line).m_130948_(style)).collect(Collectors.toList());
                        GuiUtils.renderCustomTooltip(guiGraphics, Minecraft.m_91087_().f_91062_, lines, (int)pMouseX, (int)pMouseY + 9, ElementsUtils.getColorByElement(Element.PYRO).getRGB(), ElementsUtils.getEndColorByElement(Element.PYRO).getRGB());
                    }
                }
                if (ritual.isEnigma()) {
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), x + 66, (y += 40) + 44, 0.0f, 0.0f, 26, 26, 26, 26);
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        Page.renderEntityInInventoryFollowsAngle(guiGraphics, x + 79, y + 64, 20, pMouseX, pMouseY, ((EntityType)EntityRegistry.SHADOW_NIHILIS.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_));
                    }
                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)(x + 71) + (new Random().nextFloat() - new Random().nextFloat()) * 10.0f, (float)(y + 52) + (new Random().nextFloat() - new Random().nextFloat()) * 10.0f, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, EnigmaUtils.getEnigmaStartColor(micon.tickCount)));
                }
                if (ritual != null) {
                    ItemStack[] itemStacks = ritual.getMainIngredient().m_43908_();
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), x + 42 + 25 - 1, y + 98 - 9, 0.0f, 0.0f, 26, 26, 26, 26);
                    GuiUtils.renderItemWithTooltip(guiGraphics, ((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_().m_7968_(), x + 42 + 25, y + 98 - 8, 1.5f, pMouseX, pMouseY, true, false);
                    if (itemStacks.length > 0) {
                        ItemStack item = itemStacks[0];
                        GuiUtils.renderItemWithTooltip(guiGraphics, item, x + 42 + 25 + 2, y + 98 - 24, 1.25f, pMouseX, pMouseY, true, false);
                    } else {
                        GuiUtils.renderItemWithTooltip(guiGraphics, Items.f_41852_.m_7968_(), x + 42 + 25 + 2, y + 98 - 24, 1.25f, pMouseX, pMouseY, true, false);
                    }
                    GuiUtils.renderItemWithTooltip(guiGraphics, ((EtherDistributor)BlockRegistry.ETHER_DISTRIBUTOR.get()).m_5456_().m_7968_(), x + 43, y + 98, 1.0f, pMouseX, pMouseY, true, false);
                    ItemStack orb = null;
                    int minEther = Integer.MAX_VALUE;
                    for (RegistryObject itemRegistryObject : ItemRegistry.ITEMS.getEntries()) {
                        IEtherEntryItem iEtherEntryItem;
                        int maxEther;
                        Item item1;
                        if (!itemRegistryObject.isPresent() || !((item1 = (Item)itemRegistryObject.get()) instanceof IEtherEntryItem) || (maxEther = (iEtherEntryItem = (IEtherEntryItem)item1).getMaxEther()) < ritual.getRequiredEther() || maxEther >= minEther) continue;
                        minEther = maxEther;
                        orb = new ItemStack((ItemLike)item1);
                    }
                    EtherUtils.setEther(orb, ritual.getRequiredEther());
                    GuiUtils.renderItemWithTooltip(guiGraphics, orb, x + 43, y + 86, 1.0f, pMouseX, pMouseY, true, false);
                    if (micon.tickCount % 10 == 0) {
                        micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)(x + 43) + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, y + 86, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, ElementsUtils.getColorByElement(Element.ETHER)));
                    }
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), x + 43, y + 98, 0.0f, 0.0f, 16, 16, 16, 16);
                    int offX = 0;
                    int offY = 0;
                    int num = 0;
                    for (RuneItem runeItem : ritual.getRunes().values()) {
                        int totalItems = ritual.getRunes().size();
                        if (totalItems == 1) {
                            offX = 4;
                        }
                        GuiUtils.renderItemWithTooltip(guiGraphics, ((RunicPedestal)BlockRegistry.RUNIC_PEDESTAL.get()).m_5456_().m_7968_(), x + offX + 98, y + offY + 98, 1.0f, pMouseX, pMouseY, true, false);
                        GuiUtils.renderItemWithTooltip(guiGraphics, runeItem.m_7968_(), x + offX + 98, y + offY + 86, 1.0f, pMouseX, pMouseY, true, false);
                        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), x + offX + 98, y + offY + 98, 0.0f, 0.0f, 16, 16, 16, 16);
                        if (micon.tickCount % 10 == 0) {
                            micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)(x + offX) + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f + 98.0f, y + offY + 86, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, ElementsUtils.getColorByElement(runeItem.getElement())));
                        }
                        if (totalItems <= 1) continue;
                        offX += 17;
                        ++num;
                    }
                    int totalItems = ritual.getIngredients().size();
                    int rows = totalItems > 4 ? 2 : 1;
                    int columns = Math.min(totalItems, 4);
                    num = 0;
                    int baseX = x + 36 + (4 - columns) * 12;
                    int baseY = y + 116 + (2 - rows) * 15;
                    for (Ingredient ingredient : ritual.getIngredients().values()) {
                        ItemStack[] stacks = ingredient.m_43908_();
                        if (stacks.length > 0) {
                            ItemStack item = stacks[0];
                            int row = num / 4;
                            int col = num % 4;
                            int offset = 0;
                            if (totalItems == 5 && row == 1) {
                                offset = 34;
                            } else if (totalItems == 6 && row == 1) {
                                offset = 23;
                            } else if (totalItems == 7 && row == 1) {
                                offset = 11;
                            } else if (totalItems == 8 && row == 1) {
                                offset = 0;
                            }
                            offX = baseX + col * 23 + offset;
                            offY = baseY + row * 30;
                            GuiUtils.renderItemWithTooltip(guiGraphics, ((EtherPedestal)BlockRegistry.ETHER_PEDESTAL.get()).m_5456_().m_7968_(), offX, offY + 12, 1.0f, pMouseX, pMouseY, true, false);
                            GuiUtils.renderItemWithTooltip(guiGraphics, item, offX, offY, 1.0f, pMouseX, pMouseY, true, false);
                            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), offX, offY + 13, 0.0f, 0.0f, 16, 16, 16, 16);
                            Item item3 = item.m_41720_();
                            if (item3 instanceof IElementItem) {
                                IElementItem elementItem = (IElementItem)item3;
                                if (micon.tickCount % 10 == 0) {
                                    micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)offX + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, offY - 3, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, ElementsUtils.getColorByElement(elementItem.getElement())));
                                }
                            }
                        }
                        ++num;
                    }
                }
            } else if (pageIndex == 1) {
                // empty if block
            }
        }
    }

    private void renderTitle(GuiGraphics guiGraphics, MageMicon micon, int x, int y) {
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/title.png"), x + 16, y + 30, 0.0f, 0.0f, 134, 7, 134, 7);
        String title = Component.m_237110_((String)this.index, (Object[])new Object[]{this.index}).getString();
        if (this.index == null || this.index.isEmpty()) {
            title = Component.m_237110_((String)("mage_micon.category." + micon.category.index), (Object[])new Object[]{"mage_micon.category." + micon.category.index}).getString();
        }
        if (micon.page1 != null && micon.page1.type.equals((Object)Type.SPELL) && micon.page2 != null) {
            title = GuiUtils.translate("mage_micon.spell." + micon.page2.index).getString();
        }
        GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00bb " + title + " \u00ab", x + 16 + 67, y + 23, this.color1, this.color2);
    }

    public static void renderRecipe(GuiGraphics guiGraphics, CraftingRecipe recipe, int startX, int startY, float pMouseX, float pMouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/crafting.png"), startX, startY, 0.0f, 0.0f, 101, 58, 101, 58);
            ++startX;
            ++startY;
            int slotSize = 18;
            int spacing = 2;
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                int row = i / 3;
                int col = i % 3;
                int x = startX + col * (slotSize + spacing);
                int y = startY + row * (slotSize + spacing);
                ItemStack[] matchingStacks = ((Ingredient)recipe.m_7527_().get(i)).m_43908_();
                if (matchingStacks.length <= 0) continue;
                ItemStack stack = matchingStacks[0];
                GuiUtils.renderItemWithTooltip(guiGraphics, stack, x, y, 1.0f, pMouseX, pMouseY, true, false);
            }
            int resultX = startX + 3 * slotSize + 29;
            int resultY = startY + slotSize + 2;
            ItemStack resultStack = recipe.m_8043_(minecraft.f_91073_.m_9598_());
            GuiUtils.renderItemWithTooltip(guiGraphics, resultStack, resultX, resultY, 1.0f, pMouseX, pMouseY, false, false);
        }
    }

    public static Optional<CraftingRecipe> getRecipeForItem(ItemStack resultStack) {
        RecipeManager recipeManager = null;
        if (Minecraft.m_91087_().f_91073_ != null) {
            recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
            return recipeManager.m_44013_(RecipeType.f_44107_).stream().filter(recipe -> ItemStack.m_41656_((ItemStack)recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), (ItemStack)resultStack)).findFirst();
        }
        return Optional.empty();
    }

    private void renderTitle(GuiGraphics guiGraphics, MageMicon micon, String title, int x, int y) {
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/title.png"), x + 16, y + 30, 0.0f, 0.0f, 134, 7, 134, 7);
        GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "\u00bb " + title + " \u00ab", x + 16 + 67, y + 23, this.color1, this.color2);
    }

    private static Object byTime(Object ... objects) {
        return GuiUtils.getObjectByTime(40, objects);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float pMouseX, float pMouseY, Entity entity) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 50.0f);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf rotationZ = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf rotationX = Axis.f_252529_.m_252977_(-25.0f);
        Quaternionf rotationY = Axis.f_252436_.m_252977_(-25.0f);
        rotationZ.mul((Quaternionfc)rotationX);
        rotationZ.mul((Quaternionfc)rotationY);
        poseStack.m_252781_(rotationZ);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        rotationX.conjugate();
        entityRenderDispatcher.m_252923_(rotationX);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        poseStack.m_85849_();
        Lighting.m_84931_();
    }

    public String getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    public Type getType() {
        return this.type;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    @Nullable
    public EntityType getEntity() {
        return this.entity;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public Item getUpItem() {
        return this.upItem;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public int getPageOffSet() {
        return this.pageOffSet;
    }

    @Nullable
    public Entity getCreatedEntity() {
        return this.createdEntity;
    }

    public String getTag() {
        return this.tag;
    }

    public int getColor1() {
        return this.color1;
    }

    public int getColor2() {
        return this.color2;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setEntity(@Nullable EntityType entity) {
        this.entity = entity;
    }

    public void setItem(@Nullable Item item) {
        this.item = item;
    }

    public void setUpItem(@Nullable Item upItem) {
        this.upItem = upItem;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
    }

    public void setPageOffSet(int pageOffSet) {
        this.pageOffSet = pageOffSet;
    }

    public void setCreatedEntity(@Nullable Entity createdEntity) {
        this.createdEntity = createdEntity;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setColor1(int color1) {
        this.color1 = color1;
    }

    public void setColor2(int color2) {
        this.color2 = color2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSortIndex() != other.getSortIndex()) {
            return false;
        }
        if (this.getPageOffSet() != other.getPageOffSet()) {
            return false;
        }
        if (this.getColor1() != other.getColor1()) {
            return false;
        }
        if (this.getColor2() != other.getColor2()) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EntityType this$entity = this.getEntity();
        EntityType other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        Item this$item = this.getItem();
        Item other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        Item this$upItem = this.getUpItem();
        Item other$upItem = other.getUpItem();
        if (this$upItem == null ? other$upItem != null : !this$upItem.equals(other$upItem)) {
            return false;
        }
        List<ItemStack> this$items = this.getItems();
        List<ItemStack> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Entity this$createdEntity = this.getCreatedEntity();
        Entity other$createdEntity = other.getCreatedEntity();
        if (this$createdEntity == null ? other$createdEntity != null : !this$createdEntity.equals(other$createdEntity)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSortIndex();
        result = result * 59 + this.getPageOffSet();
        result = result * 59 + this.getColor1();
        result = result * 59 + this.getColor2();
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EntityType $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        Item $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        Item $upItem = this.getUpItem();
        result = result * 59 + ($upItem == null ? 43 : $upItem.hashCode());
        List<ItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Entity $createdEntity = this.getCreatedEntity();
        result = result * 59 + ($createdEntity == null ? 43 : $createdEntity.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    public String toString() {
        return "Page(index=" + this.getIndex() + ", text=" + this.getText() + ", type=" + this.getType() + ", sortIndex=" + this.getSortIndex() + ", entity=" + this.getEntity() + ", item=" + this.getItem() + ", upItem=" + this.getUpItem() + ", items=" + this.getItems() + ", pageOffSet=" + this.getPageOffSet() + ", createdEntity=" + this.getCreatedEntity() + ", tag=" + this.getTag() + ", color1=" + this.getColor1() + ", color2=" + this.getColor2() + ")";
    }

    public static enum Type {
        TITLE,
        ENTITY,
        ITEMS,
        RITUAL,
        TEXT,
        KORLUNAR,
        ANVIL,
        SPELL,
        CRAFTING;

    }
}

