/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon.data;

import it.mralxart.etheria.magic.magemicon.data.IconData;
import it.mralxart.etheria.magic.magemicon.data.ItemsData;
import it.mralxart.etheria.magic.magemicon.data.PageData;
import it.mralxart.etheria.magic.magemicon.data.RecipeData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ChapterData {
    private int index;
    private final String id;
    private Map<String, PageData> pages;
    private Map<String, RecipeData> recipes;
    private Map<String, ItemsData> items;
    private Map<String, String> rituals;
    private boolean priority;
    private int advancement;
    private int reqMagicLvl;
    private boolean secret;
    private String text;
    private boolean locked;
    private Item hintItem;
    private String hintString;
    private IconData iconData;

    public static ChapterDataBuilder builder(String id, String texture) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(-1);
        builder.iconData(IconData.builder(texture, IconData.Type.TEXTURE).build());
        return builder;
    }

    public static ChapterDataBuilder builder(String id, String texture, int index) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(index);
        builder.iconData(IconData.builder(texture, IconData.Type.TEXTURE).build());
        return builder;
    }

    public static ChapterDataBuilder builder(String id, ItemLike itemLike) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(-1);
        builder.iconData(IconData.builder(new ItemStack(itemLike), IconData.Type.ITEM).build());
        return builder;
    }

    public static ChapterDataBuilder builder(String id, ItemLike itemLike, int index) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(index);
        builder.iconData(IconData.builder(new ItemStack(itemLike), IconData.Type.ITEM).build());
        return builder;
    }

    public static ChapterDataBuilder builder(String id) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(-1);
        return builder;
    }

    public static ChapterDataBuilder builder(String id, int index) {
        ChapterDataBuilder builder = new ChapterDataBuilder();
        builder.id(id);
        builder.index(index);
        return builder;
    }

    private static boolean $default$priority() {
        return false;
    }

    private static int $default$advancement() {
        return 0;
    }

    private static int $default$reqMagicLvl() {
        return 0;
    }

    private static boolean $default$secret() {
        return false;
    }

    private static String $default$text() {
        return "";
    }

    private static boolean $default$locked() {
        return false;
    }

    private static Item $default$hintItem() {
        return ItemStack.f_41583_.m_41720_();
    }

    private static String $default$hintString() {
        return "";
    }

    private static IconData $default$iconData() {
        return IconData.builder().icon(new ItemStack((ItemLike)Items.f_41852_)).type(IconData.Type.ITEM).build();
    }

    ChapterData(int index, String id, Map<String, PageData> pages, Map<String, RecipeData> recipes, Map<String, ItemsData> items, Map<String, String> rituals, boolean priority, int advancement, int reqMagicLvl, boolean secret, String text, boolean locked, Item hintItem, String hintString, IconData iconData) {
        this.index = index;
        this.id = id;
        this.pages = pages;
        this.recipes = recipes;
        this.items = items;
        this.rituals = rituals;
        this.priority = priority;
        this.advancement = advancement;
        this.reqMagicLvl = reqMagicLvl;
        this.secret = secret;
        this.text = text;
        this.locked = locked;
        this.hintItem = hintItem;
        this.hintString = hintString;
        this.iconData = iconData;
    }

    public int getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, PageData> getPages() {
        return this.pages;
    }

    public Map<String, RecipeData> getRecipes() {
        return this.recipes;
    }

    public Map<String, ItemsData> getItems() {
        return this.items;
    }

    public Map<String, String> getRituals() {
        return this.rituals;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public int getAdvancement() {
        return this.advancement;
    }

    public int getReqMagicLvl() {
        return this.reqMagicLvl;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Item getHintItem() {
        return this.hintItem;
    }

    public String getHintString() {
        return this.hintString;
    }

    public IconData getIconData() {
        return this.iconData;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPages(Map<String, PageData> pages) {
        this.pages = pages;
    }

    public void setRecipes(Map<String, RecipeData> recipes) {
        this.recipes = recipes;
    }

    public void setItems(Map<String, ItemsData> items) {
        this.items = items;
    }

    public void setRituals(Map<String, String> rituals) {
        this.rituals = rituals;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public void setAdvancement(int advancement) {
        this.advancement = advancement;
    }

    public void setReqMagicLvl(int reqMagicLvl) {
        this.reqMagicLvl = reqMagicLvl;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setHintItem(Item hintItem) {
        this.hintItem = hintItem;
    }

    public void setHintString(String hintString) {
        this.hintString = hintString;
    }

    public void setIconData(IconData iconData) {
        this.iconData = iconData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChapterData)) {
            return false;
        }
        ChapterData other = (ChapterData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.isPriority() != other.isPriority()) {
            return false;
        }
        if (this.getAdvancement() != other.getAdvancement()) {
            return false;
        }
        if (this.getReqMagicLvl() != other.getReqMagicLvl()) {
            return false;
        }
        if (this.isSecret() != other.isSecret()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, PageData> this$pages = this.getPages();
        Map<String, PageData> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        Map<String, RecipeData> this$recipes = this.getRecipes();
        Map<String, RecipeData> other$recipes = other.getRecipes();
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        Map<String, ItemsData> this$items = this.getItems();
        Map<String, ItemsData> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Map<String, String> this$rituals = this.getRituals();
        Map<String, String> other$rituals = other.getRituals();
        if (this$rituals == null ? other$rituals != null : !((Object)this$rituals).equals(other$rituals)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Item this$hintItem = this.getHintItem();
        Item other$hintItem = other.getHintItem();
        if (this$hintItem == null ? other$hintItem != null : !this$hintItem.equals(other$hintItem)) {
            return false;
        }
        String this$hintString = this.getHintString();
        String other$hintString = other.getHintString();
        if (this$hintString == null ? other$hintString != null : !this$hintString.equals(other$hintString)) {
            return false;
        }
        IconData this$iconData = this.getIconData();
        IconData other$iconData = other.getIconData();
        return !(this$iconData == null ? other$iconData != null : !((Object)this$iconData).equals(other$iconData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChapterData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + (this.isPriority() ? 79 : 97);
        result = result * 59 + this.getAdvancement();
        result = result * 59 + this.getReqMagicLvl();
        result = result * 59 + (this.isSecret() ? 79 : 97);
        result = result * 59 + (this.isLocked() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, PageData> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        Map<String, RecipeData> $recipes = this.getRecipes();
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        Map<String, ItemsData> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Map<String, String> $rituals = this.getRituals();
        result = result * 59 + ($rituals == null ? 43 : ((Object)$rituals).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Item $hintItem = this.getHintItem();
        result = result * 59 + ($hintItem == null ? 43 : $hintItem.hashCode());
        String $hintString = this.getHintString();
        result = result * 59 + ($hintString == null ? 43 : $hintString.hashCode());
        IconData $iconData = this.getIconData();
        result = result * 59 + ($iconData == null ? 43 : ((Object)$iconData).hashCode());
        return result;
    }

    public String toString() {
        return "ChapterData(index=" + this.getIndex() + ", id=" + this.getId() + ", pages=" + this.getPages() + ", recipes=" + this.getRecipes() + ", items=" + this.getItems() + ", rituals=" + this.getRituals() + ", priority=" + this.isPriority() + ", advancement=" + this.getAdvancement() + ", reqMagicLvl=" + this.getReqMagicLvl() + ", secret=" + this.isSecret() + ", text=" + this.getText() + ", locked=" + this.isLocked() + ", hintItem=" + this.getHintItem() + ", hintString=" + this.getHintString() + ", iconData=" + this.getIconData() + ")";
    }

    public static class ChapterDataBuilder {
        private int index;
        private String id;
        private boolean priority$set;
        private boolean priority$value;
        private boolean advancement$set;
        private int advancement$value;
        private boolean reqMagicLvl$set;
        private int reqMagicLvl$value;
        private boolean secret$set;
        private boolean secret$value;
        private boolean text$set;
        private String text$value;
        private boolean locked$set;
        private boolean locked$value;
        private boolean hintItem$set;
        private Item hintItem$value;
        private boolean hintString$set;
        private String hintString$value;
        private boolean iconData$set;
        private IconData iconData$value;
        private Map<String, PageData> pages = new HashMap<String, PageData>();
        private Map<String, RecipeData> recipes = new HashMap<String, RecipeData>();
        private Map<String, ItemsData> items = new HashMap<String, ItemsData>();
        private Map<String, String> rituals = new HashMap<String, String>();

        public ChapterDataBuilder page(PageData modifier) {
            this.pages.put(modifier.getId(), modifier);
            return this;
        }

        public ChapterDataBuilder recipe(RecipeData data) {
            this.recipes.put(data.getId(), data);
            return this;
        }

        public ChapterDataBuilder item(ItemsData data) {
            this.items.put(data.getMarker(), data);
            return this;
        }

        public ChapterDataBuilder ritual(String id, String data) {
            this.rituals.put(id, data);
            return this;
        }

        ChapterDataBuilder() {
        }

        public ChapterDataBuilder index(int index) {
            this.index = index;
            return this;
        }

        public ChapterDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ChapterDataBuilder pages(Map<String, PageData> pages) {
            this.pages = pages;
            return this;
        }

        public ChapterDataBuilder recipes(Map<String, RecipeData> recipes) {
            this.recipes = recipes;
            return this;
        }

        public ChapterDataBuilder items(Map<String, ItemsData> items) {
            this.items = items;
            return this;
        }

        public ChapterDataBuilder rituals(Map<String, String> rituals) {
            this.rituals = rituals;
            return this;
        }

        public ChapterDataBuilder priority(boolean priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        public ChapterDataBuilder advancement(int advancement) {
            this.advancement$value = advancement;
            this.advancement$set = true;
            return this;
        }

        public ChapterDataBuilder reqMagicLvl(int reqMagicLvl) {
            this.reqMagicLvl$value = reqMagicLvl;
            this.reqMagicLvl$set = true;
            return this;
        }

        public ChapterDataBuilder secret(boolean secret) {
            this.secret$value = secret;
            this.secret$set = true;
            return this;
        }

        public ChapterDataBuilder text(String text) {
            this.text$value = text;
            this.text$set = true;
            return this;
        }

        public ChapterDataBuilder locked(boolean locked) {
            this.locked$value = locked;
            this.locked$set = true;
            return this;
        }

        public ChapterDataBuilder hintItem(Item hintItem) {
            this.hintItem$value = hintItem;
            this.hintItem$set = true;
            return this;
        }

        public ChapterDataBuilder hintString(String hintString) {
            this.hintString$value = hintString;
            this.hintString$set = true;
            return this;
        }

        public ChapterDataBuilder iconData(IconData iconData) {
            this.iconData$value = iconData;
            this.iconData$set = true;
            return this;
        }

        public ChapterData build() {
            boolean priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = ChapterData.$default$priority();
            }
            int advancement$value = this.advancement$value;
            if (!this.advancement$set) {
                advancement$value = ChapterData.$default$advancement();
            }
            int reqMagicLvl$value = this.reqMagicLvl$value;
            if (!this.reqMagicLvl$set) {
                reqMagicLvl$value = ChapterData.$default$reqMagicLvl();
            }
            boolean secret$value = this.secret$value;
            if (!this.secret$set) {
                secret$value = ChapterData.$default$secret();
            }
            String text$value = this.text$value;
            if (!this.text$set) {
                text$value = ChapterData.$default$text();
            }
            boolean locked$value = this.locked$value;
            if (!this.locked$set) {
                locked$value = ChapterData.$default$locked();
            }
            Item hintItem$value = this.hintItem$value;
            if (!this.hintItem$set) {
                hintItem$value = ChapterData.$default$hintItem();
            }
            String hintString$value = this.hintString$value;
            if (!this.hintString$set) {
                hintString$value = ChapterData.$default$hintString();
            }
            IconData iconData$value = this.iconData$value;
            if (!this.iconData$set) {
                iconData$value = ChapterData.$default$iconData();
            }
            return new ChapterData(this.index, this.id, this.pages, this.recipes, this.items, this.rituals, priority$value, advancement$value, reqMagicLvl$value, secret$value, text$value, locked$value, hintItem$value, hintString$value, iconData$value);
        }

        public String toString() {
            return "ChapterData.ChapterDataBuilder(index=" + this.index + ", id=" + this.id + ", pages=" + this.pages + ", recipes=" + this.recipes + ", items=" + this.items + ", rituals=" + this.rituals + ", priority$value=" + this.priority$value + ", advancement$value=" + this.advancement$value + ", reqMagicLvl$value=" + this.reqMagicLvl$value + ", secret$value=" + this.secret$value + ", text$value=" + this.text$value + ", locked$value=" + this.locked$value + ", hintItem$value=" + this.hintItem$value + ", hintString$value=" + this.hintString$value + ", iconData$value=" + this.iconData$value + ")";
        }
    }
}

