/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ItemsData {
    private final String marker;
    private final Item upItem;
    private List<Item> items;

    public static ItemsDataBuilder builder() {
        ItemsDataBuilder builder = new ItemsDataBuilder();
        builder.items = new ArrayList<Item>();
        return builder;
    }

    public static ItemsDataBuilder builder(String marker, ItemLike ... object) {
        ItemsDataBuilder builder = new ItemsDataBuilder();
        builder.items = new ArrayList<Item>();
        builder.marker(marker);
        Arrays.stream(object).forEach(o -> builder.items.add(o.m_5456_()));
        return builder;
    }

    public static ItemsDataBuilder builder(Item item, String marker, Object ... object) {
        ItemsDataBuilder builder = new ItemsDataBuilder();
        builder.items = new ArrayList<Item>();
        builder.marker(marker);
        builder.upItem = item;
        Arrays.stream(object).forEach(o -> {
            if (o instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)o;
                builder.items.add(itemLike.m_5456_());
            }
        });
        return builder;
    }

    ItemsData(String marker, Item upItem, List<Item> items) {
        this.marker = marker;
        this.upItem = upItem;
        this.items = items;
    }

    public String getMarker() {
        return this.marker;
    }

    public Item getUpItem() {
        return this.upItem;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemsData)) {
            return false;
        }
        ItemsData other = (ItemsData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$marker = this.getMarker();
        String other$marker = other.getMarker();
        if (this$marker == null ? other$marker != null : !this$marker.equals(other$marker)) {
            return false;
        }
        Item this$upItem = this.getUpItem();
        Item other$upItem = other.getUpItem();
        if (this$upItem == null ? other$upItem != null : !this$upItem.equals(other$upItem)) {
            return false;
        }
        List<Item> this$items = this.getItems();
        List<Item> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemsData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $marker = this.getMarker();
        result = result * 59 + ($marker == null ? 43 : $marker.hashCode());
        Item $upItem = this.getUpItem();
        result = result * 59 + ($upItem == null ? 43 : $upItem.hashCode());
        List<Item> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "ItemsData(marker=" + this.getMarker() + ", upItem=" + this.getUpItem() + ", items=" + this.getItems() + ")";
    }

    public static class ItemsDataBuilder {
        private String marker;
        private Item upItem;
        private List<Item> items;

        ItemsDataBuilder() {
        }

        public ItemsDataBuilder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public ItemsDataBuilder upItem(Item upItem) {
            this.upItem = upItem;
            return this;
        }

        public ItemsDataBuilder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public ItemsData build() {
            return new ItemsData(this.marker, this.upItem, this.items);
        }

        public String toString() {
            return "ItemsData.ItemsDataBuilder(marker=" + this.marker + ", upItem=" + this.upItem + ", items=" + this.items + ")";
        }
    }
}

