/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals;

import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.RitualResult;
import it.mralxart.etheria.magic.rituals.data.RitualDifficulty;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class Ritual {
    private String id;
    private Ingredient mainIngredient;
    private Element element;
    private RitualDifficulty ritualDifficulty;
    private List<Ingredient> ingredientList;
    private List<RuneItem> runeItems;
    private int etherAmount;
    private RitualResult ritualResult;
    private boolean active = false;
    private float crashChance;

    public Ritual(String id, Ingredient mainIngredient, Element element, RitualDifficulty ritualDifficulty, List<Ingredient> ingredientList, int etherAmount, RitualResult ritualResult, float crashChance) {
        IElementItem item;
        ItemStack itemStack;
        Item item2;
        this.id = id;
        this.mainIngredient = mainIngredient;
        this.ritualDifficulty = ritualDifficulty;
        this.ingredientList = ingredientList;
        this.etherAmount = etherAmount;
        this.ritualResult = ritualResult;
        this.crashChance = crashChance;
        if (!ritualResult.getResultItem().m_41619_() && element.equals((Object)Element.ETHER) && (item2 = (itemStack = ritualResult.getResultItem()).m_41720_()) instanceof IElementItem && (item = (IElementItem)item2).getElement() != null) {
            element = item.getElement();
        }
        this.element = element;
    }

    public String getId() {
        return this.id;
    }

    public Ingredient getMainIngredient() {
        return this.mainIngredient;
    }

    public Element getElement() {
        return this.element;
    }

    public RitualDifficulty getRitualDifficulty() {
        return this.ritualDifficulty;
    }

    public List<Ingredient> getIngredientList() {
        return this.ingredientList;
    }

    public List<RuneItem> getRuneItems() {
        return this.runeItems;
    }

    public int getEtherAmount() {
        return this.etherAmount;
    }

    public RitualResult getRitualResult() {
        return this.ritualResult;
    }

    public boolean isActive() {
        return this.active;
    }

    public float getCrashChance() {
        return this.crashChance;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMainIngredient(Ingredient mainIngredient) {
        this.mainIngredient = mainIngredient;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setRitualDifficulty(RitualDifficulty ritualDifficulty) {
        this.ritualDifficulty = ritualDifficulty;
    }

    public void setIngredientList(List<Ingredient> ingredientList) {
        this.ingredientList = ingredientList;
    }

    public void setRuneItems(List<RuneItem> runeItems) {
        this.runeItems = runeItems;
    }

    public void setEtherAmount(int etherAmount) {
        this.etherAmount = etherAmount;
    }

    public void setRitualResult(RitualResult ritualResult) {
        this.ritualResult = ritualResult;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCrashChance(float crashChance) {
        this.crashChance = crashChance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ritual)) {
            return false;
        }
        Ritual other = (Ritual)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEtherAmount() != other.getEtherAmount()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Float.compare(this.getCrashChance(), other.getCrashChance()) != 0) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Ingredient this$mainIngredient = this.getMainIngredient();
        Ingredient other$mainIngredient = other.getMainIngredient();
        if (this$mainIngredient == null ? other$mainIngredient != null : !this$mainIngredient.equals(other$mainIngredient)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)((Object)this$element)).equals((Object)other$element)) {
            return false;
        }
        RitualDifficulty this$ritualDifficulty = this.getRitualDifficulty();
        RitualDifficulty other$ritualDifficulty = other.getRitualDifficulty();
        if (this$ritualDifficulty == null ? other$ritualDifficulty != null : !((Object)((Object)this$ritualDifficulty)).equals((Object)other$ritualDifficulty)) {
            return false;
        }
        List<Ingredient> this$ingredientList = this.getIngredientList();
        List<Ingredient> other$ingredientList = other.getIngredientList();
        if (this$ingredientList == null ? other$ingredientList != null : !((Object)this$ingredientList).equals(other$ingredientList)) {
            return false;
        }
        List<RuneItem> this$runeItems = this.getRuneItems();
        List<RuneItem> other$runeItems = other.getRuneItems();
        if (this$runeItems == null ? other$runeItems != null : !((Object)this$runeItems).equals(other$runeItems)) {
            return false;
        }
        RitualResult this$ritualResult = this.getRitualResult();
        RitualResult other$ritualResult = other.getRitualResult();
        return !(this$ritualResult == null ? other$ritualResult != null : !((Object)this$ritualResult).equals(other$ritualResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ritual;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEtherAmount();
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getCrashChance());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Ingredient $mainIngredient = this.getMainIngredient();
        result = result * 59 + ($mainIngredient == null ? 43 : $mainIngredient.hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)((Object)$element)).hashCode());
        RitualDifficulty $ritualDifficulty = this.getRitualDifficulty();
        result = result * 59 + ($ritualDifficulty == null ? 43 : ((Object)((Object)$ritualDifficulty)).hashCode());
        List<Ingredient> $ingredientList = this.getIngredientList();
        result = result * 59 + ($ingredientList == null ? 43 : ((Object)$ingredientList).hashCode());
        List<RuneItem> $runeItems = this.getRuneItems();
        result = result * 59 + ($runeItems == null ? 43 : ((Object)$runeItems).hashCode());
        RitualResult $ritualResult = this.getRitualResult();
        result = result * 59 + ($ritualResult == null ? 43 : ((Object)$ritualResult).hashCode());
        return result;
    }

    public String toString() {
        return "Ritual(id=" + this.getId() + ", mainIngredient=" + this.getMainIngredient() + ", element=" + this.getElement() + ", ritualDifficulty=" + this.getRitualDifficulty() + ", ingredientList=" + this.getIngredientList() + ", runeItems=" + this.getRuneItems() + ", etherAmount=" + this.getEtherAmount() + ", ritualResult=" + this.getRitualResult() + ", active=" + this.isActive() + ", crashChance=" + this.getCrashChance() + ")";
    }
}

