/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals;

import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.Ritual;
import it.mralxart.etheria.magic.rituals.data.EtheriaRitualsData;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.rituals.data.RitualDifficulty;
import it.mralxart.etheria.magic.rituals.data.RitualsData;
import it.mralxart.etheria.magic.rituals.results.CreateItemResult;
import it.mralxart.etheria.magic.rituals.results.EnigmaResult;
import it.mralxart.etheria.magic.rituals.utils.RitualUtils;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class RitualRegistry {
    private static final Map<String, RitualData> customRituals = new HashMap<String, RitualData>();

    public static List<Ritual> getRituals() {
        HashMap<String, Ritual> rituals = new HashMap<String, Ritual>();
        for (RitualData data : RitualRegistry.createRituals().getRituals().getRitualList().values()) {
            rituals.put(data.getId(), RitualUtils.dataToRitual(data));
        }
        for (RitualData data : customRituals.values()) {
            rituals.put(data.getId(), RitualUtils.dataToRitual(data));
        }
        return new ArrayList<Ritual>(rituals.values());
    }

    @Nullable
    public static RitualData getRitual(String id) {
        for (RitualData data : RitualRegistry.createRituals().getRituals().getRitualList().values()) {
            if (!data.getId().equals(id)) continue;
            return data;
        }
        return customRituals.get(id);
    }

    public static void registerRitual(String id, RitualData ritual) {
        if (customRituals.containsKey(id)) {
            // empty if block
        }
        customRituals.put(id, ritual);
    }

    public static Map<String, RitualData> getAllRituals() {
        HashMap<String, RitualData> ritualMap = new HashMap<String, RitualData>(customRituals);
        for (RitualData data : RitualRegistry.createRituals().getRituals().getRitualList().values()) {
            ritualMap.put(data.getId(), data);
        }
        return ritualMap;
    }

    private static EtheriaRitualsData createRituals() {
        return EtheriaRitualsData.builder().rituals(RitualsData.builder().ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(15).element(Element.PYRO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50353_})).ingredient(Items.f_42593_).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.FLAME_FRAGMENT.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.PYRO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42692_})).ingredient(Items.f_42613_).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.CHARRED_CRYSTAL.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.PYRO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50137_})).ingredient(Items.f_42542_).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.EMBERITE.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.PYRO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151049_})).ingredient((Item)ItemRegistry.FLAME_FRAGMENT.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.THAWING_CRYSTAL.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(30).element(Element.PYRO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50730_})).ingredient((Item)ItemRegistry.FLAME_FRAGMENT.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.FIRE_SEAL.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(15).element(Element.CRYO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50126_})).ingredient(Items.f_42452_).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.ICE_SHARD.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.CRYO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50354_})).ingredient(Blocks.f_50228_.m_5456_()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.SNOW_STONE.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.CRYO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151049_})).ingredient((Item)ItemRegistry.ICE_SHARD.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.ICE_CRYSTAL.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(30).element(Element.CRYO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50127_})).ingredient((Item)ItemRegistry.ICE_SHARD.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.FROST_HEART.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.EASY).requiredLevel(0).requiredEther(20).element(Element.CRYO).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50354_})).ingredient(Items.f_42415_).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.FROZEN_STAR.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.ADVANCED).requiredLevel(11).requiredEther(1260).isEnigma(true).crashChance(70.0f).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_COLLECTOR.get()})).result(new EnigmaResult(new ItemStack((ItemLike)BlockRegistry.ETHER_COLLECTOR.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.ADVANCED).requiredLevel(8).requiredEther(1260).isEnigma(true).crashChance(70.0f).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_PRISM.get()})).result(new EnigmaResult(new ItemStack((ItemLike)BlockRegistry.ETHER_PRISM.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.ADVANCED).requiredLevel(6).requiredEther(800).isEnigma(true).crashChance(40.0f).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ETHER_CRYSTAL.get()})).result(new EnigmaResult(new ItemStack((ItemLike)ItemRegistry.ENIGMA_ORB.get()))).build()).ritual(RitualData.builder().ritualDifficulty(RitualDifficulty.BASIC).requiredLevel(0).requiredEther(40).mainIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ETHER_CORE.get()})).ingredient((Item)ItemRegistry.ETHER_SHARD.get()).ingredient(((Block)BlockRegistry.ETHER_BLOCK.get()).m_5456_()).ingredient((Item)ItemRegistry.ETHER_SHARD.get()).ingredient((Item)ItemRegistry.ETHER_SHARD.get()).ingredient(((Block)BlockRegistry.ETHER_BLOCK.get()).m_5456_()).ingredient((Item)ItemRegistry.ETHER_SHARD.get()).ingredient(((Block)BlockRegistry.ETHER_BLOCK.get()).m_5456_()).ingredient(((Block)BlockRegistry.ETHER_BLOCK.get()).m_5456_()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.ETHER_FRAGMENT.get()))).build()).ritual(RitualData.builder().requiredLevel(1).requiredEther(45).ritualDifficulty(RitualDifficulty.ELEMENTARY).element(Element.CRYO).crashChance(10.0f).mainIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.ELEMENTARY_SCROLL.get())})).ingredient((Item)ItemRegistry.ICE_SHARD.get()).ingredient((Item)ItemRegistry.ICE_SHARD.get()).ingredient((Item)ItemRegistry.FROST_HEART.get()).ingredient((Item)ItemRegistry.FROST_HEART.get()).ingredient((Item)ItemRegistry.SNOW_STONE.get()).rune((RuneItem)ItemRegistry.RUNE_KNOWLEDGE.get()).rune((RuneItem)ItemRegistry.RUNE_WISDOM.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.ELEMENTARY_SCROLL_CRYO.get()))).build()).ritual(RitualData.builder().requiredLevel(1).requiredEther(45).ritualDifficulty(RitualDifficulty.ELEMENTARY).element(Element.PYRO).crashChance(10.0f).mainIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.ELEMENTARY_SCROLL.get())})).ingredient((Item)ItemRegistry.CHARRED_CRYSTAL.get()).ingredient((Item)ItemRegistry.CHARRED_CRYSTAL.get()).ingredient((Item)ItemRegistry.FLAME_FRAGMENT.get()).ingredient((Item)ItemRegistry.FLAME_FRAGMENT.get()).ingredient((Item)ItemRegistry.EMBERITE.get()).rune((RuneItem)ItemRegistry.RUNE_KNOWLEDGE.get()).rune((RuneItem)ItemRegistry.RUNE_WISDOM.get()).result(new CreateItemResult(new ItemStack((ItemLike)ItemRegistry.ELEMENTARY_SCROLL_PYRO.get()))).build()).build()).build();
    }

    public static RitualData getDataRitual(String id) {
        return RitualRegistry.createRituals().getRituals().getRitualList().get(id);
    }
}

