/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals.data;

import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.RitualResult;
import it.mralxart.etheria.magic.rituals.data.RitualDifficulty;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RitualData {
    private String id;
    private int requiredLevel;
    private int requiredEther;
    private boolean isEnigma;
    private float crashChance;
    private String description;
    private Ingredient mainIngredient;
    private Map<String, Ingredient> ingredients;
    private Map<String, RuneItem> runes;
    private Element element;
    private RitualDifficulty ritualDifficulty;
    private RitualResult result;

    public static RitualDataBuilder builder(String id) {
        RitualDataBuilder builder = new RitualDataBuilder();
        builder.id(id);
        return builder;
    }

    public static RitualDataBuilder builder() {
        return new RitualDataBuilder();
    }

    private static int $default$requiredLevel() {
        return 0;
    }

    private static int $default$requiredEther() {
        return 10;
    }

    private static boolean $default$isEnigma() {
        return false;
    }

    private static float $default$crashChance() {
        return 0.0f;
    }

    private static String $default$description() {
        return "";
    }

    private static Element $default$element() {
        return Element.ETHER;
    }

    private static RitualDifficulty $default$ritualDifficulty() {
        return RitualDifficulty.BASIC;
    }

    private static RitualResult $default$result() {
        return new RitualResult();
    }

    RitualData(String id, int requiredLevel, int requiredEther, boolean isEnigma, float crashChance, String description, Ingredient mainIngredient, Map<String, Ingredient> ingredients, Map<String, RuneItem> runes, Element element, RitualDifficulty ritualDifficulty, RitualResult result) {
        this.id = id;
        this.requiredLevel = requiredLevel;
        this.requiredEther = requiredEther;
        this.isEnigma = isEnigma;
        this.crashChance = crashChance;
        this.description = description;
        this.mainIngredient = mainIngredient;
        this.ingredients = ingredients;
        this.runes = runes;
        this.element = element;
        this.ritualDifficulty = ritualDifficulty;
        this.result = result;
    }

    public String getId() {
        return this.id;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public int getRequiredEther() {
        return this.requiredEther;
    }

    public boolean isEnigma() {
        return this.isEnigma;
    }

    public float getCrashChance() {
        return this.crashChance;
    }

    public String getDescription() {
        return this.description;
    }

    public Ingredient getMainIngredient() {
        return this.mainIngredient;
    }

    public Map<String, Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Map<String, RuneItem> getRunes() {
        return this.runes;
    }

    public Element getElement() {
        return this.element;
    }

    public RitualDifficulty getRitualDifficulty() {
        return this.ritualDifficulty;
    }

    public RitualResult getResult() {
        return this.result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public void setRequiredEther(int requiredEther) {
        this.requiredEther = requiredEther;
    }

    public void setEnigma(boolean isEnigma) {
        this.isEnigma = isEnigma;
    }

    public void setCrashChance(float crashChance) {
        this.crashChance = crashChance;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMainIngredient(Ingredient mainIngredient) {
        this.mainIngredient = mainIngredient;
    }

    public void setIngredients(Map<String, Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public void setRunes(Map<String, RuneItem> runes) {
        this.runes = runes;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setRitualDifficulty(RitualDifficulty ritualDifficulty) {
        this.ritualDifficulty = ritualDifficulty;
    }

    public void setResult(RitualResult result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RitualData)) {
            return false;
        }
        RitualData other = (RitualData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (this.getRequiredEther() != other.getRequiredEther()) {
            return false;
        }
        if (this.isEnigma() != other.isEnigma()) {
            return false;
        }
        if (Float.compare(this.getCrashChance(), other.getCrashChance()) != 0) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Ingredient this$mainIngredient = this.getMainIngredient();
        Ingredient other$mainIngredient = other.getMainIngredient();
        if (this$mainIngredient == null ? other$mainIngredient != null : !this$mainIngredient.equals(other$mainIngredient)) {
            return false;
        }
        Map<String, Ingredient> this$ingredients = this.getIngredients();
        Map<String, Ingredient> other$ingredients = other.getIngredients();
        if (this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients)) {
            return false;
        }
        Map<String, RuneItem> this$runes = this.getRunes();
        Map<String, RuneItem> other$runes = other.getRunes();
        if (this$runes == null ? other$runes != null : !((Object)this$runes).equals(other$runes)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)((Object)this$element)).equals((Object)other$element)) {
            return false;
        }
        RitualDifficulty this$ritualDifficulty = this.getRitualDifficulty();
        RitualDifficulty other$ritualDifficulty = other.getRitualDifficulty();
        if (this$ritualDifficulty == null ? other$ritualDifficulty != null : !((Object)((Object)this$ritualDifficulty)).equals((Object)other$ritualDifficulty)) {
            return false;
        }
        RitualResult this$result = this.getResult();
        RitualResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RitualData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + this.getRequiredEther();
        result = result * 59 + (this.isEnigma() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getCrashChance());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Ingredient $mainIngredient = this.getMainIngredient();
        result = result * 59 + ($mainIngredient == null ? 43 : $mainIngredient.hashCode());
        Map<String, Ingredient> $ingredients = this.getIngredients();
        result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
        Map<String, RuneItem> $runes = this.getRunes();
        result = result * 59 + ($runes == null ? 43 : ((Object)$runes).hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)((Object)$element)).hashCode());
        RitualDifficulty $ritualDifficulty = this.getRitualDifficulty();
        result = result * 59 + ($ritualDifficulty == null ? 43 : ((Object)((Object)$ritualDifficulty)).hashCode());
        RitualResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    public String toString() {
        return "RitualData(id=" + this.getId() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredEther=" + this.getRequiredEther() + ", isEnigma=" + this.isEnigma() + ", crashChance=" + this.getCrashChance() + ", description=" + this.getDescription() + ", mainIngredient=" + this.getMainIngredient() + ", ingredients=" + this.getIngredients() + ", runes=" + this.getRunes() + ", element=" + this.getElement() + ", ritualDifficulty=" + this.getRitualDifficulty() + ", result=" + this.getResult() + ")";
    }

    public static class RitualDataBuilder {
        private String id;
        private boolean requiredLevel$set;
        private int requiredLevel$value;
        private boolean requiredEther$set;
        private int requiredEther$value;
        private boolean isEnigma$set;
        private boolean isEnigma$value;
        private boolean crashChance$set;
        private float crashChance$value;
        private boolean description$set;
        private String description$value;
        private Ingredient mainIngredient;
        private boolean element$set;
        private Element element$value;
        private boolean ritualDifficulty$set;
        private RitualDifficulty ritualDifficulty$value;
        private boolean result$set;
        private RitualResult result$value;
        private Map<String, Ingredient> ingredients = new HashMap<String, Ingredient>();
        private Map<String, RuneItem> runes = new HashMap<String, RuneItem>();

        public RitualDataBuilder ingredient(ItemStack data) {
            this.ingredients.put(data.m_41720_().m_5524_(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{data}));
            return this;
        }

        public RitualDataBuilder ingredient(Item data) {
            String id = data.m_5524_();
            String newid = id + "_" + (this.ingredients.size() + 1);
            this.ingredients.put(newid, Ingredient.m_43929_((ItemLike[])new ItemLike[]{data}));
            return this;
        }

        public RitualDataBuilder rune(RuneItem data) {
            String id = data.m_5524_();
            String newid = id + "_" + (this.runes.size() + 1);
            this.runes.put(newid, data);
            return this;
        }

        private RitualDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        RitualDataBuilder() {
        }

        public RitualDataBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel$value = requiredLevel;
            this.requiredLevel$set = true;
            return this;
        }

        public RitualDataBuilder requiredEther(int requiredEther) {
            this.requiredEther$value = requiredEther;
            this.requiredEther$set = true;
            return this;
        }

        public RitualDataBuilder isEnigma(boolean isEnigma) {
            this.isEnigma$value = isEnigma;
            this.isEnigma$set = true;
            return this;
        }

        public RitualDataBuilder crashChance(float crashChance) {
            this.crashChance$value = crashChance;
            this.crashChance$set = true;
            return this;
        }

        public RitualDataBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public RitualDataBuilder mainIngredient(Ingredient mainIngredient) {
            this.mainIngredient = mainIngredient;
            return this;
        }

        public RitualDataBuilder ingredients(Map<String, Ingredient> ingredients) {
            this.ingredients = ingredients;
            return this;
        }

        public RitualDataBuilder runes(Map<String, RuneItem> runes) {
            this.runes = runes;
            return this;
        }

        public RitualDataBuilder element(Element element) {
            this.element$value = element;
            this.element$set = true;
            return this;
        }

        public RitualDataBuilder ritualDifficulty(RitualDifficulty ritualDifficulty) {
            this.ritualDifficulty$value = ritualDifficulty;
            this.ritualDifficulty$set = true;
            return this;
        }

        public RitualDataBuilder result(RitualResult result) {
            this.result$value = result;
            this.result$set = true;
            return this;
        }

        public RitualData build() {
            int requiredLevel$value = this.requiredLevel$value;
            if (!this.requiredLevel$set) {
                requiredLevel$value = RitualData.$default$requiredLevel();
            }
            int requiredEther$value = this.requiredEther$value;
            if (!this.requiredEther$set) {
                requiredEther$value = RitualData.$default$requiredEther();
            }
            boolean isEnigma$value = this.isEnigma$value;
            if (!this.isEnigma$set) {
                isEnigma$value = RitualData.$default$isEnigma();
            }
            float crashChance$value = this.crashChance$value;
            if (!this.crashChance$set) {
                crashChance$value = RitualData.$default$crashChance();
            }
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = RitualData.$default$description();
            }
            Element element$value = this.element$value;
            if (!this.element$set) {
                element$value = RitualData.$default$element();
            }
            RitualDifficulty ritualDifficulty$value = this.ritualDifficulty$value;
            if (!this.ritualDifficulty$set) {
                ritualDifficulty$value = RitualData.$default$ritualDifficulty();
            }
            RitualResult result$value = this.result$value;
            if (!this.result$set) {
                result$value = RitualData.$default$result();
            }
            return new RitualData(this.id, requiredLevel$value, requiredEther$value, isEnigma$value, crashChance$value, description$value, this.mainIngredient, this.ingredients, this.runes, element$value, ritualDifficulty$value, result$value);
        }

        public String toString() {
            return "RitualData.RitualDataBuilder(id=" + this.id + ", requiredLevel$value=" + this.requiredLevel$value + ", requiredEther$value=" + this.requiredEther$value + ", isEnigma$value=" + this.isEnigma$value + ", crashChance$value=" + this.crashChance$value + ", description$value=" + this.description$value + ", mainIngredient=" + this.mainIngredient + ", ingredients=" + this.ingredients + ", runes=" + this.runes + ", element$value=" + this.element$value + ", ritualDifficulty$value=" + this.ritualDifficulty$value + ", result$value=" + this.result$value + ")";
        }
    }
}

