/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals.events;

import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.rituals.RitualEvent;
import it.mralxart.etheria.magic.rituals.data.RitualStage;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SplashParticleEvent
extends RitualEvent {
    public SplashParticleEvent(List<RitualStage> activationStages, RitualStage endStage, int priority) {
        super(activationStages, endStage, priority);
    }

    @Override
    public boolean execute(RitualManager context) {
        float splashPercentage = 45.0f + context.getArtifacts().getStatValue(StatType.ETHER_SPLASH);
        if (this.random.nextFloat() * 100.0f <= splashPercentage) {
            Element element = this.random.nextBoolean() ? Element.ETHER : Element.PYRO;
            this.createSplashParticle((Level)context.getLevel(), element, context.getAltarPos());
            if (element == Element.PYRO) {
                this.applyDamageToEntities((Level)context.getLevel(), context.getAltarPos(), 6);
            }
        }
        return false;
    }

    private void createSplashParticle(Level level, Element element, BlockPos altarPos) {
        GlowingParticleData particleData = new GlowingParticleData(ElementsUtils.getColorByElement(element), 0.3f, 60 + level.f_46441_.m_216339_(10, 14), 0.002f);
        ParticleUtils.createParticle(level, particleData, (double)altarPos.m_123341_() + 0.5, (double)altarPos.m_123342_() + 0.85, (double)altarPos.m_123343_() + 0.5, 100, 0.2, 0.2, 0.2, 0.3f);
    }

    private void applyDamageToEntities(Level level, BlockPos center, int radius) {
        AABB area = new AABB(center.m_7918_(-radius, -radius, -radius), center.m_7918_(radius, radius, radius));
        List entitiesInRadius = level.m_45976_(Entity.class, area);
        for (Entity entity : entitiesInRadius) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            int damage = this.random.nextInt(4, 12);
            livingEntity.m_6469_(level.m_269111_().m_269425_(), (float)damage);
        }
    }
}

