/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.BarrageSpearEntity;
import it.mralxart.etheria.magic.spells.entities.BlazinRingEntity;
import it.mralxart.etheria.magic.spells.entities.ElementRain;
import it.mralxart.etheria.magic.spells.entities.ElementalStorm;
import it.mralxart.etheria.magic.spells.entities.Explosion;
import it.mralxart.etheria.magic.spells.entities.FireWhirl;
import it.mralxart.etheria.magic.spells.entities.FrostShackles;
import it.mralxart.etheria.magic.spells.entities.FrozenOrbitEntity;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.magic.spells.entities.IcySwordEntity;
import it.mralxart.etheria.magic.spells.entities.PhoenixRise;
import it.mralxart.etheria.magic.spells.entities.SpellEntity;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ItemUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SpellsCast {
    public static void cast(ServerPlayer player, String spell) {
        InteractionHand handWithStick = ItemUtils.getHandWithItem(player, (Item)ItemRegistry.MAGIC_STICK.get());
        if (handWithStick == null) {
            return;
        }
        int reqEther = SpellsUtils.getRequiredEther(spell);
        ItemStack etherItem = EtherUtils.findEtherVessel((Player)player, reqEther);
        int etherCount = EtherUtils.getEther(etherItem);
        if (etherCount <= 0 || etherCount < reqEther) {
            player.m_5661_((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.rituals.warn.ether").getString() + ": " + reqEther + ".")), true);
            return;
        }
        EtherUtils.setEther(etherItem, etherCount - reqEther);
        Element element = SpellsUtils.getElement(spell);
        SkillsUtils.addXp((Player)player, Branches.MAGIC, 1);
        switch (element) {
            case CRYO: {
                SpellsCast.castCryo(player, spell);
                break;
            }
            case PYRO: {
                SpellsCast.castPyro(player, spell);
            }
        }
    }

    private static void castCryo(ServerPlayer player, String spell) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        float radius = SpellsUtils.getSpellValue((Player)player, spell, "radius");
        int duration = Math.round(SpellsUtils.getSpellValue((Player)player, spell, "duration") * 20.0f) + 1;
        int damage = (int)SpellsUtils.getSpellValue((Player)player, spell, "damage");
        int cooldown = (int)SpellsUtils.getSpellValue((Player)player, spell, "cooldown") * 20;
        if (spell.equals("icy_spear")) {
            Vec3 lookVector = player.m_20154_();
            IcySpearEntity entity2 = new IcySpearEntity(level, damage + 2, ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)).getRGB());
            entity2.m_5602_((Entity)player);
            entity2.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity2.m_20334_(lookVector.m_82490_((double)2.0).f_82479_, lookVector.m_82490_((double)2.0).f_82480_, lookVector.m_82490_((double)2.0).f_82481_);
            level.m_7967_((Entity)entity2);
            SpellsUtils.addSpellCooldown((Player)player, spell, 160);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144201_, SoundSource.MASTER, 0.5f, 0.5f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144244_, SoundSource.MASTER, 0.5f, 0.5f);
        } else if (spell.equals("icy_storm")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            ElementalStorm entity3 = new ElementalStorm(level, duration, damage, ElementsUtils.getElement((Player)player));
            entity3.setDuration(duration);
            entity3.m_5602_((Entity)player);
            entity3.setRadius(3.0f);
            entity3.setElement(Element.CRYO);
            entity3.m_6034_(target.f_82479_, target.f_82480_ + 0.5, target.f_82481_);
            level.m_7967_((Entity)entity3);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 2.4));
        } else if (spell.equals("frost_shackles")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyeVec, (Vec3)eyeVec.m_82549_(view.m_82490_((double)maxDistance)), (AABB)new AABB(eyeVec, eyeVec.m_82549_(view.m_82490_((double)maxDistance))), entity -> entity instanceof LivingEntity && !entity.m_5833_(), (double)maxDistance);
            if (entityHitResult != null) {
                AABB targetBoundingBox = new AABB(entityHitResult.m_82450_().f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
                for (LivingEntity targetEntity : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox)) {
                    if (targetEntity.m_20148_().equals(player.m_20148_())) continue;
                    targetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 254, true, false));
                    Vec3 position = targetEntity.m_20318_(0.0f);
                    FrostShackles frostShackles = new FrostShackles((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FROST_SHACKLES.get()), player.m_9236_());
                    frostShackles.setLifeTime(duration);
                    frostShackles.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                    frostShackles.m_5602_((Entity)targetEntity);
                    frostShackles.setDamage(damage);
                    frostShackles.setEntity(targetEntity.m_19879_());
                    player.m_9236_().m_7967_((Entity)frostShackles);
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)), 0.5f, 40, 0.5f), position.m_7096_(), position.m_7098_(), position.m_7094_(), 40, 0.2, 0.2, 0.2, 0.2f);
                    player.m_9236_().m_5594_(null, targetEntity.m_20183_(), SoundEvents.f_12474_, SoundSource.MASTER, 2.0f, 1.0f + random.m_188501_() * 0.25f);
                }
            } else {
                AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
                for (LivingEntity entity4 : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox)) {
                    if (entity4.m_20148_().equals(player.m_20148_())) continue;
                    entity4.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 254, true, false));
                    Vec3 position = entity4.m_20318_(0.0f);
                    FrostShackles frostShackles = new FrostShackles((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FROST_SHACKLES.get()), player.m_9236_());
                    frostShackles.setLifeTime(duration);
                    frostShackles.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                    frostShackles.m_5602_((Entity)player);
                    frostShackles.setDamage(damage);
                    frostShackles.setEntity(entity4.m_19879_());
                    player.m_9236_().m_7967_((Entity)frostShackles);
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)), 0.5f, 40, 0.5f), position.m_7096_(), position.m_7098_(), position.m_7094_(), 40, 0.2, 0.2, 0.2, 0.2f);
                    player.m_9236_().m_5594_(null, entity4.m_20183_(), SoundEvents.f_12474_, SoundSource.MASTER, 2.0f, 1.0f + random.m_188501_() * 0.25f);
                }
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.2));
        } else if (spell.equals("frost_explosion")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.35f, 40, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 60, 0.05f, 0.05f, 0.05f, 0.15f);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 60, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 40, 0.05f, 0.05f, 0.05f, 0.1f);
            Explosion explosion = new Explosion((EntityType<Explosion>)((EntityType)EntityRegistry.EXPLOSION.get()), player.m_9236_(), ElementsUtils.getStringElement((Player)player));
            level.m_254849_(null, target.f_82479_, target.f_82480_, target.f_82481_, SpellsUtils.getUpgradeValue((Player)player, spell, "strength"), Level.ExplosionInteraction.NONE);
            explosion.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            explosion.setOwnerUUID(player.m_20148_());
            explosion.setElement("CRYO");
            player.m_9236_().m_7967_((Entity)explosion);
            for (LivingEntity entity5 : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox.m_82400_(3.0))) {
                if (entity5.m_20149_().equals(player.m_20149_())) continue;
                entity5.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 254, true, false));
                entity5.m_146917_(duration);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12473_, SoundSource.MASTER, 0.5f, 0.5f);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("frozen_orbit")) {
            FrozenOrbitEntity entity6 = new FrozenOrbitEntity(level, damage, duration);
            entity6.setDuration(duration);
            entity6.m_5602_((Entity)player);
            entity6.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            level.m_7967_((Entity)entity6);
            entity6 = new FrozenOrbitEntity(level, damage, duration);
            entity6.setDuration(duration);
            entity6.m_5602_((Entity)player);
            entity6.m_6034_(player.m_20185_(), player.m_20186_() + 0.6, player.m_20189_());
            entity6.setNegative(true);
            level.m_7967_((Entity)entity6);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 2.4));
        } else if (spell.equals("icy_barrage")) {
            for (int i = 0; i < 2; ++i) {
                BarrageSpearEntity entity7 = new BarrageSpearEntity(level, damage);
                entity7.m_5602_((Entity)player);
                entity7.setDuration(200);
                entity7.m_6034_(player.m_20185_() + random.m_188500_(), player.m_20186_() + 1.0, player.m_20189_() + random.m_188500_());
                double offsetX = (random.m_188500_() - 0.5) * 0.5;
                double offsetZ = (random.m_188500_() - 0.5) * 0.5;
                double offsetY = 0.8 + (random.m_188500_() - 0.5) * 0.2;
                entity7.m_20334_(offsetX, offsetY, offsetZ);
                if (entity7.isAddedToWorld()) continue;
                level.m_7967_((Entity)entity7);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("icy_sword")) {
            IcySwordEntity entity8 = new IcySwordEntity(level, damage, radius);
            entity8.m_5602_((Entity)player);
            entity8.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            level.m_7967_((Entity)entity8);
            SpellsUtils.addSpellCooldown((Player)player, spell, 400);
        }
    }

    private static void castPyro(ServerPlayer player, String spell) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        float radius = SpellsUtils.getSpellValue((Player)player, spell, "radius");
        int duration = Math.round(SpellsUtils.getSpellValue((Player)player, spell, "duration") * 20.0f) + 1;
        int damage = (int)SpellsUtils.getSpellValue((Player)player, spell, "damage");
        int cooldown = (int)SpellsUtils.getSpellValue((Player)player, spell, "cooldown") * 20;
        if (spell.equals("fire_rain")) {
            ElementRain rain = new ElementRain((EntityType<? extends Projectile>)((EntityType)EntityRegistry.ELEMENT_RAIN.get()), player.m_9236_());
            Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_() + 18.0, player.m_20189_());
            rain.m_146884_(pos);
            rain.setRadius(radius);
            rain.setLifetime(duration);
            rain.setFrequency((int)Math.round(4.0 - (double)SpellsUtils.getSpellLevel((Player)player, "fire_rain") * 0.7));
            rain.setDamage(damage);
            rain.m_5602_((Entity)player);
            rain.setElement(Element.PYRO.name().toLowerCase());
            level.m_7967_((Entity)rain);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("fireball")) {
            Vec3 lookVector = player.m_20154_();
            SpellEntity entity = new SpellEntity(level, damage, Element.PYRO.name());
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_20334_(lookVector.f_82479_, lookVector.f_82480_, lookVector.f_82481_);
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, 120);
        } else if (spell.equals("phoenix_rise")) {
            PhoenixRise entity = new PhoenixRise(level, damage, radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_5602_((Entity)player);
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("flame_explosion")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.35f, 40, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 60, 0.05f, 0.05f, 0.05f, 0.15f);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.2f, 60, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 40, 0.05f, 0.05f, 0.05f, 0.1f);
            Explosion explosion = new Explosion((EntityType<Explosion>)((EntityType)EntityRegistry.EXPLOSION.get()), player.m_9236_(), ElementsUtils.getStringElement((Player)player));
            level.m_254849_(null, target.f_82479_, target.f_82480_, target.f_82481_, SpellsUtils.getUpgradeValue((Player)player, spell, "strength") / 4.0f, Level.ExplosionInteraction.NONE);
            explosion.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            explosion.setOwnerUUID(player.m_20148_());
            explosion.setElement(Element.PYRO.name());
            player.m_9236_().m_7967_((Entity)explosion);
            for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox.m_82400_(3.0))) {
                if (entity.m_20149_().equals(player.m_20149_())) continue;
                entity.m_7311_(140);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("fire_whirl")) {
            FireWhirl entity = new FireWhirl(level, damage, radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.5));
        } else if (spell.equals("blazing_ring")) {
            BlazinRingEntity entity = new BlazinRingEntity(level, (int)SpellsUtils.getSpellValue((Player)player, spell, "heal"), radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 0.2, player.m_20189_());
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.5));
        }
    }
}

