/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.data;

import it.mralxart.etheria.magic.spells.data.SpellModifier;
import java.util.HashMap;
import java.util.Map;

public class SpellData {
    private final String id;
    private Map<String, SpellModifier> modifiers = new HashMap<String, SpellModifier>();
    private int maxLevel;
    private String element;
    private String rare;
    private int requiredLevel;
    private float lootChance;
    private int requiredUp;
    private int requiredEther;

    public static SpellDataBuilder builder(String id) {
        SpellDataBuilder builder = new SpellDataBuilder();
        builder.id(id);
        return builder;
    }

    private static int $default$maxLevel() {
        return 10;
    }

    private static String $default$element() {
        return "terra";
    }

    private static String $default$rare() {
        return "epic";
    }

    private static int $default$requiredLevel() {
        return 0;
    }

    private static float $default$lootChance() {
        return 0.0f;
    }

    private static int $default$requiredUp() {
        return 1;
    }

    private static int $default$requiredEther() {
        return 1;
    }

    SpellData(String id, Map<String, SpellModifier> modifiers, int maxLevel, String element, String rare, int requiredLevel, float lootChance, int requiredUp, int requiredEther) {
        this.id = id;
        this.modifiers = modifiers;
        this.maxLevel = maxLevel;
        this.element = element;
        this.rare = rare;
        this.requiredLevel = requiredLevel;
        this.lootChance = lootChance;
        this.requiredUp = requiredUp;
        this.requiredEther = requiredEther;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, SpellModifier> getModifiers() {
        return this.modifiers;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getElement() {
        return this.element;
    }

    public String getRare() {
        return this.rare;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public float getLootChance() {
        return this.lootChance;
    }

    public int getRequiredUp() {
        return this.requiredUp;
    }

    public int getRequiredEther() {
        return this.requiredEther;
    }

    public void setModifiers(Map<String, SpellModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setRare(String rare) {
        this.rare = rare;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public void setLootChance(float lootChance) {
        this.lootChance = lootChance;
    }

    public void setRequiredUp(int requiredUp) {
        this.requiredUp = requiredUp;
    }

    public void setRequiredEther(int requiredEther) {
        this.requiredEther = requiredEther;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellData)) {
            return false;
        }
        SpellData other = (SpellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (Float.compare(this.getLootChance(), other.getLootChance()) != 0) {
            return false;
        }
        if (this.getRequiredUp() != other.getRequiredUp()) {
            return false;
        }
        if (this.getRequiredEther() != other.getRequiredEther()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, SpellModifier> this$modifiers = this.getModifiers();
        Map<String, SpellModifier> other$modifiers = other.getModifiers();
        if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
            return false;
        }
        String this$element = this.getElement();
        String other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        String this$rare = this.getRare();
        String other$rare = other.getRare();
        return !(this$rare == null ? other$rare != null : !this$rare.equals(other$rare));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpellData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + Float.floatToIntBits(this.getLootChance());
        result = result * 59 + this.getRequiredUp();
        result = result * 59 + this.getRequiredEther();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, SpellModifier> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        String $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        String $rare = this.getRare();
        result = result * 59 + ($rare == null ? 43 : $rare.hashCode());
        return result;
    }

    public String toString() {
        return "SpellData(id=" + this.getId() + ", modifiers=" + this.getModifiers() + ", maxLevel=" + this.getMaxLevel() + ", element=" + this.getElement() + ", rare=" + this.getRare() + ", requiredLevel=" + this.getRequiredLevel() + ", lootChance=" + this.getLootChance() + ", requiredUp=" + this.getRequiredUp() + ", requiredEther=" + this.getRequiredEther() + ")";
    }

    public static class SpellDataBuilder {
        private String id;
        private boolean maxLevel$set;
        private int maxLevel$value;
        private boolean element$set;
        private String element$value;
        private boolean rare$set;
        private String rare$value;
        private boolean requiredLevel$set;
        private int requiredLevel$value;
        private boolean lootChance$set;
        private float lootChance$value;
        private boolean requiredUp$set;
        private int requiredUp$value;
        private boolean requiredEther$set;
        private int requiredEther$value;
        private Map<String, SpellModifier> modifiers = new HashMap<String, SpellModifier>();

        public SpellDataBuilder modifier(SpellModifier modifier) {
            this.modifiers.put(modifier.getId(), modifier);
            return this;
        }

        SpellDataBuilder() {
        }

        public SpellDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SpellDataBuilder modifiers(Map<String, SpellModifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public SpellDataBuilder maxLevel(int maxLevel) {
            this.maxLevel$value = maxLevel;
            this.maxLevel$set = true;
            return this;
        }

        public SpellDataBuilder element(String element) {
            this.element$value = element;
            this.element$set = true;
            return this;
        }

        public SpellDataBuilder rare(String rare) {
            this.rare$value = rare;
            this.rare$set = true;
            return this;
        }

        public SpellDataBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel$value = requiredLevel;
            this.requiredLevel$set = true;
            return this;
        }

        public SpellDataBuilder lootChance(float lootChance) {
            this.lootChance$value = lootChance;
            this.lootChance$set = true;
            return this;
        }

        public SpellDataBuilder requiredUp(int requiredUp) {
            this.requiredUp$value = requiredUp;
            this.requiredUp$set = true;
            return this;
        }

        public SpellDataBuilder requiredEther(int requiredEther) {
            this.requiredEther$value = requiredEther;
            this.requiredEther$set = true;
            return this;
        }

        public SpellData build() {
            int maxLevel$value = this.maxLevel$value;
            if (!this.maxLevel$set) {
                maxLevel$value = SpellData.$default$maxLevel();
            }
            String element$value = this.element$value;
            if (!this.element$set) {
                element$value = SpellData.$default$element();
            }
            String rare$value = this.rare$value;
            if (!this.rare$set) {
                rare$value = SpellData.$default$rare();
            }
            int requiredLevel$value = this.requiredLevel$value;
            if (!this.requiredLevel$set) {
                requiredLevel$value = SpellData.$default$requiredLevel();
            }
            float lootChance$value = this.lootChance$value;
            if (!this.lootChance$set) {
                lootChance$value = SpellData.$default$lootChance();
            }
            int requiredUp$value = this.requiredUp$value;
            if (!this.requiredUp$set) {
                requiredUp$value = SpellData.$default$requiredUp();
            }
            int requiredEther$value = this.requiredEther$value;
            if (!this.requiredEther$set) {
                requiredEther$value = SpellData.$default$requiredEther();
            }
            return new SpellData(this.id, this.modifiers, maxLevel$value, element$value, rare$value, requiredLevel$value, lootChance$value, requiredUp$value, requiredEther$value);
        }

        public String toString() {
            return "SpellData.SpellDataBuilder(id=" + this.id + ", modifiers=" + this.modifiers + ", maxLevel$value=" + this.maxLevel$value + ", element$value=" + this.element$value + ", rare$value=" + this.rare$value + ", requiredLevel$value=" + this.requiredLevel$value + ", lootChance$value=" + this.lootChance$value + ", requiredUp$value=" + this.requiredUp$value + ", requiredEther$value=" + this.requiredEther$value + ")";
        }
    }
}

