/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrageSpearEntity
extends ThrowableProjectile {
    private float damage;
    private int duration;
    private int idTarget = -1;

    public BarrageSpearEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BarrageSpearEntity(Level level, float damage) {
        super((EntityType)EntityRegistry.BARRAGE_SPEAR.get(), level);
        this.damage = damage;
        this.idTarget = -1;
        this.m_20242_(false);
    }

    public void m_8119_() {
        Entity target;
        Entity potentialTarget;
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.idTarget == -1 && (potentialTarget = this.findRandomEntity(this.m_9236_(), this.m_20182_(), 16.0)) != null) {
            this.idTarget = potentialTarget.m_19879_();
        }
        if ((target = this.m_9236_().m_6815_(this.idTarget)) != null && !target.m_213877_()) {
            Vec3 targetPos;
            this.duration = 120;
            Vec3 currentPos = this.m_20182_();
            if (currentPos.m_82554_(targetPos = target.m_146892_()) <= 1.0) {
                target.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.damage);
                this.m_146870_();
                return;
            }
            Vec3 directionToTarget = targetPos.m_82546_(currentPos).m_82541_();
            Vec3 currentMotion = this.m_20184_();
            double speedVariation = 0.1 + (double)(this.m_19879_() % 10) * 0.1;
            double turnSpeedVariation = 0.1 + (double)(this.m_19879_() % 10) * 0.02;
            Vec3 newMotion = currentMotion.m_165921_(directionToTarget.m_82490_(speedVariation), turnSpeedVariation);
            this.m_20256_(newMotion);
        } else {
            this.duration = 50;
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.3f, 40, 0.9f), this.f_19854_, this.f_19855_, this.f_19856_, 3, 0.025, 0.025, 0.025, 0.01);
    }

    @Nullable
    private Entity findRandomEntity(Level level, Vec3 center, double radius) {
        List entities = level.m_45933_(null, new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius));
        entities.removeIf(entity -> entity == this || this.m_19749_() == null || entity.m_20148_().equals(this.m_19749_().m_20148_()) || entity instanceof BarrageSpearEntity || !entity.m_6084_());
        if (!entities.isEmpty()) {
            return (Entity)entities.get(new Random().nextInt(entities.size()));
        }
        return null;
    }

    public void m_6043_() {
        if (this.f_19797_ > this.duration) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!state.m_280555_()) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult result) {
        block11: {
            block10: {
                if (this.m_9236_().m_5776_() || !((var3_2 = result.m_82443_()) instanceof LivingEntity)) break block10;
                entity = (LivingEntity)var3_2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block11;
            }
            return;
        }
        mayContinue = false;
        var6_5 = this.m_19749_();
        if (!(var6_5 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var6_5;
        var6_5 = result.m_82443_();
        if (var6_5 instanceof Player) {
            player1 = (Player)var6_5;
            if (entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), this.damage)) {
                mayContinue = true;
            }
        } else if (entity.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.damage)) {
            mayContinue = true;
        }
        if (mayContinue) {
            var5_7 = this.m_19749_();
            if (var5_7 instanceof Player) {
                player = (Player)var5_7;
                SkillsUtils.addXp(player, Branches.MAGIC, 2);
            }
            ElementHandler.addElement(entity, Element.CRYO, this.getDamage(), 200, true);
        }
        this.m_146870_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.duration = compound.m_128451_("duration");
        this.idTarget = compound.m_128451_("idTarget");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("duration", this.duration);
        compound.m_128405_("idTarget", this.idTarget);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getIdTarget() {
        return this.idTarget;
    }

    public void setIdTarget(int idTarget) {
        this.idTarget = idTarget;
    }

    public static class Render
    extends EntityRenderer<BarrageSpearEntity> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(BarrageSpearEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/icy_spear"));
            matrixStackIn.m_85837_(0.0, -0.2, 0.0);
            double motionX = entityIn.m_20184_().m_7096_();
            double motionY = entityIn.m_20184_().m_7098_();
            double motionZ = entityIn.m_20184_().m_7094_();
            double horizontalMotion = Math.sqrt(motionX * motionX + motionZ * motionZ);
            double angleXZ = Math.atan2(motionX, motionZ);
            double angleY = Math.atan2(motionY, horizontalMotion);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(angleXZ) + 180.0f));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_((float)Math.toDegrees(angleY)));
            model.renderModel(matrixStackIn, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entityIn))), 0xF000F0, OverlayTexture.f_118083_);
        }

        public ResourceLocation getTextureLocation(@NotNull BarrageSpearEntity p_114482_) {
            return new ResourceLocation("etheria", "textures/entity/isy_spear.png");
        }
    }
}

