/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.ElementalRainFall;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.MthUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ElementRain
extends Projectile {
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(ElementRain.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(ElementRain.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ElementRain.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PERIOD = SynchedEntityData.m_135353_(ElementRain.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(ElementRain.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int color;
    private double currentRadius = 1.0;
    private final LinkedList<DelayedRunnable> taskQueue = new LinkedList();

    public ElementRain(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.color = ElementsUtils.getRandomColorByElement(Element.ofString(this.getElement())).getRGB();
        if (!this.m_9236_().m_5776_() && !this.taskQueue.isEmpty() && this.taskQueue.getFirst().startedAt + this.taskQueue.getFirst().delay <= this.f_19797_) {
            this.taskQueue.pop().runnable.run();
        }
        ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.m_20182_().m_82520_(0.0, -17.075, 0.0), this.f_19797_, this.getRadius(), new Color(this.color));
        float radius = this.getRadius();
        if (this.f_19797_ > this.getLifetime()) {
            this.m_146870_();
        }
        int i = 0;
        while ((double)i < this.currentRadius) {
            Vec3 direction = new Vec3(1.0, 0.0, 0.0).m_82524_((float)Math.toRadians(this.f_19796_.m_188501_() * 360.0f)).m_82490_((double)MthUtils.randomFloat(this.f_19796_));
            double xOffset = (double)MthUtils.randomFloat(this.f_19796_) * this.currentRadius;
            double zOffset = (double)MthUtils.randomFloat(this.f_19796_) * Math.sqrt(this.currentRadius * this.currentRadius - xOffset * xOffset);
            Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(this.color, (float)(1.0 + this.currentRadius / 2.0), 60, 0.025f, 1.0f).setOptimized(false), this.m_20185_() + xOffset, this.m_20186_() + (double)MthUtils.randomFloat(this.f_19796_) * this.currentRadius / 10.0, this.m_20189_() + zOffset, direction.f_82479_ * 0.46, direction.f_82480_ * 0.1, direction.f_82481_ * 0.46));
            ++i;
        }
        if (this.currentRadius < (double)radius * 1.2) {
            this.currentRadius += ((double)radius * 1.2 - 1.0) / 164.0;
        }
        if (this.f_19797_ > 60 && this.f_19797_ % this.getFrequency() == 0) {
            this.spawnRainEffects();
        }
    }

    private void spawnRainEffects() {
        AABB effectArea = this.m_20191_().m_82400_((double)this.getRadius()).m_82386_(0.0, -18.0, 0.0);
        List targets = this.m_9236_().m_6443_(LivingEntity.class, effectArea, entity -> !entity.equals((Object)this.m_19749_()));
        ElementalRainFall rainFall = new ElementalRainFall((EntityType<? extends ElementalRainFall>)((EntityType)EntityRegistry.ELEMENT_RAIN_FALL.get()), this.m_9236_());
        rainFall.setElement(this.getElement());
        Vec3 spawnPosition = this.m_20318_(1.0f).m_82520_((double)(MthUtils.randomFloat(this.f_19796_) * this.getRadius()), 1.0, (double)(MthUtils.randomFloat(this.f_19796_) * this.getRadius()));
        if (!targets.isEmpty()) {
            for (LivingEntity target : targets) {
                if (this.f_19797_ % 30 != 0) continue;
                target.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            }
            LivingEntity target = (LivingEntity)targets.get(this.f_19796_.m_188503_(targets.size()));
            if (this.f_19796_.m_188501_() < 0.3f) {
                spawnPosition = target.m_20318_(1.0f).m_82520_(0.0, this.m_20186_() - target.m_20186_() - 1.0, 0.0);
            }
        }
        rainFall.m_146884_(spawnPosition);
        rainFall.setColor(ElementsUtils.getColorByElement(Element.PYRO).getRGB());
        rainFall.m_20334_(0.0, -2.0, 0.0);
        rainFall.m_5602_(this.m_19749_());
        rainFall.setDamage(this.getDamage());
        this.m_9236_().m_7967_((Entity)rainFall);
        ParticleUtils.createAABB(this.m_9236_(), new GlowingParticleData(new Color(this.color), 0.2f, 15, 0.025f), rainFall.m_20191_(), 15, 0.1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(PERIOD, (Object)5);
        this.f_19804_.m_135372_(LIFETIME, (Object)100);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
        this.f_19804_.m_135372_(ELEMENT, (Object)"CRYO");
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setRadius(tag.m_128457_("radius"));
        this.setDamage(tag.m_128457_("damage"));
        this.setFrequency(tag.m_128451_("period"));
        this.setLifetime(tag.m_128451_("lifetime"));
        this.setElement(tag.m_128461_("element"));
        this.color = tag.m_128451_("color");
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("radius", this.getRadius());
        tag.m_128350_("damage", this.getDamage());
        tag.m_128405_("period", this.getFrequency());
        tag.m_128405_("lifetime", this.getLifetime());
        tag.m_128359_("element", this.getElement());
        tag.m_128405_("color", this.color);
    }

    public void setElement(String value) {
        this.m_20088_().m_135381_(ELEMENT, (Object)value);
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    public void setLifetime(int value) {
        this.m_20088_().m_135381_(LIFETIME, (Object)value);
    }

    public void setRadius(float value) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(value));
    }

    public void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public void setFrequency(int value) {
        this.m_20088_().m_135381_(PERIOD, (Object)value);
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public int getLifetime() {
        return (Integer)this.m_20088_().m_135370_(LIFETIME);
    }

    public int getFrequency() {
        return (Integer)this.m_20088_().m_135370_(PERIOD);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    private record DelayedRunnable(Runnable runnable, int startedAt, int delay) {
    }
}

