/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ElementalRainFall
extends ThrowableProjectile {
    private Vec3 prevPos;
    private int color;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ElementalRainFall.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(ElementalRainFall.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public void setDamage(float damage) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public ElementalRainFall(EntityType<? extends ElementalRainFall> type, Level world) {
        super(type, world);
    }

    public void m_8119_() {
        super.m_8119_();
        double distance = this.m_20182_().m_82546_(this.prevPos != null ? this.prevPos : this.m_20182_()).m_82553_();
        if (!this.m_9236_().f_46443_) {
            ParticleUtils.drawParticleLine(new GlowingParticleData(new Color(this.color), 0.3f, 40, 0.025f), this.m_9236_(), this.prevPos != null ? this.prevPos : this.m_20182_(), this.m_20182_(), (int)Math.round(distance * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0) + 10, 0.05f, 0.2f);
        }
        this.prevPos = this.m_20182_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (!entity2.equals((Object)this.m_19749_())) {
                livingEntity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage());
                livingEntity.f_19802_ = 0;
                ElementHandler.addElement(livingEntity, Element.ofString(this.getElement()), this.getDamage(), 50, true);
            }
        }
        if ((entity = this.m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            SkillsUtils.addXp(player, Branches.MAGIC, 1);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockHitResult hit = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_(0.0, -5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitLocation = hit.m_82450_();
            ParticleUtils.drawParticleLine(new GlowingParticleData(new Color(this.color), 0.1f, 80, 0.9f), this.m_9236_(), this.m_20182_(), hitLocation, (int)Math.round(Math.sqrt(this.m_20182_().m_82557_(hitLocation)) * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.0f);
            ParticleUtils.createAABB(this.m_9236_(), new GlowingParticleData(new Color(this.color), 0.2f, 20, 0.65f), new AABB(hitLocation, hitLocation), 15, 0.1);
        }
        this.m_146870_();
    }

    public void m_6043_() {
        if (this.f_19797_ > 240) {
            this.m_146870_();
        }
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(ELEMENT, (Object)"CRYO");
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128457_("damage"));
        this.setElement(compound.m_128461_("element"));
        this.color = compound.m_128451_("color");
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damage", this.getDamage());
        compound.m_128359_("element", this.getElement());
        compound.m_128405_("color", this.color);
    }

    public void setElement(String value) {
        this.m_20088_().m_135381_(ELEMENT, (Object)value);
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

