/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ElementalStorm
extends Projectile {
    private float damage;
    private float duration;
    private float radius;
    private Element element = Element.AERO;
    private int ticks = -2;

    public ElementalStorm(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ElementalStorm(Level level, float damage, Element element) {
        super((EntityType)EntityRegistry.FROZEN_STORM.get(), level);
        this.damage = damage;
        this.element = element;
        this.m_20242_(true);
    }

    public ElementalStorm(Level level, int duration, float damage, Element element) {
        super((EntityType)EntityRegistry.FROZEN_STORM.get(), level);
        this.damage = damage;
        this.element = element;
        this.duration = duration;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticks;
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if ((float)this.ticks > this.duration + 20.0f) {
            this.m_146870_();
        }
        float maxRadians = (float)Math.toRadians(360.0);
        float radius = this.getRadius();
        Random random = new Random(this.ticks);
        for (float i = 0.0f; i <= radius * 2.0f; i += 0.8f) {
            double xLayerOffset = (random.nextDouble() - 0.5) * 0.6;
            double zLayerOffset = (random.nextDouble() - 0.5) * 0.6;
            float currentRadius = i / 2.5f;
            boolean rotateClockwise = random.nextBoolean();
            int x = 0;
            while ((float)x < currentRadius * 8.0f) {
                float step = maxRadians / (currentRadius * 8.0f);
                float animOffset = (float)Math.toRadians(this.ticks * (rotateClockwise ? 4 : -4));
                double X = Math.sin((float)x * step + animOffset) * (double)currentRadius + xLayerOffset;
                double Z = Math.cos((float)x * step + animOffset) * (double)currentRadius + zLayerOffset;
                float heightFactor = i / (radius * 2.5f);
                int color = this.blendColors(ElementsUtils.getColorByElement(this.element), ElementsUtils.getEndColorByElement(this.element), heightFactor);
                ParticleUtils.createParticle(level, new GlowingParticleData(new Color(color), 0.4f, 10, 0.15f), this.m_20185_() + X, this.m_20186_() + (double)(i * 0.8f), this.m_20189_() + Z, 1, 0.01, 0.01, 0.01, 0.01);
                ++x;
            }
        }
        for (int j = 0; j < 5; ++j) {
            double progress = (double)(this.ticks % 100) / 100.0;
            double angle = Math.toRadians(progress * 360.0 + (double)(j * 72));
            double radiusFactor = 1.0 + Math.sin(progress * Math.PI * 2.0) * 0.5;
            double xOffset = Math.cos(angle) * radiusFactor * (double)radius * 0.5;
            double zOffset = Math.sin(angle) * radiusFactor * (double)radius * 0.5;
            for (int i = 0; i < 3; ++i) {
                double yOffset = progress * (double)radius * 2.0 + (double)(i - 1) * 0.3;
                double randomOffsetX = (random.nextDouble() - 0.5) * 0.3;
                double randomOffsetY = (random.nextDouble() - 0.5) * 0.7;
                double randomOffsetZ = (random.nextDouble() - 0.5) * 0.3;
                ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(this.element), 0.5f, 15, 0.2f), this.m_20185_() + xOffset + randomOffsetX, this.m_20186_() + yOffset + randomOffsetY, this.m_20189_() + zOffset + randomOffsetZ, 1, 0.02, 0.02, 0.02, 0.02);
                ParticleUtils.createParticle(level, (ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + xOffset + randomOffsetX, this.m_20186_() + yOffset + randomOffsetY, this.m_20189_() + zOffset + randomOffsetZ, 1, 0.02, 0.02, 0.02, 0.02);
            }
        }
        List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0));
        for (LivingEntity entity2 : entities) {
            if (this.m_19749_() == null || entity2 == this.m_19749_() || !entity2.m_6084_()) continue;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 3));
            entity2.m_146917_(40);
            if (this.ticks % 30 == 0) {
                entity2.m_6469_(this.m_269291_().m_269425_(), this.damage - 1.0f);
            }
            double distanceToCenter = Math.sqrt(Math.pow(entity2.m_20185_() - this.m_20185_(), 2.0) + Math.pow(entity2.m_20189_() - this.m_20189_(), 2.0));
            double targetRadius = Math.max(1.5, Math.min(3.0, distanceToCenter - 0.1));
            double angle = Math.atan2(entity2.m_20189_() - this.m_20189_(), entity2.m_20185_() - this.m_20185_());
            double maxLiftHeight = 5.0;
            double verticalProgress = Math.min(1.0, (double)this.ticks / 200.0);
            double liftHeight = maxLiftHeight * verticalProgress;
            double newY = this.m_20186_() + liftHeight;
            double newX = this.m_20185_() + Math.cos(angle += Math.toRadians(this.ticks * 2)) * targetRadius;
            double newZ = this.m_20189_() + Math.sin(angle) * targetRadius;
            entity2.m_20334_((newX - entity2.m_20185_()) * 0.2, (newY - entity2.m_20186_()) * 0.2, (newZ - entity2.m_20189_()) * 0.2);
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(150, 200, 255), 0.3f, 10, 0.1f), entity2.m_20185_(), entity2.m_20186_() + (double)(entity2.m_20206_() / 2.0f), entity2.m_20189_(), 1, 0.02, 0.02, 0.02, 0.01);
        }
        if (entities.isEmpty()) {
            double searchRadius = 10.0;
            List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20182_().m_82520_(-searchRadius, -searchRadius, -searchRadius), this.m_20182_().m_82520_(searchRadius, searchRadius, searchRadius)), entity -> entity.m_6084_() && entity != this.m_19749_() && entity.m_20148_() != this.m_20148_());
            if (!nearbyEntities.isEmpty()) {
                LivingEntity target = nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this))).orElse(null);
                if (target != null) {
                    Vec3 targetPos = new Vec3(target.m_20185_(), this.m_20186_(), target.m_20189_());
                    Vec3 smoothVelocity = targetPos.m_82546_(this.m_20182_()).m_82541_().m_82490_(0.1);
                    this.m_20256_(smoothVelocity);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                }
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        } else {
            Vec3 targetPos = new Vec3(this.m_20185_() + Math.random() * 2.0 - 1.0, this.m_20186_(), this.m_20189_() + Math.random() * 2.0 - 1.0);
            Vec3 smoothVelocity = targetPos.m_82546_(this.m_20182_()).m_82490_(0.1);
            this.m_20256_(smoothVelocity);
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.ticks % 40 == 0) {
            IcySpearEntity spear = new IcySpearEntity(level, this.damage / 2.0f, ElementsUtils.getColorByElement(Element.CRYO).getRGB());
            spear.m_146884_(new Vec3(this.m_20185_(), this.m_20186_() + 2.0 + (double)random.nextInt(1, 4), this.m_20189_()));
            spear.m_20256_(new Vec3(Math.random() - 0.5, 0.5, Math.random() - 0.5).m_82541_().m_82490_(0.3));
            spear.m_20242_(false);
            level.m_7967_((Entity)spear);
            ParticleUtils.createParticle(level, (ParticleOptions)ParticleTypes.f_175821_, spear.m_20185_(), spear.m_20186_(), spear.m_20189_(), 0, 0.1, 0.0, 0.02, 1.0);
        }
    }

    private int blendColors(Color color1, Color color2, float factor) {
        factor = Math.max(0.0f, Math.min(1.0f, factor));
        int r = (int)((float)color1.getRed() + (float)(color2.getRed() - color1.getRed()) * factor);
        int g = (int)((float)color1.getGreen() + (float)(color2.getGreen() - color1.getGreen()) * factor);
        int b = (int)((float)color1.getBlue() + (float)(color2.getBlue() - color1.getBlue()) * factor);
        return new Color(r, g, b).getRGB();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.element = Element.ofString(compound.m_128461_("element"));
        this.radius = compound.m_128457_("radius");
        this.duration = compound.m_128457_("duration");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128359_("element", this.element.name().toLowerCase());
        compound.m_128350_("radius", this.radius);
        compound.m_128350_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public Element getElement() {
        return this.element;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }
}

