/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.base.IAnimatedEntity;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Explosion
extends Entity
implements IAnimatedEntity {
    public AnimationController controller = new AnimationController(this);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(Explosion.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private float strength = 1.0f;
    private UUID ownerUUID;

    public void setElement(String num) {
        this.m_20088_().m_135381_(ELEMENT, (Object)num);
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    public Explosion(EntityType<Explosion> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = false;
    }

    public Explosion(EntityType<Explosion> pEntityType, Level pLevel, String element) {
        super(pEntityType, pLevel);
        this.f_19794_ = false;
        this.setElement(element);
    }

    public void m_8119_() {
        super.m_8119_();
        this.controller.tick();
        if (this.f_19797_ > 0 && this.f_19797_ < 4) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_144050_, SoundSource.MASTER, 3.0f, 1.0f);
        }
        if (this.f_19797_ >= 20) {
            this.m_146870_();
        }
        List entities = this.m_9236_().m_45976_(Projectile.class, this.m_20191_().m_82400_(1.0));
        double knockbackRadius = 1.1;
        for (Projectile entity1 : entities) {
            double distanceSquared;
            if (entity1.m_20148_() == this.ownerUUID || !((distanceSquared = this.m_20280_((Entity)entity1)) <= knockbackRadius * knockbackRadius)) continue;
            double distance = Math.sqrt(distanceSquared);
            double knockbackStrength = this.strength;
            double upwardMotion = (double)this.strength / 2.0;
            Vec3 motion = entity1.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(knockbackStrength / distance).m_82520_(0.0, upwardMotion, 0.0);
            entity1.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
        List entities1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0));
        for (LivingEntity entity1 : entities1) {
            double distanceSquared;
            if (entity1.m_20148_() == this.ownerUUID || !((distanceSquared = this.m_20280_((Entity)entity1)) <= knockbackRadius * knockbackRadius)) continue;
            double distance = Math.sqrt(distanceSquared);
            double knockbackStrength = this.strength;
            double upwardMotion = (double)this.strength / 2.0;
            Vec3 motion = entity1.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(knockbackStrength / distance).m_82520_(0.0, upwardMotion, 0.0);
            entity1.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            ElementHandler.addElement(entity1, Element.ofString(this.getElement()), 2.0f, 100, true);
            if (!(entity1 instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity1;
            Networking.sendToClient(player, new EntityVelocityPacket(motion.f_82479_, motion.f_82480_, motion.f_82481_));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ELEMENT, (Object)"AERO");
    }

    protected void m_7378_(CompoundTag compound) {
        this.m_20088_().m_135381_(ELEMENT, (Object)compound.m_128461_("element"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("element", (String)this.m_20088_().m_135370_(ELEMENT));
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public Entity getAnimatedEntity() {
        return this;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public static class Render
    extends EntityRenderer<Explosion> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(@NotNull Explosion entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
            Map<String, Animation> animations = AnimationStorage.getAnimations(new ResourceLocation("etheria", "animations/explosion.animation.json"));
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/explosion.geo.json"));
            AnimationController controller = entityIn.getController();
            GeometryChanges changes = controller.apply(partialTicks);
            model.applyAnimChanges(changes);
            controller.startAnimation("idle", animations.get("animation.model.start"), LoopMode.LOOP);
            poseStack.m_85836_();
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            model.renderModel(poseStack, buffer.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(entityIn))), packedLightIn, OverlayTexture.f_118083_, 0.9f);
            poseStack.m_85849_();
        }

        @NotNull
        public ResourceLocation getTextureLocation(Explosion entityIn) {
            return new ResourceLocation("etheria", "textures/entity/explosion_" + entityIn.getElement().toLowerCase() + ".png");
        }
    }
}

