/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FireWhirl
extends Projectile {
    private float damage;
    private float duration;
    private float radius;
    private int color;
    private boolean isFinish;

    public FireWhirl(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FireWhirl(Level level, float damage, float radius) {
        super((EntityType)EntityRegistry.FIRE_WHIRL.get(), level);
        this.radius = radius;
        this.damage = damage;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        this.color = ElementsUtils.getRandomColorByElement(Element.PYRO).getRGB();
        Level level = this.m_9236_();
        if (this.m_19749_() == null) {
            this.m_146870_();
            return;
        }
        this.m_146884_(this.m_19749_().m_20182_().m_82520_(0.0, 1.0, 0.0));
        if (this.f_19797_ > 100) {
            this.m_146870_();
            return;
        }
        double angle = (double)this.f_19797_ * 0.1 % (Math.PI * 2);
        double radius = 3.0;
        double x = this.m_20185_() + radius * Math.cos(angle);
        double z = this.m_20189_() + radius * Math.sin(angle);
        double y = this.m_20186_();
        this.m_6034_(x, y, z);
        AABB area = new AABB(x - 1.0, y - 1.0, z - 1.0, x + 1.0, y + 1.0, z + 1.0);
        List entities = level.m_45976_(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            if (entity == this.m_19749_() || !entity.m_6084_()) continue;
            entity.m_6469_(level.m_269111_().m_269425_(), this.damage);
            entity.m_20254_(5);
        }
        for (int i = 0; i < 10; ++i) {
            angle = Math.PI * 2 * (double)level.f_46441_.m_188501_();
            radius = 1.0;
            float offsetX = (float)(Math.cos(angle) * radius);
            float offsetZ = (float)(Math.sin(angle) * radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(this.color, 0.3f, 20, 0.025f), x + (double)offsetX, y, z + (double)offsetZ, 1, 0.0, 0.0, 0.0);
        }
        ParticleUtils.drawParticlesToCenter(new GlowingParticleData(this.color, 0.3f, 20, 0.025f), level, new Vec3(x, y, z), 10, 1.0f, 0.05f, 0.5f);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.color = compound.m_128451_("color");
        this.radius = compound.m_128457_("radius");
        this.duration = compound.m_128457_("duration");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("color", this.color);
        compound.m_128350_("radius", this.radius);
        compound.m_128350_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isFinish() {
        return this.isFinish;
    }
}

