/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class FrostShackles
extends Projectile {
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(FrostShackles.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FrostShackles.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ENTITY_ID = SynchedEntityData.m_135353_(FrostShackles.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public void setEntity(int num) {
        this.m_20088_().m_135381_(ENTITY_ID, (Object)num);
    }

    public int getEntity() {
        return (Integer)this.m_20088_().m_135370_(ENTITY_ID);
    }

    public void setLifeTime(int num) {
        this.m_20088_().m_135381_(LIFETIME, (Object)num);
    }

    public int getLifeTime() {
        return (Integer)this.m_20088_().m_135370_(LIFETIME);
    }

    public void setDamage(float num) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(num));
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public FrostShackles(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        Random random = RandomUtils.random();
        if (this.m_9236_().f_46443_) {
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f + random.nextFloat() * 0.1f, 20, 1.0f), this.m_20185_() + (double)random.nextFloat() - (double)random.nextFloat(), this.m_20186_() + (double)random.nextFloat(), this.m_20189_() + (double)random.nextFloat() - (double)random.nextFloat(), 5, 0.05, -0.01, 0.05, 0.005f);
        }
        if (this.f_19797_ % 20 == 0 && (entity = this.m_9236_().m_6815_(this.getEntity())) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() != null && entity.m_19879_() != this.m_19749_().m_19879_()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.getLifeTime() / 2, 254, true, false));
                livingEntity.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
                livingEntity.m_146917_(this.getLifeTime() / 2);
            }
        }
        if ((entity = this.m_9236_().m_6815_(this.getEntity())) != null && !entity.m_6084_() && this.f_19797_ > this.getLifeTime() - 40) {
            this.f_19797_ = this.getLifeTime() - 40;
        } else if (this.f_19797_ > this.getLifeTime() - 30) {
            this.m_146870_();
        }
        if (entity == null || this.f_19797_ >= this.getLifeTime()) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFETIME, (Object)100);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
        this.f_19804_.m_135372_(ENTITY_ID, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128457_("damage"));
        this.setLifeTime(compound.m_128451_("lifetime"));
        this.setEntity(compound.m_128451_("entity"));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damage", this.getDamage());
        compound.m_128405_("lifetime", this.getLifeTime());
        compound.m_128405_("entity", this.getEntity());
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class Render
    extends EntityRenderer<FrostShackles> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(FrostShackles entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
            float offset;
            poseStack.m_85836_();
            float progress = (float)entityIn.f_19797_ * 1.4f + partialTicks;
            float totalLife = entityIn.getLifeTime();
            float normalizedProgress = progress / totalLife;
            if (normalizedProgress <= 0.1f) {
                offset = -0.8f + 8.0f * normalizedProgress;
            } else if (normalizedProgress >= 0.9f) {
                float fadeProgress = (normalizedProgress - 0.9f) / 0.1f;
                offset = -0.8f * fadeProgress;
            } else {
                offset = 0.0f;
            }
            poseStack.m_252880_((float)(Math.sin((double)progress * 3.0) * 0.01), offset, (float)(Math.cos((double)progress * 3.0) * 0.01));
            poseStack.m_85841_(1.3f, 1.3f, 1.3f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(20.0f));
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/ice_seal.geo.json"));
            model.renderModel(poseStack, buffer.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("etheria", "textures/block/ice_seal.png"))), packedLightIn, OverlayTexture.f_118083_, 0.9f);
            poseStack.m_85849_();
        }

        @NotNull
        public ResourceLocation getTextureLocation(FrostShackles p_114482_) {
            return new ResourceLocation("etheria", "textures/block/ice_seal.png");
        }
    }
}

