/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FrozenOrbitEntity
extends ThrowableProjectile {
    private float damage;
    private float duration;
    private boolean isNegative;
    private final List<IcySpearEntity> spears = new ArrayList<IcySpearEntity>();

    public FrozenOrbitEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FrozenOrbitEntity(Level level, float damage, int duration) {
        super((EntityType)EntityRegistry.FROZEN_ORBIT.get(), level);
        this.damage = damage;
        this.duration = duration;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1 && !this.m_9236_().f_46443_) {
            double radius = 1.5;
            double angleOffset = 2.0943951023931953;
            for (int i = 0; i < 3; ++i) {
                double angle = (double)i * angleOffset;
                double x = this.m_20185_() + radius * Math.cos(angle);
                double z = this.m_20189_() + radius * Math.sin(angle);
                double y = this.m_20186_();
                IcySpearEntity spear = new IcySpearEntity(this.m_9236_(), this.damage, ElementsUtils.getRandomColorByElement(Element.CRYO).getRGB(), (int)this.duration, true);
                spear.m_6034_(x, y, z);
                spear.m_5602_(this.m_19749_());
                this.spears.add(spear);
                this.m_9236_().m_7967_((Entity)spear);
            }
        }
        int direction = this.isNegative ? -1 : 1;
        double radius = 2 + (this.isNegative ? -1 : 0);
        double angleOffset = Math.PI * 2 / (double)this.spears.size();
        long time = System.currentTimeMillis();
        double angleSpeed = 0.001;
        double baseAngle = (double)time * angleSpeed;
        for (int i = 0; i < this.spears.size(); ++i) {
            IcySpearEntity spear = this.spears.get(i);
            if (spear == null || spear.m_213877_()) continue;
            double angle = (baseAngle + (double)i * angleOffset) * (double)direction;
            double x = this.m_20185_() + radius * Math.cos(angle);
            double z = this.m_20189_() + radius * Math.sin(angle);
            double y = this.m_20186_();
            spear.m_6034_(x, y, z);
            Vec3 motion = new Vec3(-Math.sin(angle) * (double)direction, 0.0, Math.cos(angle) * (double)direction).m_82490_(0.1);
            spear.m_20256_(motion);
        }
    }

    protected void m_8097_() {
    }

    public void m_6043_() {
        if ((float)this.f_19797_ > this.duration) {
            this.m_146870_();
            this.spears.forEach(Entity::m_146870_);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.isNegative = compound.m_128471_("isNegative");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128379_("isNegative", this.isNegative);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }
}

