/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class IcySpearEntity
extends ThrowableProjectile {
    private float damage;
    private int color;
    private int duration;

    public IcySpearEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IcySpearEntity(Level level, float damage, int color, int duration) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = duration;
        this.m_20242_(false);
    }

    public IcySpearEntity(Level level, float damage, int color, int duration, boolean isGravity) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = duration;
        this.m_20242_(isGravity);
    }

    public IcySpearEntity(Level level, float damage, int color) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = 100;
        this.m_20242_(false);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.3f, 40, 0.9f), this.f_19854_, this.f_19855_, this.f_19856_, 3, 0.025, 0.025, 0.025, 0.01);
    }

    public void m_6043_() {
        if (this.f_19797_ > this.duration) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!state.m_280555_()) {
            return;
        }
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.MASTER, 0.75f, 3.0f);
        this.m_146870_();
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult result) {
        block11: {
            block10: {
                if (this.m_9236_().m_5776_() || !((var3_2 = result.m_82443_()) instanceof LivingEntity)) break block10;
                entity = (LivingEntity)var3_2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block11;
            }
            return;
        }
        mayContinue = false;
        var6_5 = this.m_19749_();
        if (!(var6_5 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var6_5;
        var6_5 = result.m_82443_();
        if (var6_5 instanceof Player) {
            player1 = (Player)var6_5;
            if (entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), this.damage)) {
                mayContinue = true;
            }
        } else if (entity.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.damage)) {
            mayContinue = true;
        }
        if (mayContinue) {
            var5_7 = this.m_19749_();
            if (var5_7 instanceof Player) {
                player = (Player)var5_7;
                SkillsUtils.addXp(player, Branches.MAGIC, 2);
            }
            ElementHandler.addElement(entity, Element.CRYO, this.getDamage(), 200, true);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.color = compound.m_128451_("color");
        this.duration = compound.m_128451_("duration");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("color", this.color);
        compound.m_128405_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public int getColor() {
        return this.color;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public static class Render
    extends EntityRenderer<IcySpearEntity> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(IcySpearEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/icy_spear"));
            matrixStackIn.m_85837_(0.0, -0.2, 0.0);
            double motionX = entityIn.m_20184_().m_7096_();
            double motionY = entityIn.m_20184_().m_7098_();
            double motionZ = entityIn.m_20184_().m_7094_();
            double horizontalMotion = Math.sqrt(motionX * motionX + motionZ * motionZ);
            double angleXZ = Math.atan2(motionX, motionZ);
            double angleY = Math.atan2(motionY, horizontalMotion);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(angleXZ) + 180.0f));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_((float)Math.toDegrees(angleY)));
            model.renderModel(matrixStackIn, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entityIn))), 0xF000F0, OverlayTexture.f_118083_);
        }

        public ResourceLocation getTextureLocation(@NotNull IcySpearEntity p_114482_) {
            return new ResourceLocation("etheria", "textures/entity/isy_spear.png");
        }
    }
}

