/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.ScreenShakeEntity;
import it.mralxart.etheria.magic.spells.entities.SpellEntity;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class PhoenixRise
extends Projectile {
    private float damage;
    private float duration;
    private float radius;
    private int color;
    private boolean isFinish;

    public PhoenixRise(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PhoenixRise(Level level, float damage, float radius) {
        super((EntityType)EntityRegistry.PHOENIX_RISE.get(), level);
        this.radius = radius;
        this.damage = damage;
        this.m_20242_(true);
    }

    public void m_8119_() {
        ServerPlayer serverPlayer;
        Entity entity2;
        super.m_8119_();
        this.color = ElementsUtils.getRandomColorByElement(Element.PYRO).getRGB();
        Level level = this.m_9236_();
        if (this.m_19749_() != null) {
            this.m_146884_(this.m_19749_().m_20182_().m_82520_(0.0, 1.0, 0.0));
        }
        if (level.m_5776_()) {
            return;
        }
        if (this.f_19797_ > 100) {
            this.m_146870_();
        }
        if (this.f_19797_ < 30) {
            ParticleUtils.drawAnimatedCylWithLines(this.m_9236_(), this.m_20318_(0.0f), this.f_19797_, 1.5, new Color(this.color), this.m_20182_().m_82520_(0.0, -0.5, 0.0));
            ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.m_20318_(0.0f).m_82520_(0.0, 0.25, 0.0), -this.f_19797_, 1.5, new Color(this.color));
        } else if (this.m_19749_() != null && (entity2 = this.m_19749_()) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity2;
            serverPlayer.m_183634_();
        }
        if (this.f_19797_ == 20 && this.m_19749_() != null && (entity2 = this.m_19749_()) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity2;
            this.m_19749_().m_20334_(0.0, 1.0, 0.0);
            Networking.sendToClient(serverPlayer, new EntityVelocityPacket(0.0, 1.0, 0.0));
        }
        if (this.f_19797_ >= 45 && this.m_19749_() != null && (entity2 = this.m_19749_()) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity2;
            if (serverPlayer.f_19789_ <= 0.0f && !this.isFinish) {
                this.isFinish = true;
                List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_((double)this.radius), entity -> entity != this.m_19749_());
                ScreenShakeEntity.summonShake(level, this.m_20182_(), this.radius, 0.1f, 40, 30);
                if (entities.isEmpty()) {
                    return;
                }
                for (LivingEntity entity1 : entities) {
                    double distanceSquared;
                    if (entity1.m_20148_() == this.m_19749_().m_20148_() || !((distanceSquared = this.m_20280_((Entity)entity1)) <= (double)(this.getRadius() * 2.0f))) continue;
                    double distance = Math.sqrt(distanceSquared);
                    double knockbackStrength = 2.5;
                    double upwardMotion = 1.0;
                    Vec3 motion = entity1.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(knockbackStrength / distance).m_82520_(0.0, upwardMotion, 0.0);
                    entity1.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    if (!(entity1 instanceof ServerPlayer)) continue;
                    ServerPlayer player = (ServerPlayer)entity1;
                    Networking.sendToClient(player, new EntityVelocityPacket(motion.f_82479_, motion.f_82480_, motion.f_82481_));
                }
                ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                Random random = new Random();
                for (LivingEntity target : entities) {
                    scheduler.schedule(() -> {
                        ParticleUtils.createWavyLine(level, new GlowingParticleData(this.color, 0.3f, 40, 0.02f), this.m_20182_().m_82520_(0.0, 0.5, 0.0), target.m_20182_().m_82520_(0.0, 0.5, 0.0), 100, 100, 20.0, 0.2f, new Random().nextLong(1L, 200L), false);
                        SpellEntity entity = new SpellEntity(level, this.damage, Element.PYRO.name());
                        entity.m_5602_((Entity)serverPlayer);
                        entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        entity.m_20242_(true);
                        Vec3 direction = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
                        double speed = 0.5;
                        entity.m_20256_(direction.m_82490_(speed));
                        this.m_9236_().m_7967_((Entity)entity);
                        for (int i = 0; i < 10; ++i) {
                            ParticleUtils.createParticle(level, new GlowingParticleData(this.color, 0.3f, 40, 0.02f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.0, 0.0, 0.0, 0.05f);
                        }
                    }, (long)(random.nextInt(1500) + 500), TimeUnit.MILLISECONDS);
                }
                scheduler.shutdown();
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.color = compound.m_128451_("color");
        this.radius = compound.m_128457_("radius");
        this.duration = compound.m_128457_("duration");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("color", this.color);
        compound.m_128350_("radius", this.radius);
        compound.m_128350_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isFinish() {
        return this.isFinish;
    }
}

