/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.trial;

import it.mralxart.etheria.magic.trial.TrialInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TrialDataInfo {
    private String id;
    private Map<String, TrialInfo> trial;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        ListTag trialInfosTag = new ListTag();
        for (Map.Entry<String, TrialInfo> entry : this.trial.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("key", entry.getKey());
            entryTag.m_128365_("value", (Tag)entry.getValue().serializeNBT());
            trialInfosTag.add((Object)entryTag);
        }
        tag.m_128365_("trialInfos", (Tag)trialInfosTag);
        return tag;
    }

    public static TrialDataInfo deserializeNBT(CompoundTag tag) {
        String id = tag.m_128461_("id");
        ListTag trialInfosTag = tag.m_128437_("trialInfos", 10);
        HashMap<String, TrialInfo> trialInfos = new HashMap<String, TrialInfo>();
        for (int i = 0; i < trialInfosTag.size(); ++i) {
            CompoundTag entryTag = trialInfosTag.m_128728_(i);
            String key = entryTag.m_128461_("key");
            TrialInfo value = TrialInfo.deserializeNBT(entryTag.m_128469_("value"));
            trialInfos.put(key, value);
        }
        return new TrialDataInfo(id, trialInfos);
    }

    public static TrialDataInfoBuilder builder() {
        return new TrialDataInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, TrialInfo> getTrial() {
        return this.trial;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTrial(Map<String, TrialInfo> trial) {
        this.trial = trial;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrialDataInfo)) {
            return false;
        }
        TrialDataInfo other = (TrialDataInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, TrialInfo> this$trial = this.getTrial();
        Map<String, TrialInfo> other$trial = other.getTrial();
        return !(this$trial == null ? other$trial != null : !((Object)this$trial).equals(other$trial));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrialDataInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, TrialInfo> $trial = this.getTrial();
        result = result * 59 + ($trial == null ? 43 : ((Object)$trial).hashCode());
        return result;
    }

    public String toString() {
        return "TrialDataInfo(id=" + this.getId() + ", trial=" + this.getTrial() + ")";
    }

    public TrialDataInfo(String id, Map<String, TrialInfo> trial) {
        this.id = id;
        this.trial = trial;
    }

    public static class TrialDataInfoBuilder {
        private String id;
        private Map<String, TrialInfo> trial = new HashMap<String, TrialInfo>();

        public TrialDataInfoBuilder trial(TrialInfo skill) {
            this.trial.put(skill.getId(), skill);
            return this;
        }

        public TrialDataInfoBuilder trials(TrialInfo ... infos) {
            for (TrialInfo info : infos) {
                this.trial.put(info.getId(), info);
            }
            return this;
        }

        TrialDataInfoBuilder() {
        }

        public TrialDataInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TrialDataInfo build() {
            return new TrialDataInfo(this.id, this.trial);
        }

        public String toString() {
            return "TrialDataInfo.TrialDataInfoBuilder(id=" + this.id + ", trial=" + this.trial + ")";
        }
    }
}

