/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.mixin;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.items.SpellScrollItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    public void appendHoverText(ItemStack p_41421_, Level level, List<Component> p_41423_, TooltipFlag p_41424_, CallbackInfo ci) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.etheria$processTooltip(p_41421_, level, p_41423_);
        }
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private void etheria$processTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        if (EnigmaUtils.isEnigma(stack) && Minecraft.m_91087_().f_91075_ != null) {
            tooltip.add((Component)Component.m_237113_((String)"Enigma-Charged").m_130948_(Style.f_131099_.m_178520_(EnigmaUtils.endColor.getRGB())));
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("etheria$stats", 9) && !(stack.m_41720_() instanceof ArtifactItem) && !(stack.m_41720_() instanceof SpellScrollItem)) {
            if (EnigmaUtils.isEnigma(stack) && Minecraft.m_91087_().f_91075_ != null) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            Map<StatType, Float> mainStats = ArtifactStatsManager.getMainStats(stack);
            Map<StatType, Float> stats = ArtifactStatsManager.getSecondaryStats(stack);
            Element element = Element.ETHER;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
                element = Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase());
            }
            if (!mainStats.isEmpty() && !stats.isEmpty()) {
                String formattedValue;
                String translateName;
                float value;
                StatType stat;
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.curve").getString() + ":")).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(element).getRGB())));
                for (Map.Entry<StatType, Float> entry : mainStats.entrySet()) {
                    stat = entry.getKey();
                    if (stat.equals((Object)StatType.NONE)) continue;
                    value = entry.getValue().floatValue();
                    translateName = Component.m_237115_((String)("etheria.stat." + stat.getName())).getString();
                    formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                    tooltip.add((Component)Component.m_237113_((String)("\u00b7 \u00a7r" + translateName + ": \u00a7r" + formattedValue)));
                }
                for (Map.Entry<StatType, Float> entry : stats.entrySet()) {
                    stat = entry.getKey();
                    if (stat.equals((Object)StatType.NONE)) continue;
                    value = entry.getValue().floatValue();
                    translateName = Component.m_237115_((String)("etheria.stat." + stat.getName())).getString();
                    formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                    tooltip.add((Component)Component.m_237113_((String)("\u00a77\u00a7o" + translateName + ": " + formattedValue)));
                }
            }
            if (ArtifactStatsManager.isMaxLevel(stack)) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"etheria.max_level").getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(element).getRGB())));
            }
        }
    }
}

