/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network;

import it.mralxart.etheria.network.packets.AddToastPacket;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.network.packets.C2SSkillButtonPacket;
import it.mralxart.etheria.network.packets.CastSpellPacket;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.network.packets.KorLunarUpPacket;
import it.mralxart.etheria.network.packets.PacketCheckDungeon;
import it.mralxart.etheria.network.packets.PacketDungeonResponse;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.network.packets.SlotChangePacket;
import it.mralxart.etheria.network.packets.StartRitualPacket;
import it.mralxart.etheria.network.packets.SyncCapabilityPacket;
import it.mralxart.etheria.network.packets.SyncEntityCapabilityPacket;
import it.mralxart.etheria.network.packets.SyncTilePacket;
import it.mralxart.etheria.network.packets.UpdateSpellsCooldownPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking {
    public static SimpleChannel INSTANCE;
    public static int ID;

    public static int nextID() {
        return ID++;
    }

    public static void init() {
        ID = 0;
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("etheria", "networking"), () -> "1.0", s -> true, s -> true);
        INSTANCE.messageBuilder(ParticleSpawnerPacket.class, Networking.nextID()).encoder(ParticleSpawnerPacket::toBytes).decoder(ParticleSpawnerPacket::new).consumerMainThread(ParticleSpawnerPacket::handle).add();
        INSTANCE.messageBuilder(StartRitualPacket.class, Networking.nextID()).encoder(StartRitualPacket::toBytes).decoder(StartRitualPacket::new).consumerMainThread(StartRitualPacket::handle).add();
        INSTANCE.messageBuilder(UpdateSpellsCooldownPacket.class, Networking.nextID()).encoder(UpdateSpellsCooldownPacket::toBytes).decoder(UpdateSpellsCooldownPacket::new).consumerMainThread(UpdateSpellsCooldownPacket::handle).add();
        INSTANCE.messageBuilder(EntityVelocityPacket.class, Networking.nextID()).encoder(EntityVelocityPacket::toBytes).decoder(EntityVelocityPacket::new).consumerMainThread(EntityVelocityPacket::handle).add();
        INSTANCE.messageBuilder(CastSpellPacket.class, Networking.nextID()).encoder(CastSpellPacket::toBytes).decoder(CastSpellPacket::new).consumerMainThread(CastSpellPacket::handle).add();
        INSTANCE.messageBuilder(SyncCapabilityPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(SyncCapabilityPacket::toBytes).decoder(SyncCapabilityPacket::new).consumerMainThread(SyncCapabilityPacket::handle).add();
        INSTANCE.messageBuilder(AddToastPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(AddToastPacket::toBytes).decoder(AddToastPacket::new).consumerMainThread(AddToastPacket::handle).add();
        INSTANCE.messageBuilder(SlotChangePacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(SlotChangePacket::encode).decoder(SlotChangePacket::decode).consumerMainThread(SlotChangePacket::handle).add();
        INSTANCE.messageBuilder(KorLunarUpPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(KorLunarUpPacket::toBytes).decoder(KorLunarUpPacket::new).consumerMainThread(KorLunarUpPacket::handle).add();
        INSTANCE.messageBuilder(C2SSkillButtonPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(C2SSkillButtonPacket::read).decoder(C2SSkillButtonPacket::new).consumerMainThread(C2SSkillButtonPacket::handle).add();
        INSTANCE.messageBuilder(PacketCheckDungeon.class, Networking.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(PacketCheckDungeon::encode).decoder(PacketCheckDungeon::new).consumerMainThread(PacketCheckDungeon::handle).add();
        INSTANCE.messageBuilder(C2SPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(C2SPacket::toBytes).decoder(C2SPacket::new).consumerMainThread(C2SPacket::handle).add();
        INSTANCE.messageBuilder(S2CPacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(S2CPacket::toBytes).decoder(S2CPacket::new).consumerMainThread(S2CPacket::handle).add();
        INSTANCE.messageBuilder(PacketDungeonResponse.class, Networking.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(PacketDungeonResponse::encode).decoder(PacketDungeonResponse::new).consumerMainThread(PacketDungeonResponse::handle).add();
        INSTANCE.messageBuilder(SyncTilePacket.class, Networking.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(SyncTilePacket::toBytes).decoder(SyncTilePacket::new).consumerMainThread(SyncTilePacket::handle).add();
        INSTANCE.messageBuilder(SyncEntityCapabilityPacket.class, Networking.nextID()).encoder(SyncEntityCapabilityPacket::toBytes).decoder(SyncEntityCapabilityPacket::new).consumerMainThread(SyncEntityCapabilityPacket::handle).add();
    }

    public static void sendToClients(PacketDistributor.PacketTarget target, Object packet) {
        INSTANCE.send(target, packet);
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }

    public static void sendToAll(Object packet) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            INSTANCE.send(PacketDistributor.ALL.noArg(), packet);
        }
    }

    public static void sendToClient(ServerPlayer player, Object packet) {
        INSTANCE.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendTrackingEntity(Entity entity, Object packet) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
    }

    public static void sendTrackingChunk(LevelChunk entity, Object packet) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity), packet);
    }

    static {
        ID = 0;
    }
}

