/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;

public class C2SPacket {
    private final CompoundTag tag;
    private final int action;

    public C2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
        this.action = buf.readInt();
    }

    public C2SPacket(CompoundTag tag, int action) {
        this.tag = tag;
        this.action = action;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.writeInt(this.action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return false;
        }
        switch (this.action) {
            case 1: {
                String string = this.tag.m_128461_("element");
                Element element = Element.NONE;
                try {
                    element = Element.valueOf(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                CapabilityRegistry.getCap((Player)player).setElement2(CapabilityRegistry.getCap((Player)player).getElement());
                CapabilityRegistry.getCap((Player)player).setElement(element);
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 2: {
                CapabilityRegistry.getCap((Player)player).setLoomHud(false);
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 312: {
                BlockPos pos = new BlockPos(this.tag.m_128451_("x"), this.tag.m_128451_("y"), this.tag.m_128451_("z"));
                BlockEntity blockEntity = player.m_9236_().m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE);
                if (!(blockEntity instanceof IAnimatedTile)) break;
                IAnimatedTile animated = (IAnimatedTile)blockEntity;
                this.tag.m_128365_("controller", (Tag)animated.getController().serializeNBT());
                Networking.sendToClient(player, new S2CPacket(this.tag, 113));
                break;
            }
            case 1104: {
                if (!StarUtils.getStarById((Player)player, this.tag.m_128461_("id")).isPresent()) break;
                StarUtils.unlockStarById((Player)player, this.tag.m_128461_("id"), true);
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 759: {
                if (!StarUtils.getStarById((Player)player, this.tag.m_128461_("id")).isPresent()) break;
                SpellsUtils.getSpell((Player)player, this.tag.m_128461_("id")).setUnlock(true);
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 406: {
                CapabilityRegistry.getCap((Player)player).getActiveSpells().clear();
                for (String spellId : this.tag.m_128431_()) {
                    int baseIndex = this.tag.m_128451_(spellId);
                    CapabilityRegistry.getCap((Player)player).getActiveSpells().put(spellId, baseIndex);
                }
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 806: {
                String string = this.tag.m_128461_("element");
                Element element = Element.NONE;
                try {
                    element = Element.valueOf(string.toUpperCase());
                }
                catch (IllegalArgumentException baseIndex) {
                    // empty catch block
                }
                List<Element> elements = CapabilityRegistry.getCap((Player)player).getElements();
                elements.add(element);
                CapabilityRegistry.getCap((Player)player).setElements(elements);
                CapabilityRegistry.getCap((Player)player).setElement(element);
                SyncCapabilityManager.sync((Player)player);
                break;
            }
            case 847: {
                String string = this.tag.m_128461_("element");
                Element element = Element.NONE;
                try {
                    element = Element.valueOf(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (CapabilityRegistry.getCap((Player)player).getElement().equals((Object)element)) {
                    CapabilityRegistry.getCap((Player)player).setElement(Element.NONE);
                }
                if (CapabilityRegistry.getCap((Player)player).getElement2().equals((Object)element)) {
                    CapabilityRegistry.getCap((Player)player).setElement2(Element.NONE);
                }
                SyncCapabilityManager.sync((Player)player);
            }
        }
        return true;
    }
}

