/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.client.gui.EtherLoomScreen;
import it.mralxart.etheria.client.gui.FadeScreen;
import it.mralxart.etheria.epicora.animations.base.IAnimated;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.animations.util.AnimationsLoader;
import it.mralxart.etheria.epicora.geometry.util.GeometryLoader;
import it.mralxart.etheria.handlers.ConfigCommandHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class S2CPacket {
    private final CompoundTag tag;
    private final int action;

    public S2CPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
        this.action = buf.readInt();
    }

    public S2CPacket(CompoundTag tag, int action) {
        this.tag = tag;
        this.action = action;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.writeInt(this.action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClint);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClint() {
        switch (this.action) {
            case 1: {
                Minecraft.m_91087_().m_91152_((Screen)new FadeScreen(this.tag.m_128461_("text"), this.tag.m_128451_("time"), this.tag.m_128451_("fade"), this.tag.m_128451_("color")));
                break;
            }
            case 2: {
                Minecraft.m_91087_().m_91152_((Screen)new EtherLoomScreen());
                break;
            }
            case 111: {
                ConfigCommandHandler.loadConfig(this.tag.m_128461_("configKey"), this.tag.m_128461_("json"));
                break;
            }
            case 112: {
                Entity entity;
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null || !((entity = world.m_6815_(this.tag.m_128451_("entityId"))) instanceof IAnimated)) break;
                IAnimated animated = (IAnimated)entity;
                AnimationController controller = animated.getController();
                controller.deserializeNBT(this.tag);
                break;
            }
            case 113: {
                BlockPos pos;
                Object controller;
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null || !((controller = world.m_46745_(pos = new BlockPos(this.tag.m_128451_("x"), this.tag.m_128451_("y"), this.tag.m_128451_("z"))).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE)) instanceof IAnimatedTile)) break;
                IAnimatedTile animated = (IAnimatedTile)controller;
                controller = animated.getController();
                ((AnimationController)controller).deserializeNBT(this.tag.m_128469_("controller"));
                break;
            }
            case 201: {
                GeometryLoader.init();
                AnimationsLoader.init();
            }
        }
    }
}

