/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.items.SpellScrollItem;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SlotChangePacket {
    private final int slotId;
    private final int actionId;
    private final ItemStack stack;
    private final ItemStack newStack;

    public SlotChangePacket(int slotId, int actionId, ItemStack stack, ItemStack newStack) {
        this.slotId = slotId;
        this.actionId = actionId;
        this.stack = stack;
        this.newStack = newStack;
    }

    public static SlotChangePacket decode(FriendlyByteBuf buf) {
        int slotId = buf.readInt();
        int actionId = buf.readInt();
        ItemStack stack = buf.m_130267_();
        ItemStack newStack = buf.m_130267_();
        return new SlotChangePacket(slotId, actionId, stack, newStack);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.slotId);
        buf.writeInt(this.actionId);
        buf.m_130055_(this.stack);
        buf.m_130055_(this.newStack);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                if (this.actionId == 0) {
                    ItemStack upgradedItem = ArtifactStatsManager.levelUpStats(this.stack.m_41777_());
                    ItemUtils.replaceItemInInventory(player.m_150109_(), this.stack.m_41784_().m_128451_("etheria$slot_id"), upgradedItem);
                    ItemUtils.removeItemsFromInventory(player.m_150109_(), this.newStack.m_41777_(), 1);
                    player.m_150109_().m_6596_();
                } else if (this.actionId == 1) {
                    ItemStack transferItem = ArtifactStatsManager.transferStats(this.newStack.m_41777_(), this.stack.m_41777_());
                    ItemUtils.replaceItemInInventory(player.m_150109_(), this.stack.m_41777_(), transferItem);
                    ItemUtils.removeItemsFromInventory(player.m_150109_(), this.newStack.m_41777_(), 1);
                    player.m_150109_().m_6596_();
                } else if (this.actionId == 2) {
                    if (this.stack.m_41720_() instanceof SpellScrollItem && this.stack.m_41782_() && this.stack.m_41783_() != null && this.stack.m_41783_().m_128441_("spell_id")) {
                        Spell spell = ArtifactStatsManager.transferStats(this.newStack.m_41777_(), SpellsUtils.getSpell((Player)player, this.stack.m_41783_().m_128461_("spell_id")));
                        SpellsUtils.putSpell((Player)player, spell);
                        ItemUtils.removeItemsFromInventory(player.m_150109_(), this.newStack.m_41777_(), 1);
                    }
                } else if (this.actionId == 3) {
                    if (ArtifactStatsManager.getLevel(this.stack.m_41777_()) <= 0) {
                        ItemStack itemStack = ArtifactStatsManager.resetReroll(this.stack);
                        ItemUtils.replaceItemInInventory(player.m_150109_(), this.stack.m_41777_(), itemStack);
                        ItemUtils.removeItemsFromInventory(player.m_150109_(), this.newStack.m_41777_(), 1);
                    }
                } else if (this.actionId == 4) {
                    if (this.stack.m_41720_() instanceof SpellScrollItem && this.stack.m_41782_() && this.stack.m_41783_() != null && this.stack.m_41783_().m_128441_("spell_id") && !SpellsUtils.isMaxLevel((Player)player, this.stack.m_41783_().m_128461_("spell_id"))) {
                        Spell spell = SpellsUtils.getSpell((Player)player, this.stack.m_41783_().m_128461_("spell_id"));
                        spell.setLevel(spell.getLevel() + 1);
                        SpellsUtils.putSpell((Player)player, spell);
                        ItemUtils.removeItemsFromInventory(player.m_150109_(), this.newStack.m_41777_(), 1);
                    }
                } else if (this.actionId == 8) {
                    player.m_150109_().m_36054_(this.stack);
                } else if (this.actionId == 9) {
                    player.m_150109_().m_6836_(this.slotId, ItemStack.f_41583_);
                } else if (this.actionId == 28) {
                    Map<Integer, ItemStack> list = CapabilityRegistry.getCap((Player)player).getArtifacts();
                    list.remove(this.slotId);
                    CapabilityRegistry.getCap((Player)player).setArtifacts(list);
                    SyncCapabilityManager.sync((Player)player);
                    player.m_150109_().m_36054_(this.stack);
                } else if (this.actionId == 29) {
                    int artifactSlot = this.stack.m_41784_().m_128451_("etheria$slot_id");
                    CapabilityRegistry.getCap((Player)player).getArtifacts().put(artifactSlot, this.stack);
                    SyncCapabilityManager.sync((Player)player);
                    player.m_150109_().m_6836_(this.slotId, ItemStack.f_41583_);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

