/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.tiles.EtherAltarTile;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;

public class StartRitualPacket {
    private final BlockPos pos;

    public StartRitualPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public StartRitualPacket(BlockPos pos) {
        this.pos = pos;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return false;
        }
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_46745_(this.pos).m_5685_(this.pos, LevelChunk.EntityCreationType.IMMEDIATE);
        if (!(blockEntity instanceof EtherAltarTile)) {
            return false;
        }
        EtherAltarTile tile = (EtherAltarTile)blockEntity;
        level.m_7702_(this.pos);
        ItemStack handStack = player.m_21205_();
        ItemStack tileStack = tile.getStack();
        BlockState oldState = level.m_8055_(this.pos);
        if (tileStack.m_41619_()) {
            tile.setStack(handStack.m_41620_(1));
            if (handStack.m_41619_()) {
                player.m_5661_((Component)Component.m_237113_((String)tile.getRitualManager().startRitual(player)).m_130940_(ChatFormatting.RED), true);
            }
        } else if (player.m_6144_()) {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), tileStack));
            tile.setStack(ItemStack.f_41583_);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)tile.getRitualManager().startRitual(player)).m_130940_(ChatFormatting.RED), true);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            tile.getRitualManager().init(serverLevel, tile.m_58899_());
        }
        tile.m_6596_();
        level.m_7260_(this.pos, oldState, level.m_8055_(this.pos), 3);
        return true;
    }
}

