/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.registry;

import it.mralxart.etheria.Etheria;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;

public class AnimationRegistry {
    public static final Map<ResourceLocation, String> REGISTRY = new HashMap<ResourceLocation, String>();
    private static final List<CompletableFuture<Void>> registrationFutures = new ArrayList<CompletableFuture<Void>>();

    public static void registerAnimation(ResourceLocation key) {
        Object path = key.m_135815_();
        if (!((String)path).endsWith(".animation.json")) {
            path = ((String)path).endsWith(".json") ? ((String)path).substring(0, ((String)path).length() - 5) + ".animation.json" : (String)path + ".animation.json";
        }
        Etheria.LOGGER.info("Register Animation: " + (String)path);
        REGISTRY.put(key, (String)path);
    }

    public static CompletableFuture<Void> waitForAllRegistrations() {
        return CompletableFuture.allOf(registrationFutures.toArray(new CompletableFuture[0]));
    }

    public static CompletableFuture<Void> registerAnimationsFolder(ResourceLocation folderKey) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Path modelsPath = Paths.get(AnimationRegistry.class.getClassLoader().getResource("assets/" + folderKey.m_135827_() + "/" + folderKey.m_135815_()).toURI());
                Files.walk(modelsPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String relativePath = modelsPath.relativize((Path)file).toString().replace("\\", "/");
                    if (relativePath.endsWith(".animation.json")) {
                        ResourceLocation key = new ResourceLocation(folderKey.m_135827_(), folderKey.m_135815_() + "/" + relativePath);
                        AnimationRegistry.registerAnimation(key);
                    }
                });
            }
            catch (Exception e) {
                Etheria.LOGGER.error("Error scanning folder: {}", (Object)folderKey.m_135815_(), (Object)e);
            }
        });
        registrationFutures.add(future);
        return future;
    }

    public static Map<ResourceLocation, String> getRegistry() {
        return REGISTRY;
    }

    public static void init() {
        AnimationRegistry.registerAnimationsFolder(new ResourceLocation("etheria", "animations"));
    }
}

