/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.registry;

import it.mralxart.etheria.capability.EntityCapability;
import it.mralxart.etheria.capability.EtheriaCapability;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CapabilityRegistry {
    public static final Capability<EtheriaCapability> ETHERIA = CapabilityManager.get((CapabilityToken)new CapabilityToken<EtheriaCapability>(){});
    public static final Capability<EntityCapability> ENTITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityCapability>(){});

    public static LazyOptional<EtheriaCapability> getEtheriaCapability(Player player) {
        return player.getCapability(ETHERIA);
    }

    public static Optional<EtheriaCapability> getCapability(Player player) {
        return player.getCapability(ETHERIA).resolve();
    }

    public static EntityCapability getEntityCap(Player player) {
        return player.getCapability(ENTITY).resolve().orElse(new EntityCapability());
    }

    public static EtheriaCapability getCap(Player player) {
        return CapabilityRegistry.getCapability(player).orElse(new EtheriaCapability());
    }

    @SubscribeEvent
    public static void onCapabilityRegistry(RegisterCapabilitiesEvent event) {
        event.register(EtheriaCapability.class);
        event.register(EntityCapability.class);
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("etheria", "etheria"), (ICapabilityProvider)new EtheriaCapability.Provider());
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("etheria", "entity"), (ICapabilityProvider)new EntityCapability.Provider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.reviveCaps();
        oldPlayer.getCapability(ETHERIA).ifPresent(oldData -> newPlayer.getCapability(ETHERIA).ifPresent(newData -> newData.deserializeNBT(oldData.serializeNBT())));
        oldPlayer.getCapability(ENTITY).ifPresent(oldData -> newPlayer.getCapability(ENTITY).ifPresent(newData -> newData.deserializeNBT(oldData.serializeNBT())));
        oldPlayer.invalidateCaps();
    }
}

