/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.blocks.BeamEmitter;
import it.mralxart.etheria.blocks.BeamRefractor;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.BeamRefractorTile;
import it.mralxart.etheria.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeamEmitterTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);
    private int ether = 0;
    private Direction direction = Direction.NORTH;

    public BeamEmitterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BEAM_EMITTER.get(), pos, state);
    }

    @Nullable
    private static Pair<BlockPos, Integer> findRefractor(Level level, BlockPos startPos, Direction direction) {
        for (int i = 1; i <= 16; ++i) {
            BlockPos checkPos = startPos.m_5484_(direction, i);
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60734_() instanceof BeamRefractor) {
                return Pair.of((Object)checkPos, (Object)i);
            }
            if (!(state.m_60734_() instanceof BeamEmitter)) continue;
            return Pair.of((Object)checkPos, (Object)i);
        }
        return null;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        BeamEmitterTile tile;
        if (t instanceof BeamEmitterTile) {
            tile = (BeamEmitterTile)t;
            tile.controller.tick();
        }
        if (level == null || level.f_46443_ || !(t instanceof BeamEmitterTile)) {
            return;
        }
        tile = (BeamEmitterTile)t;
        if (!level.isAreaLoaded(pos, 16)) {
            return;
        }
        if (tile.getEther() > 0) {
            tile.setEther(tile.getEther() - 1);
            Direction direction = tile.getDirection();
            Pair<BlockPos, Integer> refractorPos = BeamEmitterTile.findRefractor(level, pos, direction);
            Vec3 startPos = pos.m_252807_().m_82520_(0.0, 0.5, 0.0);
            if (refractorPos != null) {
                Vec3 endPos = Vec3.m_82512_((Vec3i)((Vec3i)refractorPos.getFirst())).m_82520_(0.0, 0.5, 0.0);
                BlockEntity blockEntity = level.m_7702_((BlockPos)refractorPos.getFirst());
                if (blockEntity instanceof BeamEmitterTile) {
                    BeamEmitterTile beamEmitterTile = (BeamEmitterTile)blockEntity;
                    beamEmitterTile.setEther(3);
                } else {
                    blockEntity = level.m_7702_((BlockPos)refractorPos.getFirst());
                    if (blockEntity instanceof BeamRefractorTile) {
                        BeamRefractorTile beamEmitterTile = (BeamRefractorTile)blockEntity;
                        beamEmitterTile.setEther(3);
                    }
                }
                ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 21 * (Integer)refractorPos.getSecond(), 0.25f), level, startPos, endPos, 1, 1.0f);
            } else {
                BlockPos checkPos = pos.m_5484_(direction, 3);
                ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 21, 0.25f), level, startPos, checkPos.m_252807_(), 1, 1.0f);
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (!compound.m_128461_("direction").isEmpty()) {
            this.direction = Direction.valueOf((String)compound.m_128461_("direction").toUpperCase());
        }
        this.ether = compound.m_128451_("ether");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("direction", this.direction.name().toLowerCase());
        compound.m_128405_("ether", this.ether);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public int getEther() {
        return this.ether;
    }

    public void setEther(int ether) {
        this.ether = ether;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }
}

