/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EtherAltarTile
extends BlockEntity
implements IAnimatedTile {
    private final AnimationController controller = new AnimationController(this);
    private RitualManager ritualManager;
    private Element element = Element.ETHER;
    private int tickCount;
    private ItemStack stack = ItemStack.f_41583_;

    public EtherAltarTile(BlockEntityType<?> p_155228_, BlockPos pos, BlockState state) {
        super(p_155228_, pos, state);
        this.ritualManager = new RitualManager();
    }

    public void m_142466_(CompoundTag compound) {
        Level level;
        super.m_142466_(compound);
        this.stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("stack")));
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.ritualManager.init(serverLevel, this.m_58899_());
        }
        this.element = Element.ofString(compound.m_128461_("etheria$element"));
        this.ritualManager.deserializeNBT(compound.m_128469_("ritualManager"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.stack != null) {
            CompoundTag itemStack = new CompoundTag();
            this.stack.m_41739_(itemStack);
            compound.m_128365_("stack", (Tag)itemStack);
        }
        compound.m_128359_("etheria$element", this.element.name().toLowerCase());
        compound.m_128365_("ritualManager", (Tag)this.ritualManager.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherAltarTile) {
            EtherAltarTile tile = (EtherAltarTile)t;
            if (tile.getTickCount() % 5 == 0 && !tile.getStack().m_41619_()) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ElementsUtils.getRandomColorByElement(tile.getElement()).getRGB(), Math.max(0.1f, level.f_46441_.m_188501_() / 4.0f), 20 + level.f_46441_.m_216339_(3, 30), 0.1f, 1.0f), (float)tile.m_58899_().m_123341_() + level.f_46441_.m_188501_(), (double)tile.m_58899_().m_123342_() + 0.7, (float)tile.m_58899_().m_123343_() + level.f_46441_.m_188501_(), 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
            if (tile.getRitualManager() == null) {
                return;
            }
            if (tile.getRitualManager().getAltarPos() == null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                tile.getRitualManager().init(serverLevel, pos);
            }
            tile.getRitualManager().tick(level, pos, tile.getTickCount());
            tile.setTickCount(tile.getTickCount() + 1);
            if (tile.getStack().m_41720_().equals(Items.f_42127_)) {
                tile.getRitualManager().setBlocked(true);
                tile.getRitualManager().setAltarElement(Element.AERO);
                tile.setElement(Element.AERO);
                tile.setStack(ItemStack.f_41583_);
            }
        }
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public RitualManager getRitualManager() {
        return this.ritualManager;
    }

    public void setRitualManager(RitualManager ritualManager) {
        this.ritualManager = ritualManager;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

