/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.loom.EtherLoomManager;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.TileRegistry;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EtherLoomTile
extends BlockEntity {
    private EtherLoomManager etherLoomManager;
    private ItemStack stack = ItemStack.f_41583_;
    private UUID player;
    private int tickCount;

    public EtherLoomTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ETHER_LOOM.get(), pos, state);
        this.etherLoomManager = new EtherLoomManager();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("stack")));
        EtherLoomManager manager = new EtherLoomManager();
        manager.deserializeNBT(compound.m_128469_("manager"));
        this.etherLoomManager = manager;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.stack != null) {
            CompoundTag itemStack = new CompoundTag();
            this.stack.m_41739_(itemStack);
            compound.m_128365_("stack", (Tag)itemStack);
        }
        compound.m_128365_("manager", (Tag)this.getEtherLoomManager().serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherLoomTile) {
            EtherLoomTile tile = (EtherLoomTile)t;
            if (tile.getEtherLoomManager() == null) {
                tile.etherLoomManager = new EtherLoomManager();
                return;
            }
            tile.getEtherLoomManager().tick();
            tile.setTickCount(tile.getTickCount() + 1);
            if (tile.getTickCount() % 5 == 0) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER).getRGB(), Math.max(0.1f, level.f_46441_.m_188501_() / 4.0f), 20 + level.f_46441_.m_216339_(3, 30), 0.1f, 1.0f), (float)tile.m_58899_().m_123341_() + level.f_46441_.m_188501_(), (double)tile.m_58899_().m_123342_() + 0.7, (float)tile.m_58899_().m_123343_() + level.f_46441_.m_188501_(), 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
        }
    }

    public EtherLoomManager getEtherLoomManager() {
        return this.etherLoomManager;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public void setPlayer(UUID player) {
        this.player = player;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }
}

