/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class EtherPedestalTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);
    public ItemStack itemStack = ItemStack.f_41583_;
    private float progress = 0.0f;
    private boolean isBlocked = false;
    private boolean isGenerated = false;
    public float randomId;
    private Element element = Element.ETHER;

    public EtherPedestalTile(BlockEntityType<?> p_155228_, BlockPos pos, BlockState state) {
        super(p_155228_, pos, state);
        this.randomId = new Random().nextInt(1, 60);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherPedestalTile) {
            EtherPedestalTile etherPedestalTile = (EtherPedestalTile)t;
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("stack")));
        this.progress = compound.m_128457_("progress");
        this.element = Element.valueOf(compound.m_128461_("element").toUpperCase());
        this.isBlocked = compound.m_128471_("isBlocked");
        this.isGenerated = compound.m_128471_("isGenerated");
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.itemStack != null) {
            CompoundTag stack = new CompoundTag();
            this.itemStack.m_41739_(stack);
            compound.m_128365_("stack", (Tag)stack);
        }
        compound.m_128350_("progress", this.progress);
        compound.m_128359_("element", this.element.toString().toUpperCase());
        compound.m_128379_("isBlocked", this.isBlocked);
        compound.m_128379_("isGenerated", this.isGenerated);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            BlockPos pos;
            LevelAccessor level = event.getLevel();
            if (!(level.m_7702_(pos = event.getPos()) instanceof EtherPedestalTile)) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RitualManager.breakRitual((Level)serverLevel, event.getPos());
            }
        }
    }
}

