/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.items.base.IEtherPedestal;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherPedestalTile;
import it.mralxart.etheria.utils.BlockUtils;
import it.mralxart.etheria.utils.ColorUtils;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EtherSourceTile
extends BlockEntity
implements IAnimatedTile {
    private final AnimationController controller = new AnimationController(this);
    public int ether = 100;
    public int maxEther = 100;
    public int tickCount = 0;

    public EtherSourceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ETHER_SOURCE.get(), pos, state);
        this.randomEther();
    }

    public void randomEther() {
        Random random = new Random();
        int randomInt = random.nextInt(5);
        switch (randomInt) {
            case 0: {
                this.ether = 50;
                this.maxEther = 50;
                break;
            }
            case 1: {
                this.ether = 100;
                this.maxEther = 100;
                break;
            }
            case 2: {
                this.ether = 130;
                this.maxEther = 130;
                break;
            }
            case 3: {
                this.ether = 150;
                this.maxEther = 150;
                break;
            }
            case 4: {
                this.ether = 200;
                this.maxEther = 200;
            }
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherSourceTile) {
            EtherSourceTile tile = (EtherSourceTile)t;
            tile.controller.tick();
            tile.setTickCount(tile.getTickCount() + 1);
            double angle = Math.PI * 2 * (double)level.f_46441_.m_188501_();
            double radius = 0.7f;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            if (tile.getEther() > 0) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249)), Math.max(0.05f, level.f_46441_.m_188501_() / 2.0f), tile.getEther() / 2 + level.f_46441_.m_216339_(3, 10), 0.1f, 1.0f), (double)tile.m_58899_().m_123341_() + 0.5 + offsetX, (double)tile.m_58899_().m_123342_() + 0.7, (double)tile.m_58899_().m_123343_() + 0.5 + offsetZ, 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
            List<BlockPos> pedestalPositions = BlockUtils.findBlocks(level, pos, 4, IEtherPedestal.class);
            if (tile.getTickCount() % 20 == 0) {
                for (BlockPos pedestalPos : pedestalPositions) {
                    int maxItemEther;
                    Item item;
                    EtherPedestalTile pedestalTile;
                    ItemStack itemStack;
                    BlockEntity blockEntity = level.m_7702_(pedestalPos);
                    if (!(blockEntity instanceof EtherPedestalTile) || (itemStack = (pedestalTile = (EtherPedestalTile)blockEntity).getItemStack()).m_41619_() || !((item = itemStack.m_41720_()) instanceof IEtherEntryItem)) continue;
                    IEtherEntryItem item2 = (IEtherEntryItem)item;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        AchievementHandler.grantAdvancementInRadius(serverLevel, pos.m_252807_(), 3.0, "ether_source");
                    }
                    int etherAmount = tile.getEther();
                    int itemEther = EtherUtils.getEther(itemStack);
                    if (itemEther >= (maxItemEther = item2.getMaxEther()) || etherAmount <= 0) continue;
                    int transferAmount = Math.min(5, etherAmount);
                    EtherUtils.setEther(itemStack, itemEther + transferAmount);
                    tile.setEther(etherAmount - transferAmount);
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249)), Math.max(0.2f, level.f_46441_.m_188501_() / 2.0f), 10 + level.f_46441_.m_216339_(3, 10), 0.1f, 1.0f), level, new Vec3((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5), new Vec3((double)pedestalPos.m_123341_() + 0.5, (double)pedestalPos.m_123342_() + 0.5, (double)pedestalPos.m_123343_() + 0.5), 20, 0.01f);
                }
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.tickCount = compound.m_128451_("tickCount");
        this.ether = compound.m_128451_("ether");
        this.maxEther = compound.m_128451_("maxEther");
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tickCount", this.tickCount);
        compound.m_128405_("ether", this.ether);
        compound.m_128405_("maxEther", this.maxEther);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public int getEther() {
        return this.ether;
    }

    public void setEther(int ether) {
        this.ether = ether;
    }

    public int getMaxEther() {
        return this.maxEther;
    }

    public void setMaxEther(int maxEther) {
        this.maxEther = maxEther;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }
}

