/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.blocks.base.IFreezingBlock;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.utils.ColorUtils;
import java.awt.Color;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class IceSourceTile
extends BlockEntity
implements IAnimatedTile,
IFreezingBlock {
    private final AnimationController controller = new AnimationController(this);
    private final float freezingRadius = new Random().nextInt(5, 10);
    public boolean active = true;
    public int thawing = 0;
    public int tickCount = 0;

    public IceSourceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ICE_SOURCE.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof IceSourceTile) {
            IceSourceTile tile = (IceSourceTile)t;
            tile.controller.tick();
            tile.setTickCount(tile.getTickCount() + 1);
            if (tile.getThawing() > 0) {
                tile.setThawing(tile.getThawing() - 1);
            }
            double angle = Math.PI * 2 * (double)level.f_46441_.m_188501_();
            double radius = 0.35f;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            if (tile.thawing == 0 && tile.isActive()) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(6068679), new Color(15596799), new Color(11199732), new Color(9098979)), Math.max(0.05f, level.f_46441_.m_188501_() / 2.0f), 40 + level.f_46441_.m_216339_(3, 10), 0.05f, 1.0f), (double)tile.m_58899_().m_123341_() + 0.5 + offsetX, (double)tile.m_58899_().m_123342_() + 0.55, (double)tile.m_58899_().m_123343_() + 0.5 + offsetZ, 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.5) / 2.0, 0.0));
                if (tile.getTickCount() % 60 == 0) {
                    radius = tile.getFreezingRadius();
                    int i = 0;
                    while ((double)i < 6.0 * radius) {
                        angle = Math.PI * 2 * ((double)i / radius / 6.0);
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(6068679), new Color(15596799), new Color(11199732), new Color(9098979)), Math.max(0.08f, level.f_46441_.m_188501_() / 1.5f), 60 + level.f_46441_.m_216339_(3, 10), 0.05f, 1.0f), (double)tile.m_58899_().m_123341_() + 0.5 + offsetX, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5 + offsetZ, 0.0, (double)0.02f / ((double)tile.m_58899_().m_123342_() - 0.9 - (double)tile.m_58899_().m_123342_() + 0.5) / 2.0, 0.0));
                        ++i;
                    }
                }
            } else if (tile.thawing > 0) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(15509909), new Color(12148061), new Color(15509909), new Color(15596799), new Color(11199732), new Color(9098979)), Math.max(0.03f, level.f_46441_.m_188501_() / 2.0f), 30 + level.f_46441_.m_216339_(3, 10), 0.05f, 1.0f), (double)tile.m_58899_().m_123341_() + 0.5 + offsetX, (double)tile.m_58899_().m_123342_() + 0.55, (double)tile.m_58899_().m_123343_() + 0.5 + offsetZ, 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.5) / 2.0, 0.0));
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.tickCount = compound.m_128451_("tickCount");
        this.thawing = compound.m_128451_("thawing");
        this.active = compound.m_128471_("active");
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tickCount", this.tickCount);
        compound.m_128405_("thawing", this.thawing);
        compound.m_128379_("active", this.active);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    @Override
    public float getFreezingRadius() {
        return this.freezingRadius;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getThawing() {
        return this.thawing;
    }

    public void setThawing(int thawing) {
        this.thawing = thawing;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }
}

