/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ReceiverTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);

    public ReceiverTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.RECEIVER.get(), pos, state);
    }

    public void receiveItem(ItemStack stack) {
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 6)) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(blockEntity instanceof Container)) {
            return;
        }
        Container container = (Container)blockEntity;
        int transferredCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack slotStack = container.m_8020_(i);
            if (slotStack.m_41619_()) {
                container.m_6836_(i, stack.m_41777_());
                transferredCount += stack.m_41613_();
                stack.m_41764_(0);
                break;
            }
            if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack)) continue;
            int transferable = Math.min(slotStack.m_41741_() - slotStack.m_41613_(), stack.m_41613_());
            slotStack.m_41769_(transferable);
            stack.m_41774_(transferable);
            transferredCount += transferable;
            if (stack.m_41619_()) break;
        }
        if (transferredCount > 0) {
            ParticleUtils.createInwardParticleCircle(this.f_58857_, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.25f, 30, 0.025f).setPhysic(true), this.f_58858_.m_252807_(), 0.3f, 3 + transferredCount, 1.2f);
        }
    }

    public boolean canReceiveItem(ItemStack stack) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = this.f_58857_ != null ? this.f_58857_.m_7702_(this.f_58858_.m_7495_()) : null;
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack slotStack = container.m_8020_(i);
                if (!slotStack.m_41619_() && !ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpace() {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = this.f_58857_ != null ? this.f_58857_.m_7702_(this.f_58858_.m_7495_()) : null;
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack slotStack = container.m_8020_(i);
                if (!slotStack.m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (!(t instanceof ReceiverTile)) {
            return;
        }
        ReceiverTile tile = (ReceiverTile)t;
        tile.controller.tick();
        ParticleUtils.createVelocityParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.2f, 30, 0.025f), pos.m_252807_().m_82520_(0.0, (double)-0.2f, 0.0), 2, 0.015f, -0.04f, 0.015f, 0.2f);
        BlockEntity blockEntity = level.m_7702_(tile.f_58858_.m_7495_());
        if (!(blockEntity instanceof Container)) {
            level.m_46961_(tile.m_58899_(), false);
            Block.m_49892_((BlockState)level.m_8055_(tile.m_58899_()), (LevelAccessor)level, (BlockPos)tile.m_58899_(), (BlockEntity)tile);
        }
    }
}

