/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.blocks.ReceiverBlock;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.ReceiverTile;
import it.mralxart.etheria.utils.BlockUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SenderTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);
    private BlockPos receiverPos = new BlockPos(0, 0, 0);

    public SenderTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.SENDER.get(), pos, state);
    }

    private static List<BlockPos> findReceiver(Level level, BlockPos worldPosition) {
        return BlockUtils.findBlocks(level, worldPosition, 1, ReceiverBlock.class);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        block15: {
            BlockEntity blockEntity;
            ReceiverTile receiver;
            SenderTile tile;
            block14: {
                if (!(t instanceof SenderTile)) {
                    return;
                }
                tile = (SenderTile)t;
                tile.controller.tick();
                if (level == null || level.f_46443_) {
                    return;
                }
                if (!level.isAreaLoaded(pos, 6)) {
                    return;
                }
                if (level.m_46467_() % 20L != 0L) {
                    if (!tile.receiverPos.equals((Object)new BlockPos(0, 0, 0))) {
                        ParticleUtils.createVelocityParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.2f, 30, 0.025f), pos.m_252807_().m_82520_(0.0, (double)-0.2f, 0.0), 2, 0.015f, -0.04f, 0.015f, 0.2f);
                    }
                    return;
                }
                if (Objects.equals(tile.receiverPos, new BlockPos(0, 0, 0))) {
                    return;
                }
                List<BlockPos> receiverPosList = SenderTile.findReceiver(level, tile.receiverPos);
                if (receiverPosList.isEmpty()) {
                    tile.receiverPos = new BlockPos(0, 0, 0);
                    return;
                }
                BlockPos receiverPos = receiverPosList.get(0);
                BlockEntity receiverEntity = level.m_7702_(receiverPos);
                if (!(receiverEntity instanceof ReceiverTile)) {
                    return;
                }
                receiver = (ReceiverTile)receiverEntity;
                blockEntity = level.m_7702_(pos.m_7495_());
                if (!(blockEntity instanceof Container) && !(blockEntity instanceof AbstractFurnaceBlockEntity)) {
                    level.m_46961_(tile.m_58899_(), false);
                    Block.m_49892_((BlockState)level.m_8055_(tile.m_58899_()), (LevelAccessor)level, (BlockPos)tile.m_58899_(), (BlockEntity)tile);
                }
                if (!(blockEntity instanceof AbstractFurnaceBlockEntity)) break block14;
                AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
                ItemStack result = furnace.m_8020_(2);
                if (result.m_41619_()) break block15;
                int transferAmount = Math.min(result.m_41613_(), 8);
                ItemStack toTransfer = result.m_41620_(transferAmount);
                if (receiver.canReceiveItem(toTransfer)) {
                    receiver.receiveItem(toTransfer);
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.2f, 30, 0.025f), tile.f_58858_.m_252807_().m_82520_(0.0, 0.25, 0.0), 5, 0.0, 0.0, 0.0, 0.005f);
                } else {
                    furnace.m_6836_(2, ItemStack.f_41583_);
                    furnace.m_8020_(2).m_41769_(toTransfer.m_41613_());
                }
                break block15;
            }
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                for (int i = 0; i < container.m_6643_(); ++i) {
                    ItemStack stack = container.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    int transferAmount = Math.min(stack.m_41613_(), 8);
                    ItemStack toTransfer = stack.m_41620_(transferAmount);
                    if (receiver.canReceiveItem(toTransfer)) {
                        receiver.receiveItem(toTransfer);
                        ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.2f, 30, 0.025f), tile.f_58858_.m_252807_().m_82520_(0.0, 0.25, 0.0), transferAmount, 0.0, 0.0, 0.0, 0.005f);
                        break;
                    }
                    stack.m_41769_(toTransfer.m_41613_());
                    break;
                }
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.receiverPos = new BlockPos(compound.m_128451_("etheria$receiverPosX"), compound.m_128451_("etheria$receiverPosY"), compound.m_128451_("etheria$receiverPosZ"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.receiverPos != null) {
            compound.m_128405_("etheria$receiverPosX", this.receiverPos.m_123341_());
            compound.m_128405_("etheria$receiverPosY", this.receiverPos.m_123342_());
            compound.m_128405_("etheria$receiverPosZ", this.receiverPos.m_123343_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public BlockPos getReceiverPos() {
        return this.receiverPos;
    }

    public void setReceiverPos(BlockPos receiverPos) {
        this.receiverPos = receiverPos;
    }
}

