/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Vector3f;

public class NbtUtils {
    public static int getInt(ItemStack stack, String tag) {
        return stack.m_41784_().m_128451_(tag);
    }

    public static void putInt(ItemStack stack, String tag, int data) {
        stack.m_41784_().m_128405_(tag, data);
    }

    @Nullable
    public static BlockPos getBlockPos(ItemStack stack, String tag) {
        if (stack.m_41783_() != null && !stack.m_41783_().m_128441_(tag + "_x")) {
            return null;
        }
        return new BlockPos(NbtUtils.getInt(stack, tag + "_x"), NbtUtils.getInt(stack, tag + "_y"), NbtUtils.getInt(stack, tag + "_z"));
    }

    public static void putBlockPos(ItemStack stack, String tag, BlockPos data) {
        if (data == null) {
            stack.m_41749_(tag + "_x");
            stack.m_41749_(tag + "_y");
            stack.m_41749_(tag + "_z");
            return;
        }
        stack.m_41784_().m_128405_(tag + "_x", data.m_123341_());
        stack.m_41784_().m_128405_(tag + "_y", data.m_123342_());
        stack.m_41784_().m_128405_(tag + "_z", data.m_123343_());
    }

    public static String getString(ItemStack stack, String tag) {
        return stack.m_41784_().m_128461_(tag);
    }

    public static void putString(ItemStack stack, String tag, String data) {
        stack.m_41784_().m_128359_(tag, data);
    }

    public static CompoundTag writeVector3f(Vector3f vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", vec.x());
        tag.m_128350_("y", vec.y());
        tag.m_128350_("z", vec.z());
        return tag;
    }

    public static Vector3f readVector3f(CompoundTag tag) {
        return new Vector3f(tag.m_128457_("x"), tag.m_128457_("y"), tag.m_128457_("z"));
    }

    public static CompoundTag serialize(Object instance) {
        CompoundTag tag = new CompoundTag();
        if (instance == null) {
            return tag;
        }
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoSerialize.class)) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) continue;
                tag.m_128391_(NbtUtils.serialize(field.getName(), value));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return tag;
    }

    public static CompoundTag serialize(String key, Object value) {
        CompoundTag tag = new CompoundTag();
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            tag.m_128405_(key, val.intValue());
        } else if (value instanceof Long) {
            Long val = (Long)value;
            tag.m_128356_(key, val.longValue());
        } else if (value instanceof Float) {
            Float val = (Float)value;
            tag.m_128350_(key, val.floatValue());
        } else if (value instanceof Double) {
            Double val = (Double)value;
            tag.m_128347_(key, val.doubleValue());
        } else if (value instanceof Byte) {
            Byte val = (Byte)value;
            tag.m_128344_(key, val.byteValue());
        } else if (value instanceof Boolean) {
            Boolean val = (Boolean)value;
            tag.m_128379_(key, val.booleanValue());
        } else if (value instanceof String) {
            String val = (String)value;
            tag.m_128359_(key, val);
        } else if (value instanceof UUID) {
            UUID val = (UUID)value;
            tag.m_128362_(key, val);
        } else if (value instanceof Enum) {
            Enum val = (Enum)value;
            tag.m_128359_(key, val.name());
        } else if (value instanceof BlockPos) {
            BlockPos pos = (BlockPos)value;
            tag.m_128356_(key, pos.m_121878_());
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return tag;
            }
            ListTag listTag = new ListTag();
            for (Object element : list) {
                if (element instanceof String) {
                    String s = (String)element;
                    listTag.add((Object)StringTag.m_129297_((String)s));
                    continue;
                }
                if (element instanceof Integer) {
                    Integer i = (Integer)element;
                    listTag.add((Object)IntTag.m_128679_((int)i));
                    continue;
                }
                if (element instanceof Long) {
                    Long l = (Long)element;
                    listTag.add((Object)LongTag.m_128882_((long)l));
                    continue;
                }
                if (element instanceof INBTSerializable) {
                    INBTSerializable serializable = (INBTSerializable)element;
                    listTag.add((Object)serializable.serializeNBT());
                    continue;
                }
                listTag.add((Object)NbtUtils.serialize(element));
            }
            if (!listTag.isEmpty()) {
                tag.m_128365_(key, (Tag)listTag);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            CompoundTag mapTag = new CompoundTag();
            for (Map.Entry entry : map.entrySet()) {
                mapTag.m_128391_(NbtUtils.serialize(entry.getKey().toString(), entry.getValue()));
            }
            tag.m_128365_(key, (Tag)mapTag);
        } else if (value instanceof INBTSerializable) {
            INBTSerializable serializable = (INBTSerializable)value;
            tag.m_128365_(key, serializable.serializeNBT());
        } else {
            tag.m_128365_(key, (Tag)NbtUtils.serialize(value));
        }
        return tag;
    }

    public static <T> T deserialize(T instance, CompoundTag tag) {
        if (instance == null || tag == null) {
            return instance;
        }
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoSerialize.class)) continue;
            field.setAccessible(true);
            String key = field.getName();
            if (!tag.m_128441_(key)) continue;
            try {
                Class<?> type = field.getType();
                if (type == Integer.TYPE || type == Integer.class) {
                    field.set(instance, tag.m_128451_(key));
                    continue;
                }
                if (type == Long.TYPE || type == Long.class) {
                    field.set(instance, tag.m_128454_(key));
                    continue;
                }
                if (type == Float.TYPE || type == Float.class) {
                    field.set(instance, Float.valueOf(tag.m_128457_(key)));
                    continue;
                }
                if (type == Double.TYPE || type == Double.class) {
                    field.set(instance, tag.m_128459_(key));
                    continue;
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    field.set(instance, tag.m_128445_(key));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    field.set(instance, tag.m_128471_(key));
                    continue;
                }
                if (type == String.class) {
                    field.set(instance, tag.m_128461_(key));
                    continue;
                }
                if (type == UUID.class) {
                    field.set(instance, tag.m_128342_(key));
                    continue;
                }
                if (type.isEnum()) {
                    field.set(instance, Enum.valueOf(type, tag.m_128461_(key)));
                    continue;
                }
                if (type == BlockPos.class) {
                    field.set(instance, BlockPos.m_122022_((long)tag.m_128454_(key)));
                    continue;
                }
                if (List.class.isAssignableFrom(type)) {
                    ListTag listTag = tag.m_128437_(key, 10);
                    if (listTag.isEmpty()) {
                        listTag = tag.m_128437_(key, 8);
                    }
                    if (listTag.isEmpty()) continue;
                    ArrayList<Object> newList = new ArrayList<Object>();
                    Class<?> listContentType = NbtUtils.getGenericComponentType(field);
                    if (listContentType == null) continue;
                    for (Tag elementTag : listTag) {
                        if (listContentType == String.class) {
                            newList.add(elementTag.m_7916_());
                            continue;
                        }
                        if (listContentType == Integer.class) {
                            newList.add(((NumericTag)elementTag).m_7047_());
                            continue;
                        }
                        if (listContentType == Long.class) {
                            newList.add(((NumericTag)elementTag).m_7046_());
                            continue;
                        }
                        Object listItem = listContentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (listItem instanceof INBTSerializable) {
                            ((INBTSerializable)listItem).deserializeNBT(elementTag);
                        } else {
                            NbtUtils.deserialize(listItem, (CompoundTag)elementTag);
                        }
                        newList.add(listItem);
                    }
                    field.set(instance, newList);
                    continue;
                }
                if (Map.class.isAssignableFrom(type)) {
                    HashMap<String, Integer> newMap;
                    CompoundTag mapTag = tag.m_128469_(key);
                    Class<?> keyType = NbtUtils.getGenericMapKeyType(field);
                    Class<?> valueType = NbtUtils.getGenericMapValueType(field);
                    if (keyType != String.class || valueType == null) continue;
                    if (valueType == Integer.class) {
                        newMap = new HashMap<String, Integer>();
                        for (String mapKey : mapTag.m_128431_()) {
                            newMap.put(mapKey, mapTag.m_128451_(mapKey));
                        }
                        field.set(instance, newMap);
                        continue;
                    }
                    newMap = new HashMap();
                    for (String mapKey : mapTag.m_128431_()) {
                        Object mapValue = valueType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        NbtUtils.deserialize(mapValue, mapTag.m_128469_(mapKey));
                        newMap.put(mapKey, (Integer)mapValue);
                    }
                    field.set(instance, newMap);
                    continue;
                }
                Object nestedObject = field.get(instance);
                if (nestedObject == null) {
                    nestedObject = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                NbtUtils.deserialize(nestedObject, tag.m_128469_(key));
                field.set(instance, nestedObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    @Nullable
    private static Object createInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> getGenericMapKeyType(Field field) {
        try {
            return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> getGenericMapValueType(Field field) {
        Type typeArgument;
        ParameterizedType paramType;
        Type[] types;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (types = (paramType = (ParameterizedType)type).getActualTypeArguments()).length > 1 && (typeArgument = types[1]) instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }

    private static Class<?> getGenericComponentType(Field field) {
        Type typeArgument;
        ParameterizedType paramType;
        Type[] types;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (types = (paramType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (typeArgument = types[0]) instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }
}

